/*
 * Decompiled with CFR 0.152.
 */
package org.granite.logging;

import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;
import org.granite.logging.Level;
import org.granite.logging.Logger;
import org.granite.logging.LoggingFormatter;

public class Log4jLogger
extends Logger {
    private static final String FQCN = Log4jLogger.class.getName();

    public Log4jLogger(String name, LoggingFormatter formatter) {
        super(LogManager.getLogger((String)name), formatter);
    }

    protected org.apache.log4j.Logger getLoggerImpl() {
        return (org.apache.log4j.Logger)super.getLoggerImpl();
    }

    public void info(String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)org.apache.log4j.Level.INFO, (Object)this.getFormatter().format(message, args), null);
        }
    }

    public void info(Throwable t, String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)org.apache.log4j.Level.INFO, (Object)this.getFormatter().format(message, args), t);
        }
    }

    public void trace(String message, Object ... args) {
        if (this.isTraceEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)org.apache.log4j.Level.TRACE, (Object)this.getFormatter().format(message, args), null);
        }
    }

    public void trace(Throwable t, String message, Object ... args) {
        if (this.isTraceEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)org.apache.log4j.Level.TRACE, (Object)this.getFormatter().format(message, args), t);
        }
    }

    public void warn(String message, Object ... args) {
        if (this.isWarnEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)org.apache.log4j.Level.WARN, (Object)this.getFormatter().format(message, args), null);
        }
    }

    public void warn(Throwable t, String message, Object ... args) {
        if (this.isWarnEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)org.apache.log4j.Level.WARN, (Object)this.getFormatter().format(message, args), t);
        }
    }

    public void debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)org.apache.log4j.Level.DEBUG, (Object)this.getFormatter().format(message, args), null);
        }
    }

    public void debug(Throwable t, String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)org.apache.log4j.Level.DEBUG, (Object)this.getFormatter().format(message, args), t);
        }
    }

    public void error(String message, Object ... args) {
        if (this.isErrorEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)org.apache.log4j.Level.ERROR, (Object)this.getFormatter().format(message, args), null);
        }
    }

    public void error(Throwable t, String message, Object ... args) {
        if (this.isErrorEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)org.apache.log4j.Level.ERROR, (Object)this.getFormatter().format(message, args), t);
        }
    }

    public void fatal(String message, Object ... args) {
        if (this.isFatalEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)org.apache.log4j.Level.FATAL, (Object)this.getFormatter().format(message, args), null);
        }
    }

    public void fatal(Throwable t, String message, Object ... args) {
        if (this.isFatalEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)org.apache.log4j.Level.FATAL, (Object)this.getFormatter().format(message, args), t);
        }
    }

    public void setLevel(Level level) {
        org.apache.log4j.Level log4jLevel = null;
        switch (level) {
            case FATAL: {
                log4jLevel = org.apache.log4j.Level.FATAL;
                break;
            }
            case ERROR: {
                log4jLevel = org.apache.log4j.Level.ERROR;
                break;
            }
            case INFO: {
                log4jLevel = org.apache.log4j.Level.INFO;
                break;
            }
            case TRACE: {
                log4jLevel = org.apache.log4j.Level.TRACE;
                break;
            }
            case DEBUG: {
                log4jLevel = org.apache.log4j.Level.DEBUG;
                break;
            }
            case WARN: {
                log4jLevel = org.apache.log4j.Level.WARN;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown logging level: " + (Object)((Object)level));
            }
        }
        this.getLoggerImpl().setLevel(log4jLevel);
    }

    public boolean isDebugEnabled() {
        return this.getLoggerImpl().isEnabledFor((Priority)org.apache.log4j.Level.DEBUG);
    }

    public boolean isErrorEnabled() {
        return this.getLoggerImpl().isEnabledFor((Priority)org.apache.log4j.Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.getLoggerImpl().isEnabledFor((Priority)org.apache.log4j.Level.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.getLoggerImpl().isEnabledFor((Priority)org.apache.log4j.Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.getLoggerImpl().isEnabledFor((Priority)org.apache.log4j.Level.TRACE);
    }

    public boolean isWarnEnabled() {
        return this.getLoggerImpl().isEnabledFor((Priority)org.apache.log4j.Level.WARN);
    }
}

