/*
 * Decompiled with CFR 0.152.
 */
package org.granite.jmx;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.granite.jmx.MBean;
import org.granite.jmx.MBeanAttribute;
import org.granite.jmx.MBeanOperation;
import org.granite.jmx.MBeanParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMBean
implements DynamicMBean {
    private static final Map<Class<?>, SimpleType> SIMPLE_TYPES = new HashMap();
    private final MBeanInfo info;
    private final Object instance;
    private final Map<String, PropertyDescriptor> attributesMap = new HashMap<String, PropertyDescriptor>();
    private final Map<String, MethodDescriptor> operationsMap = new HashMap<String, MethodDescriptor>();

    static {
        SIMPLE_TYPES.put(Void.class, SimpleType.VOID);
        SIMPLE_TYPES.put(Void.TYPE, SimpleType.VOID);
        SIMPLE_TYPES.put(Boolean.class, SimpleType.BOOLEAN);
        SIMPLE_TYPES.put(Boolean.TYPE, SimpleType.BOOLEAN);
        SIMPLE_TYPES.put(Character.class, SimpleType.CHARACTER);
        SIMPLE_TYPES.put(Character.TYPE, SimpleType.CHARACTER);
        SIMPLE_TYPES.put(Byte.class, SimpleType.BYTE);
        SIMPLE_TYPES.put(Byte.TYPE, SimpleType.BYTE);
        SIMPLE_TYPES.put(Short.class, SimpleType.SHORT);
        SIMPLE_TYPES.put(Short.TYPE, SimpleType.SHORT);
        SIMPLE_TYPES.put(Integer.class, SimpleType.INTEGER);
        SIMPLE_TYPES.put(Integer.TYPE, SimpleType.INTEGER);
        SIMPLE_TYPES.put(Long.class, SimpleType.LONG);
        SIMPLE_TYPES.put(Long.TYPE, SimpleType.LONG);
        SIMPLE_TYPES.put(Float.class, SimpleType.FLOAT);
        SIMPLE_TYPES.put(Float.TYPE, SimpleType.FLOAT);
        SIMPLE_TYPES.put(Double.class, SimpleType.DOUBLE);
        SIMPLE_TYPES.put(Double.TYPE, SimpleType.DOUBLE);
        SIMPLE_TYPES.put(String.class, SimpleType.STRING);
        SIMPLE_TYPES.put(BigDecimal.class, SimpleType.BIGDECIMAL);
        SIMPLE_TYPES.put(BigInteger.class, SimpleType.BIGINTEGER);
        SIMPLE_TYPES.put(Date.class, SimpleType.DATE);
        SIMPLE_TYPES.put(ObjectName.class, SimpleType.OBJECTNAME);
    }

    protected OpenMBean() {
        this.info = OpenMBean.init(this.getClass(), OpenMBean.class, this.attributesMap, this.operationsMap);
        this.instance = this;
    }

    private OpenMBean(Class<?> beanClass, Class<?> stopClass, Object instance) {
        this.info = OpenMBean.init(beanClass, stopClass, this.attributesMap, this.operationsMap);
        this.instance = instance;
    }

    public static OpenMBean createMBean(Object instance) {
        Class<?> beanClass = instance.getClass();
        String interMBeanName = String.valueOf(beanClass.getSimpleName()) + "MBean";
        Class<?>[] classArray = instance.getClass().getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> inter = classArray[n2];
            if (interMBeanName.equals(inter.getSimpleName())) {
                beanClass = inter;
                break;
            }
            ++n2;
        }
        Class<Object> stopClass = null;
        if (!beanClass.isInterface() && (stopClass = beanClass.getSuperclass()) == null) {
            stopClass = Object.class;
        }
        return new OpenMBean(beanClass, stopClass, instance);
    }

    public static OpenMBean createMBean(Class<?> beanClass, Object instance) {
        if (!beanClass.isAssignableFrom(instance.getClass())) {
            throw new IllegalArgumentException("Instance " + instance + " should be an instance of " + beanClass);
        }
        Class<Object> stopClass = null;
        if (!beanClass.isInterface() && (stopClass = beanClass.getSuperclass()) == null) {
            stopClass = Object.class;
        }
        return new OpenMBean(beanClass, stopClass, instance);
    }

    private static MBeanInfo init(Class<?> beanClass, Class<?> stopClass, Map<String, PropertyDescriptor> attributesMap, Map<String, MethodDescriptor> operationsMap) {
        MBean mb = beanClass.getAnnotation(MBean.class);
        String description = null;
        if (mb != null) {
            description = mb.description();
        }
        if (description == null) {
            description = String.valueOf(beanClass.getSimpleName()) + " MBean";
        }
        ArrayList<OpenMBeanAttributeInfoSupport> attributes = new ArrayList<OpenMBeanAttributeInfoSupport>();
        ArrayList<OpenMBeanOperationInfoSupport> operations = new ArrayList<OpenMBeanOperationInfoSupport>();
        try {
            String desc;
            String name;
            BeanInfo beanInfo = stopClass == null ? Introspector.getBeanInfo(beanClass) : Introspector.getBeanInfo(beanClass, stopClass);
            HashSet<Method> attributeMethods = new HashSet<Method>();
            FeatureDescriptor[] featureDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = featureDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor property = featureDescriptorArray[n2];
                MBeanAttribute mba = null;
                if (property.getReadMethod() != null) {
                    mba = property.getReadMethod().getAnnotation(MBeanAttribute.class);
                }
                if (mba == null && property.getWriteMethod() != null) {
                    mba = property.getWriteMethod().getAnnotation(MBeanAttribute.class);
                }
                name = property.getName();
                desc = null;
                if (mba != null) {
                    desc = mba.description();
                }
                if (desc == null) {
                    desc = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1) + " Attribute";
                }
                OpenType type = OpenMBean.getOpenType(property.getPropertyType());
                attributes.add(new OpenMBeanAttributeInfoSupport(name, desc, type, property.getReadMethod() != null, property.getWriteMethod() != null, property.getReadMethod() != null && property.getReadMethod().getName().startsWith("is")));
                attributesMap.put(property.getName(), property);
                if (property.getReadMethod() != null) {
                    attributeMethods.add(property.getReadMethod());
                }
                if (property.getWriteMethod() != null) {
                    attributeMethods.add(property.getWriteMethod());
                }
                ++n2;
            }
            featureDescriptorArray = beanInfo.getMethodDescriptors();
            n = featureDescriptorArray.length;
            n2 = 0;
            while (n2 < n) {
                FeatureDescriptor method = featureDescriptorArray[n2];
                if (!attributeMethods.contains(((MethodDescriptor)method).getMethod())) {
                    MBeanOperation mbo = ((MethodDescriptor)method).getMethod().getAnnotation(MBeanOperation.class);
                    name = method.getName();
                    desc = null;
                    if (mbo != null) {
                        desc = mbo.description();
                    }
                    if (desc == null) {
                        desc = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1) + " Operation";
                    }
                    ArrayList<OpenMBeanParameterInfoSupport> parameters = new ArrayList<OpenMBeanParameterInfoSupport>();
                    Annotation[][] annotations = ((MethodDescriptor)method).getMethod().getParameterAnnotations();
                    int i = 0;
                    Class<?>[] classArray = ((MethodDescriptor)method).getMethod().getParameterTypes();
                    int n3 = classArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Class<?> parameter = classArray[n4];
                        String paramName = OpenMBean.getParameterName(annotations, i);
                        String paramDesc = OpenMBean.getParameterDescription(annotations, i);
                        OpenType paramType = OpenMBean.getOpenType(parameter);
                        parameters.add(new OpenMBeanParameterInfoSupport(paramName, paramDesc, paramType));
                        ++i;
                        ++n4;
                    }
                    OpenType returnedType = OpenMBean.getOpenType(((MethodDescriptor)method).getMethod().getReturnType());
                    int impact = 3;
                    if (mbo != null && mbo.impact() != null) {
                        switch (mbo.impact()) {
                            case ACTION: {
                                impact = 1;
                                break;
                            }
                            case ACTION_INFO: {
                                impact = 2;
                                break;
                            }
                            case INFO: {
                                impact = 0;
                            }
                        }
                    }
                    operations.add(new OpenMBeanOperationInfoSupport(name, desc, parameters.toArray(new OpenMBeanParameterInfo[parameters.size()]), returnedType, impact));
                    Object[] paramClasses = new String[parameters.size()];
                    i = 0;
                    while (i < parameters.size()) {
                        paramClasses[i] = ((OpenMBeanParameterInfo)parameters.get(i)).getOpenType().getTypeName().toString();
                        ++i;
                    }
                    String qName = String.valueOf(name) + Arrays.toString(paramClasses);
                    operationsMap.put(qName, (MethodDescriptor)method);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not introspect MBean class: " + beanClass, e);
        }
        return new OpenMBeanInfoSupport(beanClass.getName(), description, attributes.toArray(new OpenMBeanAttributeInfo[attributes.size()]), new OpenMBeanConstructorInfo[0], operations.toArray(new OpenMBeanOperationInfo[operations.size()]), new MBeanNotificationInfo[0]);
    }

    private static String getParameterName(Annotation[][] paramAnnotations, int index) {
        String name = null;
        if (paramAnnotations != null && paramAnnotations.length > index) {
            Annotation[] annotationArray = paramAnnotations[index];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annot = annotationArray[n2];
                if (MBeanParameter.class.equals(annot.annotationType())) {
                    name = ((MBeanParameter)annot).name();
                    break;
                }
                ++n2;
            }
        }
        return name != null ? name : "arg" + (index + 1);
    }

    private static String getParameterDescription(Annotation[][] paramAnnotations, int index) {
        String description = null;
        if (paramAnnotations != null && paramAnnotations.length > index) {
            Annotation[] annotationArray = paramAnnotations[index];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annot = annotationArray[n2];
                if (MBeanParameter.class.equals(annot.annotationType())) {
                    description = ((MBeanParameter)annot).description();
                    break;
                }
                ++n2;
            }
        }
        return description != null ? description : "Operation Parameter " + (index + 1);
    }

    private static OpenType getOpenType(Class<?> clazz) throws OpenDataException {
        if (SIMPLE_TYPES.containsKey(clazz)) {
            return SIMPLE_TYPES.get(clazz);
        }
        if (clazz.isArray()) {
            int dimension = 1;
            Class<?> componentType = clazz.getComponentType();
            while (componentType.isArray()) {
                ++dimension;
                componentType = componentType.getComponentType();
            }
            return new ArrayType(dimension, OpenMBean.getOpenType(componentType));
        }
        throw new OpenDataException("Unsupported type: " + clazz);
    }

    @Override
    public synchronized Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        PropertyDescriptor property = this.attributesMap.get(attribute);
        if (property != null && property.getReadMethod() != null) {
            try {
                return property.getReadMethod().invoke(this.instance, new Object[0]);
            }
            catch (Exception e) {
                throw new ReflectionException(e, "Could not get attribute value: " + attribute);
            }
        }
        throw new AttributeNotFoundException("Attribute " + attribute + " not found");
    }

    @Override
    public synchronized AttributeList getAttributes(String[] names) {
        AttributeList attributes = new AttributeList();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                attributes.add(new Attribute(name, this.getAttribute(name)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return attributes;
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        return this.info;
    }

    @Override
    public synchronized Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        String qName;
        MethodDescriptor method;
        if (signature == null) {
            signature = new String[]{};
        }
        if ((method = this.operationsMap.get(qName = String.valueOf(actionName) + Arrays.toString(signature))) == null) {
            throw new RuntimeException("Method not found: " + qName);
        }
        try {
            return method.getMethod().invoke(this.instance, params);
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Could not invoke operation: " + qName);
        }
    }

    @Override
    public synchronized void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        PropertyDescriptor property = this.attributesMap.get(attribute.getName());
        if (property != null && property.getWriteMethod() != null) {
            try {
                property.getWriteMethod().invoke(this.instance, attribute.getValue());
            }
            catch (Exception e) {
                throw new ReflectionException(e, "Could not set attribute value: " + attribute.getName() + "=" + attribute.getValue());
            }
        } else {
            throw new AttributeNotFoundException("Attribute " + attribute.getName() + " not found");
        }
    }

    @Override
    public synchronized AttributeList setAttributes(AttributeList attributes) {
        AttributeList returnedAttributes = new AttributeList();
        for (Object a : attributes) {
            Attribute attribute = (Attribute)a;
            try {
                this.setAttribute(attribute);
                returnedAttributes.add(new Attribute(attribute.getName(), this.getAttribute(attribute.getName())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return returnedAttributes;
    }
}

