/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.gae;

import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.AsyncPublishedMessage;
import org.granite.gravity.Channel;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.MessagePublishingException;
import org.granite.gravity.MessageReceivingException;
import org.granite.gravity.Subscription;
import org.granite.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAEChannel
implements Channel,
Serializable {
    private static final long serialVersionUID = 5129029435795219401L;
    private static final Logger log = Logger.getLogger(GAEChannel.class);
    static final String MSG_COUNT_PREFIX = "org.granite.gravity.channel.msgCount.";
    static final String MSG_PREFIX = "org.granite.gravity.channel.msg.";
    private static MemcacheService gaeCache = MemcacheServiceFactory.getMemcacheService();
    protected final String id;
    private final Map<String, Subscription> subscriptions = new HashMap<String, Subscription>();
    private final long expiration;

    GAEChannel(ServletConfig servletConfig, GravityConfig gravityConfig, String id) {
        if (id == null) {
            throw new NullPointerException("id cannot be null");
        }
        this.id = id;
        this.expiration = gravityConfig.getChannelIdleTimeoutMillis();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Gravity getGravity() {
        return null;
    }

    private Long msgCount() {
        return (Long)gaeCache.get((Object)(MSG_COUNT_PREFIX + this.id));
    }

    @Override
    public void destroy() {
        Long msgCount = this.msgCount();
        if (msgCount != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(MSG_COUNT_PREFIX + this.id);
            long i = 0L;
            while (i < msgCount) {
                list.add(MSG_PREFIX + this.id + "#" + i);
                ++i;
            }
            gaeCache.deleteAll(list);
        }
        this.subscriptions.clear();
    }

    @Override
    public void publish(AsyncPublishedMessage message) throws MessagePublishingException {
        message.publish(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(AsyncMessage message) throws MessageReceivingException {
        log.debug("Publish message to channel %s", this.id);
        GAEChannel gAEChannel = this;
        synchronized (gAEChannel) {
            Long msgCount = this.msgCount();
            gaeCache.put((Object)(MSG_PREFIX + this.id + "#" + msgCount), (Object)message, Expiration.byDeltaMillis((int)((int)this.expiration)));
            gaeCache.increment((Object)(MSG_COUNT_PREFIX + this.id), 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> takeMessages() {
        log.debug("Try to take messages for channel %s", this.id);
        GAEChannel gAEChannel = this;
        synchronized (gAEChannel) {
            Long msgCount;
            block7: {
                msgCount = this.msgCount();
                if (msgCount != null && msgCount != 0L) break block7;
                return null;
            }
            log.debug("Taking %s messages", msgCount);
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while ((long)i < msgCount) {
                list.add(MSG_PREFIX + this.id + "#" + i);
                ++i;
            }
            Map msgs = gaeCache.getAll(list);
            ArrayList<Message> messages = new ArrayList<Message>();
            int i2 = 0;
            while ((long)i2 < msgCount) {
                Message msg = (Message)msgs.get(list.get(i2));
                if (msg != null) {
                    messages.add(msg);
                }
                ++i2;
            }
            gaeCache.deleteAll(list);
            gaeCache.put((Object)(MSG_COUNT_PREFIX + this.id), (Object)0L, Expiration.byDeltaMillis((int)((int)this.expiration)));
            return messages.isEmpty() ? null : messages;
        }
    }

    @Override
    public Subscription addSubscription(String destination, String subTopicId, String subscriptionId, boolean noLocal) {
        Subscription subscription = new Subscription(this, destination, subTopicId, subscriptionId, noLocal);
        this.subscriptions.put(subscriptionId, subscription);
        return subscription;
    }

    @Override
    public Collection<Subscription> getSubscriptions() {
        return this.subscriptions.values();
    }

    @Override
    public Subscription removeSubscription(String subscriptionId) {
        return this.subscriptions.remove(subscriptionId);
    }

    public boolean equals(Object obj) {
        return obj instanceof GAEChannel && this.id.equals(((GAEChannel)obj).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " {id=" + this.id + ", subscriptions=" + this.subscriptions + "}";
    }

    @Override
    public boolean hasPublishedMessage() {
        return false;
    }

    @Override
    public boolean runPublish() {
        return false;
    }

    @Override
    public boolean hasReceivedMessage() {
        return false;
    }

    @Override
    public boolean runReceive() {
        return false;
    }

    @Override
    public boolean runReceived(AsyncHttpContext asyncHttpContext) {
        return false;
    }

    public void run() {
    }
}

