/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.adapters;

import flex.messaging.messages.AsyncMessage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.granite.gravity.Channel;
import org.granite.gravity.Subscription;
import org.granite.gravity.adapters.SimpleServiceAdapter;
import org.granite.gravity.adapters.TopicId;

public class Topic {
    private final TopicId id;
    private final SimpleServiceAdapter serviceAdapter;
    private ConcurrentMap<String, Subscription> subscriptions = new ConcurrentHashMap<String, Subscription>();
    private ConcurrentMap<String, Topic> children = new ConcurrentHashMap<String, Topic>();
    private Topic wild;
    private Topic wildWild;

    public Topic(String topicId, SimpleServiceAdapter serviceAdapter) {
        this.id = new TopicId(topicId);
        this.serviceAdapter = serviceAdapter;
    }

    public String getId() {
        return this.id.toString();
    }

    public TopicId getTopicId() {
        return this.id;
    }

    public Topic getChild(TopicId topicId) {
        String next = topicId.getSegment(this.id.depth());
        if (next == null) {
            return null;
        }
        Topic topic = (Topic)this.children.get(next);
        if (topic == null || topic.getTopicId().depth() == topicId.depth()) {
            return topic;
        }
        return topic.getChild(topicId);
    }

    public void addChild(Topic topic) {
        TopicId child = topic.getTopicId();
        if (!this.id.isParentOf(child)) {
            throw new IllegalArgumentException(this.id + " not parent of " + child);
        }
        String next = child.getSegment(this.id.depth());
        if (child.depth() - this.id.depth() == 1) {
            Topic old = this.children.putIfAbsent(next, topic);
            if (old != null) {
                throw new IllegalArgumentException("Already Exists");
            }
            if ("*".equals(next)) {
                this.wild = topic;
            } else if ("**".equals(next)) {
                this.wildWild = topic;
            }
        } else {
            Topic branch = this.serviceAdapter.getTopic(String.valueOf(this.id.depth() == 0 ? "/" : String.valueOf(this.id.toString()) + "/") + next, true);
            branch.addChild(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Channel channel, String destination, String subscriptionId, String selector, boolean noLocal) {
        Topic topic = this;
        synchronized (topic) {
            Subscription subscription = channel.addSubscription(destination, this.getId(), subscriptionId, noLocal);
            subscription.setSelector(selector);
            this.subscriptions.putIfAbsent(subscriptionId, subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Channel channel, String subscriptionId) {
        Topic topic = this;
        synchronized (topic) {
            this.subscriptions.remove(subscriptionId);
            channel.removeSubscription(subscriptionId);
        }
    }

    public void publish(TopicId to, Channel fromChannel, AsyncMessage msg) {
        int tail = to.depth() - this.id.depth();
        switch (tail) {
            case 0: {
                for (Subscription subscription : this.subscriptions.values()) {
                    AsyncMessage m = msg.clone();
                    subscription.deliver(fromChannel, m);
                }
                break;
            }
            case 1: {
                AsyncMessage m;
                if (this.wild != null) {
                    for (Subscription subscription : this.wild.subscriptions.values()) {
                        m = msg.clone();
                        subscription.deliver(fromChannel, m);
                    }
                }
            }
            default: {
                String next;
                Topic topic;
                AsyncMessage m;
                if (this.wildWild != null) {
                    for (Subscription subscription : this.wildWild.subscriptions.values()) {
                        m = msg.clone();
                        subscription.deliver(fromChannel, m);
                    }
                }
                if ((topic = (Topic)this.children.get(next = to.getSegment(this.id.depth()))) == null) break;
                topic.publish(to, fromChannel, msg);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.id.toString()) + " {" + this.children.values() + "}";
    }
}

