/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.adapters;

import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.granite.gravity.Channel;
import org.granite.gravity.MessageReceivingException;
import org.granite.gravity.adapters.ServiceAdapter;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.AMF3Deserializer;
import org.granite.messaging.amf.io.AMF3Serializer;
import org.granite.messaging.service.ServiceException;
import org.granite.util.XMap;

public class JMSServiceAdapter
extends ServiceAdapter {
    private static final Logger log = Logger.getLogger(JMSServiceAdapter.class);
    protected ConnectionFactory jmsConnectionFactory = null;
    protected Destination jmsDestination = null;
    protected Map<String, JMSClient> jmsClients = new HashMap<String, JMSClient>();
    protected String destinationName = null;
    protected boolean textMessages = false;
    protected boolean transactedSessions = false;
    protected int acknowledgeMode = 1;
    protected int messagePriority = 4;
    protected int deliveryMode = 2;
    protected boolean noLocal = false;

    public void configure(XMap adapterProperties, XMap destinationProperties) throws ServiceException {
        super.configure(adapterProperties, destinationProperties);
        try {
            this.destinationName = destinationProperties.get("jms/destination-name");
            if (Boolean.TRUE.toString().equals(destinationProperties.get("jms/transacted-sessions"))) {
                this.transactedSessions = true;
            }
            if ("AUTO_ACKNOWLEDGE".equals(destinationProperties.get("jms/acknowledge-mode"))) {
                this.acknowledgeMode = 1;
            } else if ("CLIENT_ACKNOWLEDGE".equals(destinationProperties.get("jms/acknowledge-mode"))) {
                this.acknowledgeMode = 2;
            } else if ("DUPS_OK_ACKNOWLEDGE".equals(destinationProperties.get("jms/acknowledge-mode"))) {
                this.acknowledgeMode = 3;
            }
            if ("javax.jms.TextMessage".equals(destinationProperties.get("jms/message-type"))) {
                this.textMessages = true;
            }
            if (Boolean.TRUE.toString().equals(destinationProperties.get("jms/no-local"))) {
                this.noLocal = true;
            }
            Properties environment = new Properties();
            for (XMap property : destinationProperties.getAll("jms/initial-context-environment/property")) {
                String name = property.get("name");
                String value = property.get("value");
                if ("Context.PROVIDER_URL".equals(name)) {
                    environment.put("java.naming.provider.url", value);
                    continue;
                }
                if ("Context.INITIAL_CONTEXT_FACTORY".equals(name)) {
                    environment.put("java.naming.factory.initial", value);
                    continue;
                }
                if ("Context.URL_PKG_PREFIXES".equals(name)) {
                    environment.put("java.naming.factory.url.pkgs", value);
                    continue;
                }
                if ("Context.SECURITY_PRINCIPAL".equals(name)) {
                    environment.put("java.naming.security.principal", value);
                    continue;
                }
                if ("Context.SECURITY_CREDENTIALS".equals(name)) {
                    environment.put("java.naming.security.credentials", value);
                    continue;
                }
                log.warn("Unknown InitialContext property: %s (ignored)", name);
            }
            InitialContext ic = new InitialContext(environment.size() > 0 ? environment : null);
            String cfJndiName = destinationProperties.get("jms/connection-factory");
            this.jmsConnectionFactory = (ConnectionFactory)ic.lookup(cfJndiName);
            String dsJndiName = destinationProperties.get("jms/destination-jndi-name");
            this.jmsDestination = (Destination)ic.lookup(dsJndiName);
        }
        catch (Exception e) {
            throw new ServiceException("Error when configuring JMS Adapter", e);
        }
    }

    protected Destination getProducerDestination(String topic) {
        return this.jmsDestination;
    }

    protected Destination getConsumerDestination(String topic) {
        return this.jmsDestination;
    }

    public void start() throws ServiceException {
        super.start();
    }

    public void stop() throws ServiceException {
        super.stop();
        for (JMSClient jmsClient : this.jmsClients.values()) {
            jmsClient.close();
        }
    }

    private synchronized JMSClient createJMSClient(Channel client) throws Exception {
        JMSClient jmsClient = this.jmsClients.get(client.getId());
        if (jmsClient == null) {
            jmsClient = new JMSClient(client);
            jmsClient.connect();
            this.jmsClients.put(client.getId(), jmsClient);
        }
        return jmsClient;
    }

    public Object invoke(Channel fromClient, AsyncMessage message) {
        try {
            JMSClient jmsClient = this.createJMSClient(fromClient);
            jmsClient.send(message);
            AcknowledgeMessage reply = new AcknowledgeMessage(message);
            reply.setMessageId(message.getMessageId());
            return reply;
        }
        catch (Exception e) {
            ErrorMessage error = new ErrorMessage((Message)message, null);
            error.setFaultString("JMS Adapter error " + e.getMessage());
            return error;
        }
    }

    public Object manage(Channel fromChannel, CommandMessage message) {
        if (message.getOperation() == 0) {
            try {
                JMSClient jmsClient = this.createJMSClient(fromChannel);
                jmsClient.subscribe(message);
                AcknowledgeMessage reply = new AcknowledgeMessage(message);
                return reply;
            }
            catch (Exception e) {
                throw new RuntimeException("JMSAdapter invoke error on topic  message " + message, e);
            }
        }
        if (message.getOperation() == 1) {
            try {
                JMSClient jmsClient = this.createJMSClient(fromChannel);
                jmsClient.unsubscribe(message);
                AcknowledgeMessage reply = new AcknowledgeMessage(message);
                return reply;
            }
            catch (Exception e) {
                throw new RuntimeException("JMSAdapter invoke error on topic  message " + message, e);
            }
        }
        return null;
    }

    private class JMSClient {
        private Channel channel = null;
        private String topic = null;
        private Connection jmsConnection = null;
        private Session jmsProducerSession = null;
        private MessageProducer jmsProducer = null;
        private Map<String, JMSConsumer> consumers = new HashMap<String, JMSConsumer>();

        public JMSClient(Channel channel) {
            this.channel = channel;
        }

        public void connect() throws ServiceException {
            try {
                this.jmsConnection = JMSServiceAdapter.this.jmsConnectionFactory.createConnection();
                this.jmsConnection.start();
            }
            catch (JMSException e) {
                throw new ServiceException("JMS Initialize error", e);
            }
        }

        public void close() throws ServiceException {
            try {
                if (this.jmsProducer != null) {
                    this.jmsProducer.close();
                }
                if (this.jmsProducerSession != null) {
                    this.jmsProducerSession.close();
                }
                for (JMSConsumer consumer : this.consumers.values()) {
                    consumer.close();
                }
                this.jmsConnection.stop();
                this.jmsConnection.close();
            }
            catch (JMSException e) {
                throw new ServiceException("JMS Stop error", e);
            }
        }

        public void send(Message message) throws Exception {
            if (this.jmsProducerSession == null) {
                this.jmsProducerSession = this.jmsConnection.createSession(JMSServiceAdapter.this.transactedSessions, JMSServiceAdapter.this.acknowledgeMode);
            }
            if (this.jmsProducer == null) {
                this.jmsProducer = this.jmsProducerSession.createProducer(JMSServiceAdapter.this.getProducerDestination(this.topic));
                this.jmsProducer.setPriority(JMSServiceAdapter.this.messagePriority);
                this.jmsProducer.setDeliveryMode(JMSServiceAdapter.this.deliveryMode);
            }
            Object msg = null;
            if (Boolean.TRUE.equals(message.getHeader("GDS_BYTEARRAY_BODY"))) {
                byte[] byteArray = (byte[])message.getBody();
                ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
                AMF3Deserializer deser = new AMF3Deserializer(bais);
                msg = deser.readObject();
            } else {
                msg = message.getBody();
            }
            Object jmsMessage = null;
            jmsMessage = JMSServiceAdapter.this.textMessages ? this.jmsProducerSession.createTextMessage(msg.toString()) : this.jmsProducerSession.createObjectMessage((Serializable)msg);
            jmsMessage.setJMSMessageID(this.normalizeJMSMessageID(message.getMessageId()));
            jmsMessage.setJMSCorrelationID(this.normalizeJMSMessageID(((AsyncMessage)message).getCorrelationId()));
            jmsMessage.setJMSTimestamp(message.getTimestamp());
            jmsMessage.setJMSExpiration(message.getTimeToLive());
            for (Map.Entry<String, Object> me : message.getHeaders().entrySet()) {
                if ("JMSType".equals(me.getKey())) {
                    if (!(me.getValue() instanceof String)) continue;
                    jmsMessage.setJMSType((String)me.getValue());
                    continue;
                }
                if ("JMSPriority".equals(me.getKey())) {
                    if (!(me.getValue() instanceof Integer)) continue;
                    jmsMessage.setJMSPriority(((Integer)me.getValue()).intValue());
                    continue;
                }
                if (me.getValue() instanceof String) {
                    jmsMessage.setStringProperty(me.getKey(), (String)me.getValue());
                    continue;
                }
                if (me.getValue() instanceof Boolean) {
                    jmsMessage.setBooleanProperty(me.getKey(), ((Boolean)me.getValue()).booleanValue());
                    continue;
                }
                if (me.getValue() instanceof Integer) {
                    jmsMessage.setIntProperty(me.getKey(), ((Integer)me.getValue()).intValue());
                    continue;
                }
                if (me.getValue() instanceof Long) {
                    jmsMessage.setLongProperty(me.getKey(), ((Long)me.getValue()).longValue());
                    continue;
                }
                if (me.getValue() instanceof Double) {
                    jmsMessage.setDoubleProperty(me.getKey(), ((Double)me.getValue()).doubleValue());
                    continue;
                }
                jmsMessage.setObjectProperty(me.getKey(), me.getValue());
            }
            this.jmsProducer.send((javax.jms.Message)jmsMessage);
            if (JMSServiceAdapter.this.transactedSessions) {
                this.jmsProducerSession.commit();
            }
        }

        private String normalizeJMSMessageID(String messageId) {
            if (messageId != null && !messageId.startsWith("ID:")) {
                messageId = "ID:" + messageId;
            }
            return messageId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribe(Message message) throws Exception {
            String subscriptionId = (String)message.getHeader("DSDstClientId");
            String selector = (String)message.getHeader("DSSelector");
            this.topic = (String)message.getHeader("DSSubtopic");
            Map<String, JMSConsumer> map = this.consumers;
            synchronized (map) {
                JMSConsumer consumer = this.consumers.get(subscriptionId);
                if (consumer == null) {
                    consumer = new JMSConsumer(subscriptionId, selector, JMSServiceAdapter.this.noLocal);
                    this.consumers.put(subscriptionId, consumer);
                } else {
                    consumer.setSelector(selector);
                }
                this.channel.addSubscription(message.getDestination(), this.topic, subscriptionId, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unsubscribe(Message message) throws Exception {
            String subscriptionId = (String)message.getHeader("DSDstClientId");
            Map<String, JMSConsumer> map = this.consumers;
            synchronized (map) {
                JMSConsumer consumer = this.consumers.get(subscriptionId);
                if (consumer != null) {
                    consumer.close();
                }
                this.consumers.remove(subscriptionId);
                this.channel.removeSubscription(subscriptionId);
            }
        }

        private class JMSConsumer
        implements MessageListener {
            private String subscriptionId = null;
            private Session jmsConsumerSession = null;
            private MessageConsumer jmsConsumer = null;
            private boolean noLocal = false;

            public JMSConsumer(String subscriptionId, String selector, boolean noLocal) throws JMSException {
                this.subscriptionId = subscriptionId;
                this.noLocal = noLocal;
                this.jmsConsumerSession = JMSClient.this.jmsConnection.createSession(((JMSClient)JMSClient.this).JMSServiceAdapter.this.transactedSessions, ((JMSClient)JMSClient.this).JMSServiceAdapter.this.acknowledgeMode);
                this.jmsConsumer = this.jmsConsumerSession.createConsumer(JMSServiceAdapter.this.getConsumerDestination(JMSClient.this.topic), selector, noLocal);
                this.jmsConsumer.setMessageListener((MessageListener)this);
            }

            public void setSelector(String selector) throws JMSException {
                if (this.jmsConsumer != null) {
                    this.jmsConsumer.close();
                }
                this.jmsConsumer = this.jmsConsumerSession.createConsumer(JMSServiceAdapter.this.getConsumerDestination(JMSClient.this.topic), selector, this.noLocal);
                this.jmsConsumer.setMessageListener((MessageListener)this);
            }

            public void close() throws JMSException {
                if (this.jmsConsumer != null) {
                    this.jmsConsumer.close();
                }
                if (this.jmsConsumerSession != null) {
                    this.jmsConsumerSession.close();
                }
            }

            public void onMessage(javax.jms.Message message) {
                if (!(message instanceof ObjectMessage) && !(message instanceof TextMessage)) {
                    log.error("JMS Adapter message type not allowed: %s", message.getClass().getName());
                    try {
                        if (((JMSClient)JMSClient.this).JMSServiceAdapter.this.acknowledgeMode == 2) {
                            message.acknowledge();
                        }
                        if (((JMSClient)JMSClient.this).JMSServiceAdapter.this.transactedSessions) {
                            this.jmsConsumerSession.commit();
                        }
                    }
                    catch (JMSException e) {
                        log.error(e, "Could not ack/commit JMS onMessage", new Object[0]);
                    }
                }
                log.debug("Delivering JMS message", new Object[0]);
                AsyncMessage dmsg = new AsyncMessage();
                try {
                    TextMessage jmsMessage;
                    Object msg = null;
                    if (((JMSClient)JMSClient.this).JMSServiceAdapter.this.textMessages) {
                        jmsMessage = (TextMessage)message;
                        msg = jmsMessage.getText();
                    } else {
                        jmsMessage = (ObjectMessage)message;
                        msg = jmsMessage.getObject();
                    }
                    dmsg.setDestination(JMSServiceAdapter.this.getDestination().getId());
                    if (Boolean.TRUE.equals(message.getBooleanProperty("GDS_BYTEARRAY_BODY"))) {
                        JMSServiceAdapter.this.getGravity().initThread();
                        try {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
                            AMF3Serializer ser = new AMF3Serializer(baos, false);
                            ser.writeObject(msg);
                            ser.close();
                            baos.close();
                            dmsg.setBody(baos.toByteArray());
                        }
                        finally {
                            JMSServiceAdapter.this.getGravity().releaseThread();
                        }
                    } else {
                        dmsg.setBody(msg);
                    }
                    dmsg.setMessageId(this.denormalizeJMSMessageID(message.getJMSMessageID()));
                    dmsg.setCorrelationId(this.denormalizeJMSMessageID(message.getJMSCorrelationID()));
                    dmsg.setTimestamp(message.getJMSTimestamp());
                    dmsg.setTimeToLive(message.getJMSExpiration());
                    Enumeration ename = message.getPropertyNames();
                    while (ename.hasMoreElements()) {
                        String pname = (String)ename.nextElement();
                        dmsg.setHeader(pname, message.getObjectProperty(pname));
                    }
                    dmsg.setHeader("JMSType", message.getJMSType());
                    dmsg.setHeader("JMSPriority", message.getJMSPriority());
                    dmsg.setHeader("JMSRedelivered", message.getJMSRedelivered());
                    dmsg.setHeader("JMSDeliveryMode", message.getJMSDeliveryMode());
                    dmsg.setHeader("DSDstClientId", this.subscriptionId);
                    JMSClient.this.channel.receive(dmsg);
                }
                catch (IOException e) {
                    if (((JMSClient)JMSClient.this).JMSServiceAdapter.this.transactedSessions) {
                        try {
                            this.jmsConsumerSession.rollback();
                        }
                        catch (JMSException f) {
                            log.error("Could not rollback JMS session, messageId: %s", dmsg.getMessageId());
                        }
                    }
                    throw new RuntimeException("IO Error", e);
                }
                catch (JMSException e) {
                    if (((JMSClient)JMSClient.this).JMSServiceAdapter.this.transactedSessions) {
                        try {
                            this.jmsConsumerSession.rollback();
                        }
                        catch (JMSException f) {
                            log.error("Could not rollback JMS session, messageId: %s", dmsg.getMessageId());
                        }
                    }
                    throw new RuntimeException("JMS Error", e);
                }
                catch (MessageReceivingException e) {
                    if (((JMSClient)JMSClient.this).JMSServiceAdapter.this.transactedSessions) {
                        try {
                            this.jmsConsumerSession.rollback();
                        }
                        catch (JMSException f) {
                            log.error("Could not rollback JMS session, messageId: %s", dmsg.getMessageId());
                        }
                    }
                    throw new RuntimeException("Channel delivery Error", e);
                }
                try {
                    if (((JMSClient)JMSClient.this).JMSServiceAdapter.this.acknowledgeMode == 2) {
                        message.acknowledge();
                    }
                    if (((JMSClient)JMSClient.this).JMSServiceAdapter.this.transactedSessions) {
                        this.jmsConsumerSession.commit();
                    }
                }
                catch (JMSException e) {
                    log.error("Could not ack/commit JMS onMessage, messageId: %s", dmsg.getMessageId());
                }
            }

            private String denormalizeJMSMessageID(String messageId) {
                if (messageId != null && messageId.startsWith("ID:")) {
                    messageId = messageId.substring(3);
                }
                return messageId;
            }
        }
    }
}

