/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.context.GraniteContext;
import org.granite.gravity.ChannelFactory;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityManager;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.util.UUIDUtil;

public class AbstractGravityServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String CONNECT_MESSAGE_KEY = String.valueOf(AbstractGravityServlet.class.getName()) + ".CONNECT_MESSAGE";

    public void init(ServletConfig config, ChannelFactory channelFactory) throws ServletException {
        super.init(config);
        GravityManager.start(config, channelFactory);
    }

    public static void setConnectMessage(HttpServletRequest request, Message connect) {
        if (!(connect instanceof CommandMessage) && ((CommandMessage)connect).getOperation() != 20) {
            throw new IllegalArgumentException("Not a connect message: " + connect);
        }
        request.setAttribute(CONNECT_MESSAGE_KEY, (Object)connect);
    }

    public static CommandMessage getConnectMessage(HttpServletRequest request) {
        return (CommandMessage)request.getAttribute(CONNECT_MESSAGE_KEY);
    }

    public static void removeConnectMessage(HttpServletRequest request) {
        request.removeAttribute(CONNECT_MESSAGE_KEY);
    }

    protected long getLongPollingTimeout() {
        return GravityManager.getGravity(this.getServletContext()).getGravityConfig().getLongPollingTimeoutMillis();
    }

    protected Gravity initializeRequest(Gravity gravity, HttpServletRequest request, HttpServletResponse response) {
        HttpGraniteContext.createThreadIntance(gravity.getGraniteConfig(), gravity.getServicesConfig(), this.getServletConfig().getServletContext(), request, response);
        return gravity;
    }

    protected Message[] deserialize(Gravity gravity, HttpServletRequest request) throws ClassNotFoundException, IOException {
        ServletInputStream is = request.getInputStream();
        try {
            Message[] messageArray = this.deserialize(gravity, request, (InputStream)is);
            return messageArray;
        }
        finally {
            is.close();
        }
    }

    protected Message[] deserialize(Gravity gravity, HttpServletRequest request, InputStream is) throws ClassNotFoundException, IOException {
        ObjectInput amf3Deserializer = gravity.getGraniteConfig().newAMF3Deserializer(is);
        Object[] objects = (Object[])amf3Deserializer.readObject();
        Message[] messages = new Message[objects.length];
        System.arraycopy(objects, 0, messages, 0, objects.length);
        return messages;
    }

    protected void serialize(Gravity gravity, HttpServletResponse response, Message[] messages) throws IOException {
        OutputStream os = null;
        try {
            String dsId = null;
            Message[] messageArray = messages;
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                Message message = messageArray[n2];
                if ("nil".equals(message.getHeader("DSId"))) {
                    if (dsId == null) {
                        dsId = UUIDUtil.randomUUID();
                    }
                    message.getHeaders().put("DSId", dsId);
                }
                ++n2;
            }
            response.flushBuffer();
            response.setStatus(200);
            response.setContentType("application/x-amf");
            response.setDateHeader("Expire", 0L);
            response.setHeader("Cache-Control", "no-store");
            os = response.getOutputStream();
            ObjectOutput amf3Serializer = gravity.getGraniteConfig().newAMF3Serializer(os);
            amf3Serializer.writeObject(messages);
            os.flush();
            response.flushBuffer();
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    protected void cleanupRequest(HttpServletRequest request) {
        GraniteContext.release();
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        throw new ServletException("Unsupported operation: " + req.getMethod());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        throw new ServletException("Unsupported operation: " + req.getMethod());
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        throw new ServletException("Unsupported operation: " + req.getMethod());
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        throw new ServletException("Unsupported operation: " + req.getMethod());
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        throw new ServletException("Unsupported operation: " + req.getMethod());
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        throw new ServletException("Unsupported operation: " + req.getMethod());
    }
}

