/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config.servlet3;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import org.granite.config.GraniteConfigListener;
import org.granite.config.servlet3.FlexFilter;
import org.granite.messaging.webapp.AMFMessageFilter;
import org.granite.messaging.webapp.AMFMessageServlet;
import org.granite.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HandlesTypes(value={FlexFilter.class})
public class GraniteServlet3Initializer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> scannedClasses, ServletContext servletContext) throws ServletException {
        HashSet classes = new HashSet();
        if (scannedClasses != null) {
            classes.addAll(scannedClasses);
            classes.remove(FlexFilter.class);
        }
        if (classes.size() > 1) {
            throw new ServletException("Application must have only one FlexFilter configuration class");
        }
        if (!classes.isEmpty()) {
            Class clazz = (Class)classes.iterator().next();
            FlexFilter flexFilter = clazz.getAnnotation(FlexFilter.class);
            servletContext.setAttribute("org.granite.config.flexFilter", (Object)clazz);
            servletContext.addListener(GraniteConfigListener.class);
            if (servletContext.getFilterRegistration("AMFMessageFilter") == null) {
                FilterRegistration.Dynamic graniteFilter = servletContext.addFilter("AMFMessageFilter", AMFMessageFilter.class);
                graniteFilter.addMappingForUrlPatterns(null, true, new String[]{flexFilter.graniteUrlMapping()});
            }
            if (servletContext.getServletRegistration("AMFMessageServlet") == null) {
                ServletRegistration.Dynamic graniteServlet = servletContext.addServlet("AMFMessageServlet", AMFMessageServlet.class);
                graniteServlet.setLoadOnStartup(1);
                graniteServlet.addMapping(new String[]{flexFilter.graniteUrlMapping()});
            }
            try {
                if (servletContext.getServletRegistration("GravityServlet") == null) {
                    Class<Servlet> gravityAsyncServletClass = ClassUtil.forName("org.granite.gravity.servlet3.GravityAsyncServlet", Servlet.class);
                    ServletRegistration.Dynamic gravityServlet = servletContext.addServlet("GravityServlet", gravityAsyncServletClass);
                    gravityServlet.setLoadOnStartup(1);
                    gravityServlet.setAsyncSupported(true);
                    gravityServlet.addMapping(new String[]{flexFilter.gravityUrlMapping()});
                }
            }
            catch (ClassNotFoundException e) {
                servletContext.log("Could not setup GravityAsyncServlet", (Throwable)e);
            }
        }
    }
}

