/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.granite.config.GraniteConfig;
import org.granite.config.ServletGraniteConfig;
import org.granite.config.ShutdownListener;
import org.granite.config.flex.Channel;
import org.granite.config.flex.Destination;
import org.granite.config.flex.EndPoint;
import org.granite.config.flex.Factory;
import org.granite.config.flex.Service;
import org.granite.config.flex.ServicesConfig;
import org.granite.config.flex.ServletServicesConfig;
import org.granite.config.servlet3.FlexFilter;
import org.granite.jmx.GraniteMBeanInitializer;
import org.granite.logging.Logger;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.tide.TideComponentAnnotatedWithMatcher;
import org.granite.messaging.service.tide.TideComponentInstanceOfMatcher;
import org.granite.messaging.service.tide.TideComponentNameMatcher;
import org.granite.messaging.service.tide.TideComponentTypeMatcher;
import org.granite.util.ClassUtil;
import org.granite.util.ServletParams;
import org.granite.util.XMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraniteConfigListener
implements ServletContextListener {
    private static final String GRANITE_CONFIG_SHUTDOWN_KEY = String.valueOf(GraniteConfig.class.getName()) + "_SHUTDOWN";
    public static final String GRANITE_CONFIG_ATTRIBUTE = "org.granite.config.flexFilter";
    public static final String GRANITE_MBEANS_ATTRIBUTE = "registerGraniteMBeans";
    private static final Logger log = Logger.getLogger(GraniteConfigListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        try {
            ServletContext context = sce.getServletContext();
            log.info("Initializing GraniteDS...", new Object[0]);
            Class flexFilterClass = (Class)context.getAttribute(GRANITE_CONFIG_ATTRIBUTE);
            if (flexFilterClass != null) {
                context.setAttribute(ServletGraniteConfig.GRANITE_CONFIG_DEFAULT_KEY, (Object)"org/granite/config/servlet3/granite-config-servlet3.xml");
            }
            GraniteConfig gConfig = ServletGraniteConfig.loadConfig(context);
            ServletServicesConfig.loadConfig(context);
            if (flexFilterClass != null) {
                this.configureServices(context, flexFilterClass);
            }
            if (gConfig.isRegisterMBeans()) {
                GraniteMBeanInitializer.registerMBeans(context, ServletGraniteConfig.getServletConfig(context), ServletServicesConfig.getServletConfig(context));
            }
            log.info("GraniteDS initialized", new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize Granite environment", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        log.info("Stopping GraniteDS...", new Object[0]);
        List listeners = (List)sce.getServletContext().getAttribute(GRANITE_CONFIG_SHUTDOWN_KEY);
        if (listeners != null) {
            try {
                for (ShutdownListener listener : listeners) {
                    listener.stop();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not destroy Granite environment", e);
            }
        }
        if (ServletParams.get(context, GRANITE_MBEANS_ATTRIBUTE, Boolean.TYPE, Boolean.valueOf(false)).booleanValue()) {
            GraniteMBeanInitializer.unregisterMBeans(context);
        }
        log.info("GraniteDS stopped", new Object[0]);
    }

    public static synchronized void registerShutdownListener(ServletContext context, ShutdownListener listener) {
        ArrayList<ShutdownListener> listeners = (ArrayList<ShutdownListener>)context.getAttribute(GRANITE_CONFIG_SHUTDOWN_KEY);
        if (listeners == null) {
            listeners = new ArrayList<ShutdownListener>();
            context.setAttribute(GRANITE_CONFIG_SHUTDOWN_KEY, listeners);
        }
        listeners.add(listener);
    }

    private void configureServices(ServletContext context, Class<?> flexFilterClass) throws ServletException {
        GraniteConfig graniteConfig = ServletGraniteConfig.loadConfig(context);
        ServicesConfig servicesConfig = ServletServicesConfig.loadConfig(context);
        FlexFilter flexFilter = flexFilterClass.getAnnotation(FlexFilter.class);
        Object[] objectArray = flexFilter.tideInterfaces();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> ti = objectArray[n2];
            try {
                graniteConfig.getTideComponentMatchers().add(new TideComponentInstanceOfMatcher(ti.getName(), false));
                log.debug("Enabled components implementing {0} for Tide remoting", ti);
            }
            catch (Exception e) {
                log.error(e, "Could not add tide-component interface {0}", ti);
            }
            ++n2;
        }
        objectArray = flexFilter.tideAnnotations();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Class<Object> ta = objectArray[n2];
            try {
                graniteConfig.getTideComponentMatchers().add(new TideComponentAnnotatedWithMatcher(ta.getName(), false));
                log.debug("Enabled components annotated with {0} for Tide remoting", ta);
            }
            catch (Exception e) {
                log.error(e, "Could not add tide-component annotation {0}", ta);
            }
            ++n2;
        }
        objectArray = flexFilter.tideNames();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object tn = objectArray[n2];
            try {
                graniteConfig.getTideComponentMatchers().add(new TideComponentNameMatcher((String)tn, false));
                log.debug("Enabled components with name {0} for Tide remoting", tn);
            }
            catch (Exception e) {
                log.error(e, "Could not add tide-component name {0}", tn);
            }
            ++n2;
        }
        objectArray = flexFilter.tideTypes();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object tt = objectArray[n2];
            try {
                graniteConfig.getTideComponentMatchers().add(new TideComponentTypeMatcher((String)tt, false));
                log.debug("Enabled components with type {0} for Tide remoting", tt);
            }
            catch (Exception e) {
                log.error(e, "Could not add tide-component type {0}", tt);
            }
            ++n2;
        }
        objectArray = flexFilter.exceptionConverters();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object ec = objectArray[n2];
            graniteConfig.registerExceptionConverter((Class<? extends ExceptionConverter>)ec);
            log.debug("Registered exception converter {0}", ec);
            ++n2;
        }
        if (!flexFilter.securityServiceClass().equals(SecurityService.class)) {
            try {
                graniteConfig.setSecurityService(ClassUtil.newInstance(flexFilter.securityServiceClass(), SecurityService.class));
            }
            catch (Exception e) {
                throw new ServletException("Could not setup security service", (Throwable)e);
            }
        }
        if (graniteConfig.getSecurityService() == null) {
            String securityServiceClass = null;
            try {
                ClassUtil.forName("org.mortbay.jetty.Request");
                securityServiceClass = "org.granite.messaging.service.security.Jetty6SecurityService";
            }
            catch (ClassNotFoundException e1) {
                try {
                    ClassUtil.forName("weblogic.servlet.security.ServletAuthentication");
                    securityServiceClass = "org.granite.messaging.service.security.WebLogicSecurityService";
                }
                catch (ClassNotFoundException e2) {
                    try {
                        ClassUtil.forName("weblogic.servlet.security.ServletAuthentication");
                        securityServiceClass = "org.granite.messaging.service.security.WebLogicSecurityService";
                    }
                    catch (ClassNotFoundException e3) {
                        securityServiceClass = "org.granite.messaging.service.security.Tomcat7SecurityService";
                    }
                }
                try {
                    graniteConfig.setSecurityService(ClassUtil.newInstance(securityServiceClass, SecurityService.class));
                }
                catch (Exception e) {
                    throw new ServletException("Could not setup security service", (Throwable)e);
                }
            }
        }
        if (!flexFilter.amf3MessageInterceptor().equals(AMF3MessageInterceptor.class)) {
            try {
                graniteConfig.setAmf3MessageInterceptor(ClassUtil.newInstance(flexFilter.amf3MessageInterceptor(), AMF3MessageInterceptor.class));
            }
            catch (Exception e) {
                throw new ServletException("Could not setup amf3 message interceptor", (Throwable)e);
            }
        }
        Channel channel = new Channel("graniteamf", "mx.messaging.channels.AMFChannel", new EndPoint("http://{server.name}:{server.port}/{context.root}/graniteamf/amf", "flex.messaging.endpoints.AMFEndpoint"), new XMap());
        servicesConfig.addChannel(channel);
        if (flexFilter.tide()) {
            XMap factoryProperties = new XMap();
            if (!"".equals(flexFilter.ejbLookup())) {
                factoryProperties.put("lookup", flexFilter.ejbLookup());
            }
            Factory factory = new Factory("tide-" + flexFilter.type() + "-factory", flexFilter.factoryClass().getName(), factoryProperties);
            servicesConfig.addFactory(factory);
            Service service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap<String, Destination>());
            ArrayList<String> channelIds = new ArrayList<String>();
            channelIds.add("graniteamf");
            List<String> tideRoles = flexFilter.tideRoles().length == 0 ? null : Arrays.asList(flexFilter.tideRoles());
            Destination destination = new Destination(flexFilter.type(), channelIds, new XMap(), tideRoles, null, null);
            destination.getProperties().put("factory", "tide-" + flexFilter.type() + "-factory");
            if (!"".equals(flexFilter.entityManagerFactoryJndiName())) {
                destination.getProperties().put("entity-manager-factory-jndi-name", flexFilter.entityManagerFactoryJndiName());
            } else if (!"".equals(flexFilter.entityManagerJndiName())) {
                destination.getProperties().put("entity-manager-jndi-name", flexFilter.entityManagerJndiName());
            }
            service.getDestinations().put(flexFilter.type(), destination);
            servicesConfig.addService(service);
            log.info("Registered Tide service factory and destination", new Object[0]);
        } else {
            Factory factory = new Factory(String.valueOf(flexFilter.type()) + "-factory", flexFilter.factoryClass().getName(), new XMap());
            servicesConfig.addFactory(factory);
            Service service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap<String, Destination>());
            servicesConfig.addService(service);
            servicesConfig.scan(null);
            log.info("Registered " + flexFilter.factoryClass() + " service factory", new Object[0]);
        }
    }
}

