/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.granite.config.AbstractFrameworkGraniteConfig;
import org.granite.config.flex.Channel;
import org.granite.config.flex.Destination;
import org.granite.config.flex.EndPoint;
import org.granite.config.flex.Service;
import org.granite.config.flex.ServicesConfig;
import org.granite.logging.Logger;
import org.granite.util.XMap;

public class AbstractRemoteDestination {
    private static final Logger log = Logger.getLogger(AbstractRemoteDestination.class);
    private String id = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected void init(AbstractFrameworkGraniteConfig graniteConfig) {
        ServicesConfig servicesConfig = graniteConfig.getServicesConfig();
        this.initServices(servicesConfig);
    }

    public void initServices(ServicesConfig servicesConfig) {
        Channel channel = servicesConfig.findChannelById("graniteamf");
        if (channel == null) {
            channel = new Channel("graniteamf", "mx.messaging.channels.AMFChannel", new EndPoint("http://{server.name}:{server.port}/{context.root}/graniteamf/amf", "flex.messaging.endpoints.AMFEndpoint"), new XMap());
            servicesConfig.addChannel(channel);
        }
        List<Service> services = servicesConfig.findServicesByMessageType("flex.messaging.messages.RemotingMessage");
        Service service = null;
        if (services == null || services.isEmpty()) {
            service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap<String, Destination>());
            servicesConfig.addService(service);
        } else {
            service = services.get(0);
        }
        service.getDestinations().put(this.id, this.buildDestination());
        log.info("Registered remote destination %s", this.id);
    }

    protected Destination buildDestination() {
        ArrayList<String> channelIds = new ArrayList<String>();
        channelIds.add("graniteamf");
        Destination destination = new Destination(this.id, channelIds, new XMap(), null, null, null);
        return destination;
    }
}

