/*
  GRANITE DATA SERVICES
  Copyright (C) 2007-2008 ADEQUATE SYSTEMS SARL

  This file is part of Granite Data Services.

  Granite Data Services is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation; either version 3 of the License, or (at your
  option) any later version.

  Granite Data Services is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, see <http://www.gnu.org/licenses/>.
*/

package org.granite.tide.invocation;

import java.io.Serializable;


/**
 * @author William DRAI
 */
public class ContextUpdate implements Serializable {

    private static final long serialVersionUID = 1L;
    
    
    private String componentName;
    private String expression;
    private Object value;
    private boolean inConversation;
    private boolean restrict;
    
    
    public ContextUpdate() {
    }
    
    public ContextUpdate(String componentName, String expression, Object value, boolean inConversation, boolean restrict) {
        this.componentName = componentName;
        this.expression = expression;
        this.value = value;
        this.inConversation = inConversation;
        this.restrict = restrict;
    }

    public String getComponentName() {
        return componentName;
    }
    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }
    
    public String getExpression() {
        return expression;
    }
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Object getValue() {
        return value;
    }
    public void setValue(Object value) {
        this.value = value;
    }
    
    public boolean getInConversation() {
        return inConversation;
    }
    public void setInConversation(boolean inConversation) {
        this.inConversation = inConversation;
    }
    
    public boolean getRestrict() {
        return restrict;
    }
    public void setRestrict(boolean restrict) {
        this.restrict = restrict;
    }

    
    @Override
    public String toString() {
        if (expression == null)
            return componentName + (inConversation ? "" : " (SESSION)") + (restrict ? " (Restricted)" :"");
        
        return componentName + "." + expression + (inConversation ? "" : " (SESSION)" + (restrict ? " (Restricted)" :""));
    }
}
