/*
  GRANITE DATA SERVICES
  Copyright (C) 2007-2008 ADEQUATE SYSTEMS SARL

  This file is part of Granite Data Services.

  Granite Data Services is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation; either version 3 of the License, or (at your
  option) any later version.

  Granite Data Services is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, see <http://www.gnu.org/licenses/>.
*/

package org.granite.tide.ejb;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.ejb.Stateful;
import javax.ejb.Stateless;

import org.granite.logging.Logger;
import org.granite.scan.ScannedItem;
import org.granite.scan.ScannedItemHandler;
import org.granite.tide.util.Observer;

/**
 * @author Franck WOLFF
 */
public class EjbScannedItemHandler implements ScannedItemHandler {

	private static final Logger log = Logger.getLogger(EjbScannedItemHandler.class);
	private static final EjbScannedItemHandler instance = new EjbScannedItemHandler();
	
	private final Map<String, Set<Method>> observers = new HashMap<String, Set<Method>>();
	
	public static EjbScannedItemHandler instance() {
		return instance;
	}
	
	static EjbScannedItemHandler instance(boolean reset) {
		instance.observers.clear();
		return instance;
	}
	
	private EjbScannedItemHandler() {
	}
	
	public void handleMarkerItem(ScannedItem item) {
	}

	public void handleScannedItem(ScannedItem item) {
		if ("class".equals(item.getExtension()) && item.getName().indexOf('$') == -1) {
			try {
				Class<?> clazz = item.loadAsClass();
				if (clazz.isAnnotationPresent(Stateless.class) || clazz.isAnnotationPresent(Stateful.class)) {
					for (Method method : clazz.getMethods()) {
						if (method.isAnnotationPresent(Observer.class)) {
							Observer o = method.getAnnotation(Observer.class);
							Set<Method> methods = observers.get(o.value());
							if (methods == null) {
								methods = new HashSet<Method>();
								observers.put(o.value(), methods);
							}
							methods.add(method);
						}
					}
				}
			}
			catch (Exception e) {
				log.debug(e, "Could not introspect scanned item: %s", item);
			}
		}
	}
	
	public Map<String, Set<Method>> getObservers() {
		return observers;
	}
}
