package org.granite.messaging.amf.io.convert.impl;

import java.lang.reflect.Type;

import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.convert.Reverter;
import org.granite.util.ClassUtil;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;


public class GAEKeyConverter extends Converter implements Reverter {
	
	private static String KEY_CLASS = "com.google.appengine.api.datastore.Key";
	
    public GAEKeyConverter(Converters converters) {
        super(converters);
    }

	@Override
	protected boolean internalCanConvert(Object value, Type targetType) {
        Class<?> targetClass = ClassUtil.classOfType(targetType);
        return (
            targetClass != Object.class && KEY_CLASS.equals(targetClass.getName()) &&
            (value instanceof String || value == null)
        );
	}

	@Override
	protected Object internalConvert(Object value, Type targetType) {
        if (value == null)
            return null;
        return KeyFactory.stringToKey((String)value);
	}

	public boolean canRevert(Object value) {
		return value != null && KEY_CLASS.equals(value.getClass().getName());
	}

	public Object revert(Object value) {
		return KeyFactory.keyToString((Key)value);
	}

}
