package org.granite.gravity.config.servlet3;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;


@Inherited
@Retention(RUNTIME)
@Target({FIELD})
public @interface ActiveMQTopicDestination {
	
	boolean noLocal() default true;
	
	boolean sessionSelector() default false;
	
	String name();
	
    String connectionFactory();
    
    String topicJndiName();
    
    String acknowledgeMode() default "AUTO_ACKNOWLEDGE";
    
    boolean transactedSessions() default false;
    
    String brokerUrl();
    
    boolean createBroker() default true;
    
    boolean waitForStart() default false;
    
    boolean durable() default false;
    
    String fileStoreRoot() default "";
    
}
