package org.granite.config.servlet3;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.annotations.RemoteDestination;
import org.granite.messaging.service.security.SecurityService;


@Inherited
@Retention(RUNTIME)
@Target({TYPE})
public @interface FlexFilter {
	
	String graniteUrlMapping() default "/graniteamf/*";
	
	String gravityUrlMapping() default "/gravityamf/*";
	
	boolean tide() default false;
	
	String type();
	
	Class<? extends ServiceFactory> factoryClass();
	
	Class<? extends SecurityService> securityServiceClass() default SecurityService.class;
	
	Class<?>[] tideInterfaces() default {};
	
	Class<? extends Annotation>[] tideAnnotations() default { RemoteDestination.class };
	
	String[] tideNames() default {};
	
	String[] tideTypes() default {};
	
	String[] tideRoles() default {};
	
	Class<? extends ExceptionConverter>[] exceptionConverters() default {};
	
	Class<? extends AMF3MessageInterceptor> amf3MessageInterceptor() default AMF3MessageInterceptor.class;
	
	String ejbLookup() default "";
	
	String entityManagerFactoryJndiName() default "";
	
	String entityManagerJndiName() default "";
}
