/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.IInvocationResult;
import org.granite.tide.TidePersistenceManager;
import org.granite.tide.TideServiceContext;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.cdi.ConversationState;
import org.granite.tide.cdi.ResultsEval;
import org.granite.tide.cdi.ScopedContextResult;
import org.granite.tide.cdi.TideBean;
import org.granite.tide.cdi.TideInvocation;
import org.granite.tide.cdi.TideUserEvents;
import org.granite.tide.cdi.UserEvents;
import org.granite.tide.cdi.lazy.CDIInitializer;
import org.granite.tide.data.DataContext;
import org.granite.tide.invocation.ContextEvent;
import org.granite.tide.invocation.ContextResult;
import org.granite.tide.invocation.ContextUpdate;
import org.granite.tide.invocation.InvocationCall;
import org.granite.tide.invocation.InvocationResult;
import org.granite.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SessionScoped
public class CDIServiceContext
extends TideServiceContext {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(CDIServiceContext.class);
    private static final AnnotationLiteral<Any> ANY_LITERAL = new AnnotationLiteral<Any>(){};
    private static final AnnotationLiteral<Default> DEFAULT_LITERAL = new AnnotationLiteral<Default>(){};
    @Inject
    private BeanManager manager;
    private UserEvents userEvents;
    @Inject
    private TideUserEvents tideUserEvents;
    private boolean isAsynchronousContext = true;
    private boolean isFirstCall = false;
    private boolean isLogin = false;
    @Inject
    private CDIInitializer tideEntityInitializer;
    @Inject
    private ResultsEval resultsEval;
    @Inject
    private ConversationState conversation;
    @Inject
    private CDIInitializer initializer;

    public void initCall() {
        super.initCall();
        if (this.userEvents != null) {
            return;
        }
        if (this.getSessionId() != null) {
            this.userEvents = this.tideUserEvents.getUserEvents(this.getSessionId());
        } else {
            GraniteContext graniteContext = GraniteContext.getCurrentInstance();
            if (graniteContext instanceof HttpGraniteContext) {
                HttpSession session = ((HttpGraniteContext)graniteContext).getSession(false);
                if (session != null) {
                    this.setSessionId(session.getId());
                }
                this.isAsynchronousContext = false;
            }
        }
    }

    public void setSessionId(String sessionId) {
        super.setSessionId(sessionId);
        this.userEvents = this.tideUserEvents.getUserEvents(sessionId);
    }

    @PreDestroy
    public void endSession() {
        if (!this.isAsynchronousContext && this.getSessionId() != null) {
            this.tideUserEvents.unregisterSession(this.getSessionId());
        }
    }

    private Map<ContextResult, Boolean> getResultsEval() {
        return this.resultsEval.getResultsEval();
    }

    public Object findComponent(String componentName, Class<?> componentClass) {
        Bean<?> bean = this.findBean(componentName, componentClass);
        if (bean == null) {
            return null;
        }
        CreationalContext cc = this.manager.createCreationalContext(bean);
        return this.manager.getReference(bean, Object.class, cc);
    }

    public Set<Class<?>> findComponentClasses(String componentName, Class<?> componentClass) {
        Bean<?> bean = this.findBean(componentName, componentClass);
        return this.beanClasses(bean);
    }

    private Bean<?> findBean(String componentName, Class<?> componentClass) {
        Set beans;
        if (componentClass != null && (beans = this.manager.getBeans(componentClass, new Annotation[]{ANY_LITERAL})).size() == 1) {
            return (Bean)beans.iterator().next();
        }
        if (componentName != null && !"".equals(componentName) && !(beans = this.manager.getBeans(componentName)).isEmpty()) {
            return (Bean)beans.iterator().next();
        }
        if (componentClass != null && (beans = this.manager.getBeans(componentClass, new Annotation[]{DEFAULT_LITERAL})).size() == 1) {
            return (Bean)beans.iterator().next();
        }
        return null;
    }

    private Set<Class<?>> beanClasses(Object bean) {
        if (bean instanceof Bean) {
            HashSet classes = new HashSet();
            for (Type type : ((Bean)bean).getTypes()) {
                if (!(type instanceof Class)) continue;
                classes.add((Class)type);
            }
            return classes;
        }
        HashSet classes = new HashSet(1);
        classes.add(bean.getClass());
        return classes;
    }

    public void processEvent(Object event) {
        String sessionId;
        TideInvocation tideInvocation = TideInvocation.get();
        if (tideInvocation == null) {
            return;
        }
        if (this.userEvents != null && (sessionId = this.getSessionId()) != null && this.userEvents.hasEventType(event.getClass())) {
            tideInvocation.addEvent(new ContextEvent(event.getClass().getName(), new Object[]{event, null}));
        }
    }

    protected AsyncPublisher getAsyncPublisher() {
        return null;
    }

    public void prepareCall(ServiceInvocationContext context, IInvocationCall c, String componentName, Class<?> componentClass) {
        InvocationCall call = (InvocationCall)c;
        List listeners = call.getListeners();
        List updates = call.getUpdates();
        Object[] results = call.getResults();
        try {
            if (this.manager.getContext(RequestScoped.class).isActive() && this.manager.getContext(SessionScoped.class).isActive() && this.isFirstCall && this.isLogin) {
                for (Map.Entry<ContextResult, Boolean> me : this.getResultsEval().entrySet()) {
                    if (me.getKey().getExpression() != null || !this.findBean(me.getKey().getComponentName(), me.getKey().getComponentClass()).getScope().equals(SessionScoped.class)) continue;
                    me.setValue(Boolean.TRUE);
                }
                this.isLogin = false;
                this.isFirstCall = false;
            }
        }
        catch (ContextNotActiveException e) {
            // empty catch block
        }
        try {
            if (this.manager.getContext(RequestScoped.class).isActive() && this.manager.getContext(ConversationScoped.class).isActive() && this.conversation.isFirstCall()) {
                for (Map.Entry<ContextResult, Boolean> me : this.getResultsEval().entrySet()) {
                    if (me.getKey().getExpression() != null || !this.findBean(me.getKey().getComponentName(), me.getKey().getComponentClass()).getScope().equals(ConversationScoped.class)) continue;
                    me.setValue(Boolean.TRUE);
                }
                this.conversation.setFirstCall(false);
            }
        }
        catch (ContextNotActiveException e) {
            // empty catch block
        }
        String sessionId = this.getSessionId();
        if (sessionId != null && listeners != null) {
            for (String listener : listeners) {
                try {
                    Class listenerClass = ClassUtil.forName((String)listener);
                    this.tideUserEvents.registerEventType(sessionId, listenerClass);
                }
                catch (ClassNotFoundException e) {
                    log.error("Could not register event " + listener, new Object[]{e});
                }
            }
            if (this.userEvents == null) {
                this.userEvents = this.tideUserEvents.getUserEvents(this.getSessionId());
            }
        }
        if (results != null) {
            Map<ContextResult, Boolean> resultsEval = this.getResultsEval();
            for (Object result : results) {
                ContextResult cr = (ContextResult)result;
                resultsEval.put(cr, Boolean.TRUE);
            }
        }
        try {
            this.tideEntityInitializer.restoreLoadedEntities();
        }
        catch (ContextNotActiveException e) {
            // empty catch block
        }
        TideInvocation tideInvocation = TideInvocation.init();
        tideInvocation.update(updates);
    }

    public IInvocationResult postCall(ServiceInvocationContext context, Object result, String componentName, Class<?> componentClass) {
        TideInvocation tideInvocation = TideInvocation.get();
        boolean inConversation = false;
        boolean restrict = false;
        ArrayList<ContextUpdate> results = new ArrayList<ContextUpdate>(tideInvocation.getResults());
        DataContext dataContext = DataContext.get();
        Set dataUpdates = dataContext != null ? dataContext.getDataUpdates() : null;
        Object[][] updates = null;
        if (dataUpdates != null && !dataUpdates.isEmpty()) {
            updates = (Object[][])dataUpdates.toArray((T[])new Object[dataUpdates.size()][]);
        }
        Bean<?> bean = null;
        if (componentName != null || componentClass != null) {
            bean = this.findBean(componentName, componentClass);
            if (bean.getScope() == RequestScoped.class || bean.getScope() == ConversationScoped.class) {
                inConversation = true;
            }
            try {
                if (this.manager.getContext(RequestScoped.class).get(bean) != null) {
                    inConversation = true;
                } else if (this.manager.getContext(ConversationScoped.class).get(bean) != null) {
                    inConversation = true;
                }
            }
            catch (ContextNotActiveException e) {
                inConversation = false;
            }
        }
        InvocationResult res = new InvocationResult(result, results);
        res.setInConversation(inConversation);
        res.setRestrict(restrict);
        res.setUpdates(updates);
        res.setEvents(tideInvocation.getEvents());
        try {
            this.tideEntityInitializer.saveLoadedEntities();
        }
        catch (ContextNotActiveException e) {
            // empty catch block
        }
        TideInvocation.remove();
        return res;
    }

    public void postCallFault(ServiceInvocationContext context, Throwable t, String componentName, Class<?> componentClass) {
        TideInvocation.remove();
    }

    public void addResultEval(ContextResult result) {
        this.getResultsEval().put(result, Boolean.TRUE);
    }

    public void restoreContext(List<ContextUpdate> updates, Object target) {
        if (updates == null) {
            return;
        }
        GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
        for (ContextUpdate update : updates) {
            Bean sourceBean;
            Object previous;
            boolean disabled;
            log.debug("Before invocation: evaluating expression #0.#1", new Object[]{update.getComponentName(), update.getExpression()});
            Set beans = this.manager.getBeans(update.getValue().getClass(), new Annotation[]{new AnnotationLiteral<Any>(){}});
            if (beans.isEmpty() && update.getComponentName() != null) {
                beans = this.manager.getBeans(update.getComponentName());
            }
            if (beans.isEmpty() || (disabled = (previous = this.manager.getReference(sourceBean = (Bean)beans.iterator().next(), Object.class, this.manager.createCreationalContext((Contextual)sourceBean))) != null && sourceBean != null && config.isComponentTideDisabled(sourceBean.getName(), this.beanClasses(sourceBean), previous))) continue;
            this.mergeExternal(update.getValue(), previous);
        }
    }

    public List<ContextUpdate> evaluateResults(Object target, boolean nothing) {
        ArrayList<ContextUpdate> resultsMap = new ArrayList<ContextUpdate>();
        if (nothing) {
            return resultsMap;
        }
        GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
        ClassGetter classGetter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
        for (Map.Entry<ContextResult, Boolean> me : this.getResultsEval().entrySet()) {
            Object value;
            if (!me.getValue().booleanValue()) continue;
            ContextResult res = me.getKey();
            Class componentClass = res.getComponentClass();
            Bean<?> targetBean = this.findBean(res.getComponentName(), componentClass);
            String targetComponentName = targetBean.getName();
            boolean add = true;
            Class scopeType = targetBean.getScope();
            Boolean restrict = res.getRestrict();
            Object object = value = res instanceof ScopedContextResult ? ((ScopedContextResult)res).getValue() : this.manager.getReference(targetBean, Object.class, null);
            if (value != null && config.isComponentTideDisabled(targetComponentName, this.beanClasses(targetBean), value)) {
                add = false;
            }
            if (add) {
                this.getResultsEval().put(res, false);
                if (value != null && classGetter != null) {
                    classGetter.initialize(null, null, value);
                    boolean inConversation = scopeType == ConversationScoped.class;
                    resultsMap.add(new ContextUpdate(res.getComponentName(), null, value, inConversation, Boolean.TRUE.equals(restrict)));
                    add = false;
                }
            }
            me.setValue(Boolean.FALSE);
        }
        return resultsMap;
    }

    protected TidePersistenceManager getTidePersistenceManager(boolean create) {
        return this.initializer.getPersistenceManager();
    }

    protected boolean equals(Object obj1, Object obj2) {
        if (super.equals(obj1, obj2)) {
            return true;
        }
        return obj1 != null && obj2 != null && (obj1.getClass().isAnnotationPresent(TideBean.class) || obj2.getClass().isAnnotationPresent(TideBean.class));
    }
}

