/*
 * Decompiled with CFR 0.152.
 */
package net.kaleidos.hibernate.usertype;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.kaleidos.hibernate.usertype.HstoreParseException;
import org.postgresql.util.PGobject;
import org.springframework.util.Assert;

public class HstoreParser
extends PGobject
implements Iterable<Map.Entry<String, String>> {
    private static final long serialVersionUID = -2491617655490561600L;
    private int length;
    private static final String BACKSLASH = "\\";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String BACKSLASH_PLACEHOLDER = "!#BS#!";
    private static final String DOUBLE_QUOTE_PLACEHOLDER = "!#DQ#!";
    private static final char[] QUOTE = new char[]{'\"', '\''};
    private static final char NO_QUOTE_CHAR = '\u0000';
    private static final char EQUALS = '=';
    private static final char GREATER = '>';
    private static final char COMMA = ',';
    private static final String NULL = "NULL";

    public HstoreParser(String rawValue) {
        this.type = "hstore";
        this.setUnescapedValueAndLength(rawValue);
    }

    private void setUnescapedValueAndLength(String rawValue) {
        this.value = rawValue.replace("\\\"", DOUBLE_QUOTE_PLACEHOLDER).replace("\\\\", BACKSLASH_PLACEHOLDER);
        this.length = this.value == null ? 0 : this.value.length();
    }

    public void setValue(String rawValue) {
        Assert.state((boolean)"hstore".equals(this.type), (String)"HStore database type name should be 'hstore'");
        this.setUnescapedValueAndLength(rawValue);
    }

    public Map<String, String> asMap() {
        HashMap<String, String> r = new HashMap<String, String>();
        try {
            HStoreIterator iterator = new HStoreIterator();
            while (iterator.hasNext()) {
                HStoreEntry entry = iterator.rawNext();
                r.put(this.replaceEscapePlaceholders(entry.key), this.replaceEscapePlaceholders(entry.value));
            }
        }
        catch (HstoreParseException e) {
            throw new IllegalStateException(e);
        }
        return r;
    }

    private String replaceEscapePlaceholders(String text) {
        return text == null ? null : text.replace(BACKSLASH_PLACEHOLDER, BACKSLASH).replace(DOUBLE_QUOTE_PLACEHOLDER, DOUBLE_QUOTE);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        try {
            return new HStoreIterator();
        }
        catch (HstoreParseException e) {
            throw new IllegalStateException(e);
        }
    }

    private class HStoreIterator
    implements Iterator<Map.Entry<String, String>> {
        private int position = -1;
        char currentQuoteChar = '\u0000';
        private HStoreEntry lastReturned;
        private HStoreEntry nextEntry;

        public HStoreIterator() throws HstoreParseException {
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        private HStoreEntry rawNext() throws NoSuchElementException, HstoreParseException {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public Map.Entry<String, String> next() throws NoSuchElementException, IllegalStateException {
            try {
                return this.rawNext();
            }
            catch (HstoreParseException e) {
                throw new IllegalStateException(e);
            }
        }

        private void advance() throws HstoreParseException {
            String elementKey = null;
            String elementValue = null;
            ParseState state = ParseState.WaitingForKey;
            block7: while (this.position < HstoreParser.this.length - 1) {
                char ch = HstoreParser.this.value.charAt(++this.position);
                switch (state) {
                    case WaitingForKey: {
                        if (Character.isWhitespace(ch)) continue block7;
                        for (char q : QUOTE) {
                            if (ch != q) continue;
                            this.currentQuoteChar = q;
                            elementKey = this.advanceQuoted();
                        }
                        if (this.currentQuoteChar == '\u0000') {
                            elementKey = this.advanceWord('=');
                        }
                        this.currentQuoteChar = '\u0000';
                        state = ParseState.WaitingForEquals;
                        continue block7;
                    }
                    case WaitingForEquals: {
                        if (Character.isWhitespace(ch)) continue block7;
                        if (ch == '=') {
                            state = ParseState.WaitingForGreater;
                            continue block7;
                        }
                        throw new HstoreParseException("Expected '=>' key-value separator", this.position);
                    }
                    case WaitingForGreater: {
                        if (ch == '>') {
                            state = ParseState.WaitingForValue;
                            continue block7;
                        }
                        throw new HstoreParseException("Expected '=>' key-value separator", this.position);
                    }
                    case WaitingForValue: {
                        if (Character.isWhitespace(ch)) continue block7;
                        for (char q : QUOTE) {
                            if (ch != q) continue;
                            this.currentQuoteChar = q;
                            elementValue = this.advanceQuoted();
                        }
                        if (this.currentQuoteChar == '\u0000' && HstoreParser.NULL.equalsIgnoreCase(elementValue = this.advanceWord(','))) {
                            elementValue = null;
                        }
                        this.currentQuoteChar = '\u0000';
                        state = ParseState.WaitingForComma;
                        continue block7;
                    }
                    case WaitingForComma: {
                        if (Character.isWhitespace(ch)) continue block7;
                        if (ch == ',') break block7;
                        throw new HstoreParseException("Cannot find comma as an end of the value", this.position);
                    }
                    default: {
                        throw new IllegalStateException("Unknown HstoreParser state");
                    }
                }
            }
            if (state == ParseState.WaitingForKey) {
                this.nextEntry = null;
                return;
            }
            if (state != ParseState.WaitingForComma) {
                throw new HstoreParseException("Unexpected end of string", this.position);
            }
            if (elementKey == null) {
                throw new HstoreParseException("Internal parsing error", this.position);
            }
            this.nextEntry = new HStoreEntry(elementKey, elementValue);
        }

        private String advanceQuoted() throws HstoreParseException {
            int firstQuotePosition = this.position;
            StringBuilder sb = null;
            boolean insideQuote = true;
            while (this.position < HstoreParser.this.length - 1) {
                char ch = HstoreParser.this.value.charAt(++this.position);
                if (ch == this.currentQuoteChar) {
                    char nextCh;
                    int nextPosition = this.position + 1;
                    if (nextPosition < HstoreParser.this.length && (nextCh = HstoreParser.this.value.charAt(nextPosition)) == this.currentQuoteChar) {
                        if (sb == null) {
                            sb = new StringBuilder(HstoreParser.this.value.substring(firstQuotePosition + 1, nextPosition));
                        } else {
                            sb.append(this.currentQuoteChar);
                        }
                        ++this.position;
                        continue;
                    }
                    insideQuote = false;
                    break;
                }
                if (sb == null) continue;
                sb.append(ch);
            }
            if (insideQuote) {
                throw new HstoreParseException("Quote at string position " + firstQuotePosition + " is not closed", this.position);
            }
            if (sb == null) {
                return HstoreParser.this.value.substring(firstQuotePosition + 1, this.position);
            }
            return sb.toString();
        }

        private String advanceWord(char stopAtChar) throws HstoreParseException {
            int firstWordPosition = this.position;
            while (this.position < HstoreParser.this.length) {
                char ch = HstoreParser.this.value.charAt(this.position);
                if (ch == this.currentQuoteChar) {
                    throw new HstoreParseException("Unexpected quote in word", this.position);
                }
                if (Character.isWhitespace(ch) || ch == stopAtChar) break;
                ++this.position;
            }
            --this.position;
            return HstoreParser.this.value.substring(firstWordPosition, this.position + 1);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static enum ParseState {
        WaitingForKey,
        WaitingForEquals,
        WaitingForGreater,
        WaitingForValue,
        WaitingForComma;

    }

    private static class HStoreEntry
    implements Map.Entry<String, String> {
        private String key;
        private String value;

        HStoreEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            String oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }
}

