/*
 * Decompiled with CFR 0.152.
 */
package net.kaleidos.hibernate.usertype;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import net.kaleidos.hibernate.usertype.BidiEnumMap;
import net.kaleidos.hibernate.utils.PgArrayUtils;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public class ArrayType
implements UserType,
ParameterizedType {
    public static final int INTEGER_ARRAY = 90001;
    public static final int LONG_ARRAY = 90002;
    public static final int STRING_ARRAY = 90003;
    public static final int ENUM_INTEGER_ARRAY = 90004;
    public static final int FLOAT_ARRAY = 90005;
    public static final int DOUBLE_ARRAY = 90006;
    public static final int UUID_ARRAY = 90007;
    private static final Map<Class, Integer> CLASS_TO_SQL_CODE = new HashMap<Class, Integer>();
    private Class<?> typeClass;
    private BidiEnumMap bidiMap;

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x instanceof Object[] && y instanceof Object[]) {
            return Arrays.deepEquals((Object[])x, (Object[])y);
        }
        if (x instanceof byte[] && y instanceof byte[]) {
            return Arrays.equals((byte[])x, (byte[])y);
        }
        if (x instanceof short[] && y instanceof short[]) {
            return Arrays.equals((short[])x, (short[])y);
        }
        if (x instanceof int[] && y instanceof int[]) {
            return Arrays.equals((int[])x, (int[])y);
        }
        if (x instanceof long[] && y instanceof long[]) {
            return Arrays.equals((long[])x, (long[])y);
        }
        if (x instanceof char[] && y instanceof char[]) {
            return Arrays.equals((char[])x, (char[])y);
        }
        if (x instanceof float[] && y instanceof float[]) {
            return Arrays.equals((float[])x, (float[])y);
        }
        if (x instanceof double[] && y instanceof double[]) {
            return Arrays.equals((double[])x, (double[])y);
        }
        if (x instanceof boolean[] && y instanceof boolean[]) {
            return Arrays.equals((boolean[])x, (boolean[])y);
        }
        return x.equals(y);
    }

    public int hashCode(Object value) throws HibernateException {
        return value == null ? 0 : value.hashCode();
    }

    public boolean isMutable() {
        return true;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public void setParameterValues(Properties parameters) {
        this.typeClass = (Class)parameters.get("type");
        if (this.typeClass == null) {
            throw new RuntimeException("The user type needs to be configured with the type. None provided");
        }
    }

    public Class<?> returnedClass() {
        return Array.newInstance(this.typeClass, 0).getClass();
    }

    public int[] sqlTypes() {
        Integer type = CLASS_TO_SQL_CODE.get(this.typeClass);
        if (type != null) {
            return new int[]{type};
        }
        if (this.typeClass.isEnum()) {
            return new int[]{90004};
        }
        throw new RuntimeException("The type " + this.typeClass + " is not a valid type");
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        Object result = null;
        Class<?> typeArrayClass = Array.newInstance(this.typeClass, 0).getClass();
        java.sql.Array sqlArray = rs.getArray(names[0]);
        if (!rs.wasNull()) {
            Object array = sqlArray.getArray();
            if (this.typeClass.isEnum()) {
                int length = array != null ? Array.getLength(array) : 0;
                result = Array.newInstance(this.typeClass, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(result, i, this.idToEnum((Integer)Array.get(array, i)));
                }
            } else {
                result = typeArrayClass.cast(array);
            }
        }
        return result;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 2003);
            return;
        }
        Object[] valueToSet = (Object[])value;
        Class<Object> typeArrayClass = Array.newInstance(this.typeClass, 0).getClass();
        if (this.typeClass.isEnum()) {
            typeArrayClass = Integer[].class;
            Integer[] converted = new Integer[valueToSet.length];
            for (int i = 0; i < valueToSet.length; ++i) {
                converted[i] = valueToSet[i] instanceof Integer ? (Integer)valueToSet[i] : Integer.valueOf(this.enumToId(valueToSet[i]));
            }
            valueToSet = converted;
        }
        java.sql.Array array = st.getConnection().createArrayOf(PgArrayUtils.getNativeSqlType(this.typeClass), (Object[])typeArrayClass.cast(valueToSet));
        st.setArray(index, array);
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    private void ensureBidiMapInitialized() throws HibernateException {
        try {
            if (this.bidiMap == null) {
                this.bidiMap = new BidiEnumMap(this.typeClass);
            }
        }
        catch (Exception e) {
            throw new HibernateException("Unable to create bidirectional enum map for " + this.typeClass, (Throwable)e);
        }
    }

    private Object idToEnum(int id) throws HibernateException {
        this.ensureBidiMapInitialized();
        return this.bidiMap.getEnumValue(id);
    }

    private int enumToId(Object enumValue) throws HibernateException {
        this.ensureBidiMapInitialized();
        return this.bidiMap.getKey(enumValue);
    }

    static {
        CLASS_TO_SQL_CODE.put(Integer.class, 90001);
        CLASS_TO_SQL_CODE.put(Long.class, 90002);
        CLASS_TO_SQL_CODE.put(String.class, 90003);
        CLASS_TO_SQL_CODE.put(Float.class, 90005);
        CLASS_TO_SQL_CODE.put(Double.class, 90006);
        CLASS_TO_SQL_CODE.put(UUID.class, 90007);
    }
}

