/*
 * Decompiled with CFR 0.152.
 */
package net.kaleidos.hibernate.criterion.array;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import net.kaleidos.hibernate.usertype.ArrayType;
import net.kaleidos.hibernate.utils.PgArrayUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;

public class PgArrayExpression
implements Criterion,
GroovyObject {
    private static final long serialVersionUID = 2872183637309166619L;
    private final String propertyName;
    private final Object value;
    private final String op;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ long $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    protected PgArrayExpression(String propertyName, Object value, String op) {
        String string;
        Object object;
        String string2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.propertyName = string2 = propertyName;
        this.value = object = value;
        this.op = string = op;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        ArrayType arrayType = this.checkAndGetArrayType(criteria, criteriaQuery);
        String postgresArrayType = StringGroovyMethods.plus((String)PgArrayUtils.getNativeSqlType(arrayType.getTypeClass()), (CharSequence)"[]");
        return StringHelper.join((String)" and ", (String[])StringHelper.suffix((String[])criteriaQuery.findColumns(this.propertyName, criteria), (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.op, postgresArrayType}, new String[]{" ", " CAST(? as ", ")"}))));
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        ArrayType arrayType = this.checkAndGetArrayType(criteria, criteriaQuery);
        Object[] arrValue = null;
        if (arrayType.getTypeClass().isEnum()) {
            Object[] objectArray = PgArrayUtils.getValueAsArrayOfType(this.value, Integer.class, this.mapValueToEnumOrdinal());
            arrValue = objectArray;
        } else {
            Object[] objectArray;
            arrValue = objectArray = PgArrayUtils.getValueAsArrayOfType(this.value, arrayType.getTypeClass());
        }
        return (TypedValue[])ScriptBytecodeAdapter.asType((Object)criteriaQuery.getTypedValue(criteria, this.propertyName, (Object)arrValue), TypedValue[].class);
    }

    private PgArrayUtils.MapFunction mapValueToEnumOrdinal() {
        public final class _mapValueToEnumOrdinal_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _mapValueToEnumOrdinal_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object o) {
                Integer n = ((Enum)ScriptBytecodeAdapter.asType((Object)o, Enum.class)).ordinal();
                try {
                    return n;
                }
                catch (ClassCastException e) {
                    throw (Throwable)new HibernateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{o}, new String[]{"Unable to cast object ", " to Enum"})), (Throwable)e);
                }
            }

            public Object call(Object o) {
                return this.doCall(o);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mapValueToEnumOrdinal_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (PgArrayUtils.MapFunction)ScriptBytecodeAdapter.asType((Object)((Object)new _mapValueToEnumOrdinal_closure1(this, this)), PgArrayUtils.MapFunction.class);
    }

    private ArrayType checkAndGetArrayType(Criteria criteria, CriteriaQuery criteriaQuery) {
        Type propertyType = criteriaQuery.getType(criteria, this.propertyName);
        if (!(propertyType instanceof CustomType) || !(((CustomType)ScriptBytecodeAdapter.asType((Object)propertyType, CustomType.class)).getUserType() instanceof ArrayType)) {
            throw (Throwable)new HibernateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{propertyType.getClass()}, new String[]{"Property is not an instance of the postgres type ArrayType. Type is: ", ""})));
        }
        return (ArrayType)ScriptBytecodeAdapter.asType((Object)((CustomType)ScriptBytecodeAdapter.asType((Object)propertyType, CustomType.class)).getUserType(), ArrayType.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PgArrayExpression.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        long l;
        $const$0 = l = 2872183637309166619L;
    }

    static {
        PgArrayExpression.__$swapInit();
    }
}

