/*
 * Decompiled with CFR 0.152.
 */
package grails.converters;

import grails.core.support.proxy.EntityProxyHandler;
import grails.core.support.proxy.ProxyHandler;
import grails.util.GrailsNameUtils;
import grails.util.GrailsWebUtil;
import grails.web.mime.MimeType;
import groovy.lang.Closure;
import groovy.util.BuilderSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.buffer.FastStringWriter;
import org.grails.io.support.SpringIOUtils;
import org.grails.web.converters.AbstractConverter;
import org.grails.web.converters.Converter;
import org.grails.web.converters.ConverterUtil;
import org.grails.web.converters.IncludeExcludeConverter;
import org.grails.web.converters.configuration.ConverterConfiguration;
import org.grails.web.converters.configuration.ConvertersConfigurationHolder;
import org.grails.web.converters.configuration.DefaultConverterConfiguration;
import org.grails.web.converters.exceptions.ConverterException;
import org.grails.web.converters.marshaller.ClosureObjectMarshaller;
import org.grails.web.converters.marshaller.NameAwareMarshaller;
import org.grails.web.converters.marshaller.ObjectMarshaller;
import org.grails.web.xml.PrettyPrintXMLStreamWriter;
import org.grails.web.xml.StreamingMarkupWriter;
import org.grails.web.xml.XMLStreamWriter;
import org.springframework.util.Assert;

public class XML
extends AbstractConverter<XMLStreamWriter>
implements IncludeExcludeConverter<XMLStreamWriter> {
    public static final Log log = LogFactory.getLog(XML.class);
    private static final String CACHED_XML = "org.codehaus.groovy.grails.CACHED_XML_REQUEST_CONTENT";
    private Object target;
    private StreamingMarkupWriter stream;
    private final ConverterConfiguration<XML> config;
    private final String encoding;
    private final Converter.CircularReferenceBehaviour circularReferenceBehaviour;
    private XMLStreamWriter writer;
    private Stack<Object> referenceStack = new Stack();
    private boolean isRendering = false;

    public XML() {
        this.config = ConvertersConfigurationHolder.getConverterConfiguration(XML.class);
        this.encoding = this.config.getEncoding() != null ? this.config.getEncoding() : "UTF-8";
        this.contentType = MimeType.XML.getName();
        this.circularReferenceBehaviour = this.config.getCircularReferenceBehaviour();
    }

    public XML(Object target) {
        this();
        this.target = target;
    }

    public XML(XMLStreamWriter writer) {
        this();
        this.writer = writer;
        this.isRendering = true;
    }

    protected ConverterConfiguration<XML> initConfig() {
        return ConvertersConfigurationHolder.getConverterConfiguration(XML.class);
    }

    @Override
    public void setTarget(Object target) {
        this.target = target;
    }

    private void finalizeRender(Writer out) {
        try {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            log.warn((Object)("Unexpected exception while closing a writer: " + e.getMessage()));
        }
    }

    @Override
    public void render(Writer out) throws ConverterException {
        this.stream = new StreamingMarkupWriter(out, this.encoding);
        this.writer = this.config.isPrettyPrint() ? new PrettyPrintXMLStreamWriter((groovy.xml.streamingmarkupsupport.StreamingMarkupWriter)this.stream) : new XMLStreamWriter((groovy.xml.streamingmarkupsupport.StreamingMarkupWriter)this.stream);
        try {
            this.isRendering = true;
            this.writer.startDocument(this.encoding, "1.0");
            this.writer.startNode(this.getElementName(this.target));
            this.convertAnother(this.target);
            this.writer.end();
            this.finalizeRender(out);
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
        finally {
            this.isRendering = false;
        }
    }

    private void checkState() {
        Assert.state((boolean)this.isRendering, (String)"Illegal XML Converter call!");
    }

    public String getElementName(Object o) {
        ObjectMarshaller<XML> om = this.config.getMarshaller(o);
        if (om instanceof NameAwareMarshaller) {
            return ((NameAwareMarshaller)((Object)om)).getElementName(o);
        }
        ProxyHandler proxyHandler = this.config.getProxyHandler();
        if (proxyHandler.isProxy(o) && proxyHandler instanceof EntityProxyHandler) {
            EntityProxyHandler entityProxyHandler = (EntityProxyHandler)proxyHandler;
            Class cls = entityProxyHandler.getProxiedClass(o);
            return GrailsNameUtils.getPropertyName((Class)cls);
        }
        return GrailsNameUtils.getPropertyName(o.getClass());
    }

    @Override
    public void convertAnother(Object o) throws ConverterException {
        o = this.config.getProxyHandler().unwrapIfProxy(o);
        try {
            if (o != null) {
                if (o instanceof CharSequence) {
                    this.writer.characters(o.toString());
                } else if (o instanceof Class) {
                    this.writer.characters(((Class)o).getName());
                } else if (o.getClass().isPrimitive() && !o.getClass().equals(byte[].class) || o instanceof Number || o instanceof Boolean) {
                    this.writer.characters(String.valueOf(o));
                } else if (this.referenceStack.contains(o)) {
                    this.handleCircularRelationship(o);
                } else {
                    this.referenceStack.push(o);
                    ObjectMarshaller<XML> marshaller = this.config.getMarshaller(o);
                    if (marshaller == null) {
                        throw new ConverterException("Unconvertable Object of class: " + o.getClass().getName());
                    }
                    marshaller.marshalObject(o, this);
                    this.referenceStack.pop();
                }
            }
        }
        catch (Throwable t) {
            throw ConverterUtil.resolveConverterException(t);
        }
    }

    @Override
    public ObjectMarshaller<XML> lookupObjectMarshaller(Object target) {
        return this.config.getMarshaller(target);
    }

    public int getDepth() {
        return this.referenceStack.size();
    }

    public XML startNode(String tagName) {
        this.checkState();
        try {
            this.writer.startNode(tagName);
        }
        catch (Exception e) {
            throw ConverterUtil.resolveConverterException(e);
        }
        return this;
    }

    public XML chars(String chars) {
        this.checkState();
        try {
            this.writer.characters(chars);
        }
        catch (Exception e) {
            throw ConverterUtil.resolveConverterException(e);
        }
        return this;
    }

    public XML attribute(String name, String value) {
        this.checkState();
        try {
            this.writer.attribute(name, value);
        }
        catch (Exception e) {
            throw ConverterUtil.resolveConverterException(e);
        }
        return this;
    }

    public XML end() {
        this.checkState();
        try {
            this.writer.end();
        }
        catch (Exception e) {
            throw ConverterUtil.resolveConverterException(e);
        }
        return this;
    }

    protected void handleCircularRelationship(Object o) throws ConverterException {
        switch (this.circularReferenceBehaviour) {
            case DEFAULT: {
                StringBuilder ref = new StringBuilder();
                int idx = this.referenceStack.indexOf(o);
                for (int i = this.referenceStack.size() - 1; i > idx; --i) {
                    ref.append("../");
                }
                this.attribute("ref", ref.substring(0, ref.length() - 1));
                break;
            }
            case EXCEPTION: {
                throw new ConverterException("Circular Reference detected: class " + o.getClass().getName());
            }
            case INSERT_NULL: {
                this.convertAnother(null);
            }
        }
    }

    @Override
    public void render(HttpServletResponse response) throws ConverterException {
        response.setContentType(GrailsWebUtil.getContentType((String)this.contentType, (String)this.encoding));
        try {
            this.render(response.getWriter());
        }
        catch (IOException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public XMLStreamWriter getWriter() throws ConverterException {
        this.checkState();
        return this.writer;
    }

    public StreamingMarkupWriter getStream() {
        this.checkState();
        return this.stream;
    }

    @Override
    public void build(Closure c) throws ConverterException {
        new Builder(this).execute(c);
    }

    @Override
    public String toString() {
        FastStringWriter strw = new FastStringWriter();
        this.render((Writer)strw);
        strw.flush();
        return strw.toString();
    }

    public static Object parse(String source) throws ConverterException {
        try {
            return SpringIOUtils.createXmlSlurper().parseText(source);
        }
        catch (Exception e) {
            throw new ConverterException("Error parsing XML", e);
        }
    }

    public static Object parse(InputStream is, String encoding) throws ConverterException {
        try {
            InputStreamReader reader = new InputStreamReader(is, encoding);
            return SpringIOUtils.createXmlSlurper().parse((Reader)reader);
        }
        catch (Exception e) {
            throw new ConverterException("Error parsing XML", e);
        }
    }

    public static Object parse(HttpServletRequest request) throws ConverterException {
        Object xml = request.getAttribute(CACHED_XML);
        if (xml != null) {
            return xml;
        }
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            if (!request.getMethod().equalsIgnoreCase("GET")) {
                xml = XML.parse((InputStream)request.getInputStream(), encoding);
                request.setAttribute(CACHED_XML, xml);
            }
            return xml;
        }
        catch (IOException e) {
            throw new ConverterException("Error parsing XML", e);
        }
    }

    public static ConverterConfiguration<XML> getNamedConfig(String configName) throws ConverterException {
        ConverterConfiguration<XML> cfg = ConvertersConfigurationHolder.getNamedConverterConfiguration(configName, XML.class);
        if (cfg == null) {
            throw new ConverterException(String.format("Converter Configuration with name '%s' not found!", configName));
        }
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object use(String configName, Closure<?> callable) throws ConverterException {
        ConverterConfiguration<XML> old = ConvertersConfigurationHolder.getThreadLocalConverterConfiguration(XML.class);
        ConverterConfiguration<XML> cfg = XML.getNamedConfig(configName);
        ConvertersConfigurationHolder.setThreadLocalConverterConfiguration(XML.class, cfg);
        try {
            Object object = callable.call();
            return object;
        }
        finally {
            ConvertersConfigurationHolder.setThreadLocalConverterConfiguration(XML.class, old);
        }
    }

    public static void use(String cfgName) throws ConverterException {
        if (cfgName == null || "default".equals(cfgName)) {
            ConvertersConfigurationHolder.setThreadLocalConverterConfiguration(XML.class, null);
        } else {
            ConvertersConfigurationHolder.setThreadLocalConverterConfiguration(XML.class, XML.getNamedConfig(cfgName));
        }
    }

    public static void registerObjectMarshaller(Class<?> clazz, Closure<?> callable) throws ConverterException {
        XML.registerObjectMarshaller(new ClosureObjectMarshaller<XML>(clazz, callable));
    }

    public static void registerObjectMarshaller(Class<?> clazz, int priority, Closure<?> callable) throws ConverterException {
        XML.registerObjectMarshaller(new ClosureObjectMarshaller<XML>(clazz, callable), priority);
    }

    public static void registerObjectMarshaller(ObjectMarshaller<XML> om) throws ConverterException {
        ConverterConfiguration<XML> cfg = ConvertersConfigurationHolder.getConverterConfiguration(XML.class);
        if (cfg == null) {
            throw new ConverterException("Default Configuration not found for class " + XML.class.getName());
        }
        if (!(cfg instanceof DefaultConverterConfiguration)) {
            cfg = new DefaultConverterConfiguration<XML>(cfg);
            ConvertersConfigurationHolder.setDefaultConfiguration(XML.class, cfg);
        }
        ((DefaultConverterConfiguration)cfg).registerObjectMarshaller(om);
    }

    public static void registerObjectMarshaller(ObjectMarshaller<XML> om, int priority) throws ConverterException {
        ConverterConfiguration<XML> cfg = ConvertersConfigurationHolder.getConverterConfiguration(XML.class);
        if (cfg == null) {
            throw new ConverterException("Default Configuration not found for class " + XML.class.getName());
        }
        if (!(cfg instanceof DefaultConverterConfiguration)) {
            cfg = new DefaultConverterConfiguration<XML>(cfg);
            ConvertersConfigurationHolder.setDefaultConfiguration(XML.class, cfg);
        }
        ((DefaultConverterConfiguration)cfg).registerObjectMarshaller(om, priority);
    }

    public static void createNamedConfig(String name, Closure<?> callable) throws ConverterException {
        DefaultConverterConfiguration<XML> cfg = new DefaultConverterConfiguration<XML>(ConvertersConfigurationHolder.getConverterConfiguration(XML.class));
        try {
            callable.call(cfg);
            ConvertersConfigurationHolder.setNamedConverterConfiguration(XML.class, name, cfg);
        }
        catch (Exception e) {
            throw ConverterUtil.resolveConverterException(e);
        }
    }

    public static void withDefaultConfiguration(Closure<?> callable) throws ConverterException {
        ConverterConfiguration<XML> cfg = ConvertersConfigurationHolder.getConverterConfiguration(XML.class);
        if (!(cfg instanceof DefaultConverterConfiguration)) {
            cfg = new DefaultConverterConfiguration<XML>(cfg);
        }
        try {
            callable.call(cfg);
            ConvertersConfigurationHolder.setDefaultConfiguration(XML.class, cfg);
        }
        catch (Throwable t) {
            throw ConverterUtil.resolveConverterException(t);
        }
    }

    @Override
    public void setIncludes(List<String> includes) {
        this.setIncludes(this.target.getClass(), includes);
    }

    @Override
    public void setExcludes(List<String> excludes) {
        this.setExcludes(this.target.getClass(), excludes);
    }

    public class Builder
    extends BuilderSupport {
        private XML xml;

        public Builder(XML xml) {
            this.xml = xml;
        }

        public void execute(Closure<?> callable) {
            callable.setDelegate((Object)this);
            callable.call();
        }

        protected Object createNode(Object name) {
            return this.createNode(name, null, null);
        }

        protected Object createNode(Object name, Object value) {
            return this.createNode(name, null, value);
        }

        protected Object createNode(Object name, Map attributes) {
            return this.createNode(name, attributes, null);
        }

        protected Object createNode(Object name, Map attributes, Object value) {
            this.xml.startNode(name.toString());
            if (attributes != null) {
                Iterator iterator = attributes.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry attribute = o = iterator.next();
                    this.xml.attribute(attribute.getKey().toString(), attribute.getValue().toString());
                }
            }
            if (value != null) {
                this.xml.convertAnother(value);
            }
            return name;
        }

        protected void nodeCompleted(Object o, Object o1) {
            this.xml.end();
        }

        protected void setParent(Object o, Object o1) {
        }
    }
}

