/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SimpleKeyGenerator
implements KeyGenerator {
    public Object generate(Object target, Method method, Object ... params) {
        Object param;
        if (params.length == 0) {
            return SimpleKey.EMPTY;
        }
        if (params.length == 1 && (param = params[0]) != null && !param.getClass().isArray()) {
            return param;
        }
        return new SimpleKey(params);
    }

    public static final class SimpleKey
    implements Serializable {
        public static final SimpleKey EMPTY = new SimpleKey(new Object[0]);
        private final Object[] params;

        public SimpleKey(Object ... elements) {
            Assert.notNull((Object)elements, (String)"Elements must not be null");
            this.params = new Object[elements.length];
            System.arraycopy(elements, 0, this.params, 0, elements.length);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof SimpleKey && Arrays.deepEquals(this.params, ((SimpleKey)obj).params);
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.params);
        }

        public String toString() {
            return "SimpleKey [" + StringUtils.arrayToCommaDelimitedString((Object[])this.params) + "]";
        }
    }
}

