/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import grails.plugin.cache.GrailsCache;
import grails.plugin.cache.GrailsValueWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class GrailsConcurrentLinkedMapCache
implements GrailsCache {
    private static final Object NULL_HOLDER = new NullHolder();
    private String name;
    private long capacity;
    private final ConcurrentLinkedHashMap<Object, Object> store;
    private final boolean allowNullValues;

    public GrailsConcurrentLinkedMapCache(String name, long capacity, boolean allowNullValues) {
        this.name = name;
        this.capacity = capacity;
        this.allowNullValues = allowNullValues;
        this.store = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(capacity).build();
    }

    public GrailsConcurrentLinkedMapCache(String name, long capacity) {
        this(name, capacity, true);
    }

    public final long getCapacity() {
        return this.store.capacity();
    }

    public final String getName() {
        return this.name;
    }

    public final ConcurrentMap<Object, Object> getNativeCache() {
        return this.store;
    }

    public final int getSize() {
        return this.store.size();
    }

    public final boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    public GrailsValueWrapper get(Object key) {
        Object value = this.getNativeCache().get(key);
        return value == null ? null : new GrailsValueWrapper(this.fromStoreValue(value), null);
    }

    public <T> T get(Object key, Class<T> type) {
        Object value = this.getNativeCache().get(key);
        if (value != null && type != null && !type.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
        }
        return (T)value;
    }

    @Override
    public Collection<Object> getAllKeys() {
        return this.getNativeCache().keySet();
    }

    public Collection<Object> getHottestKeys() {
        return this.store.descendingKeySet();
    }

    public void put(Object key, Object value) {
        this.store.put(key, this.toStoreValue(value));
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object existing = this.store.putIfAbsent(key, value);
        return this.toWrapper(existing);
    }

    public void evict(Object key) {
        this.store.remove(key);
    }

    public void clear() {
        this.store.clear();
    }

    protected Object fromStoreValue(Object storeValue) {
        if (this.allowNullValues && storeValue == NULL_HOLDER) {
            return null;
        }
        return storeValue;
    }

    protected Object toStoreValue(Object userValue) {
        if (this.allowNullValues && userValue == null) {
            return NULL_HOLDER;
        }
        return userValue;
    }

    private Cache.ValueWrapper toWrapper(Object value) {
        return value != null ? new SimpleValueWrapper(this.fromStoreValue(value)) : null;
    }

    private static class NullHolder
    implements Serializable {
        private NullHolder() {
        }
    }
}

