/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import groovy.lang.GroovyObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsTagLibClass;
import org.codehaus.groovy.grails.exceptions.GrailsConfigurationException;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.web.pages.GroovyPage;
import org.codehaus.groovy.grails.web.taglib.NamespacedTagDispatcher;
import org.codehaus.groovy.grails.web.taglib.TemplateNamespacedTagDispatcher;
import org.codehaus.groovy.grails.web.util.WithCodecHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class TagLibraryLookup
implements ApplicationContextAware,
GrailsApplicationAware,
InitializingBean {
    protected ApplicationContext applicationContext;
    protected GrailsApplication grailsApplication;
    protected Map<String, Map<String, Object>> tagNamespaces = new HashMap<String, Map<String, Object>>();
    protected Map<String, NamespacedTagDispatcher> namespaceDispatchers = new HashMap<String, NamespacedTagDispatcher>();
    protected Map<String, Set<String>> tagsThatReturnObjectForNamespace = new HashMap<String, Set<String>>();
    protected Map<String, Map<String, Map<String, Object>>> encodeAsForTagNamespaces = new HashMap<String, Map<String, Map<String, Object>>>();

    public void afterPropertiesSet() throws Exception {
        if (this.grailsApplication == null || this.applicationContext == null) {
            return;
        }
        try {
            this.registerTagLibraries();
        }
        catch (GrailsConfigurationException grailsConfigurationException) {
            // empty catch block
        }
        this.registerTemplateNamespace();
    }

    protected void registerTagLibraries() {
        GrailsClass[] taglibs;
        for (GrailsClass grailsClass : taglibs = this.grailsApplication.getArtefacts("TagLib")) {
            this.registerTagLib((GrailsTagLibClass)grailsClass);
        }
    }

    protected void registerTemplateNamespace() {
        this.namespaceDispatchers.put("tmpl", new TemplateNamespacedTagDispatcher(GroovyPage.class, this.grailsApplication, this));
    }

    public void registerTagLib(GrailsTagLibClass taglib) {
        Map<String, Object> tags;
        String namespace = taglib.getNamespace();
        this.namespaceDispatchers.put(namespace, new NamespacedTagDispatcher(namespace, GroovyPage.class, this.grailsApplication, this));
        Set<String> tagsThatReturnObject = this.tagsThatReturnObjectForNamespace.get(namespace);
        if (tagsThatReturnObject == null) {
            tagsThatReturnObject = new HashSet<String>();
            this.tagsThatReturnObjectForNamespace.put(namespace, tagsThatReturnObject);
        }
        if ((tags = this.tagNamespaces.get(namespace)) == null) {
            tags = new HashMap<String, Object>();
            this.tagNamespaces.put(namespace, tags);
        }
        for (String tagName : taglib.getTagNames()) {
            this.putTagLib(tags, tagName, taglib);
            tagsThatReturnObject.remove(tagName);
        }
        for (String tagName : taglib.getTagNamesThatReturnObject()) {
            tagsThatReturnObject.add(tagName);
        }
        Map<String, Map<String, Object>> encodeAsForTagNamespace = this.encodeAsForTagNamespaces.get(namespace);
        if (encodeAsForTagNamespace == null) {
            encodeAsForTagNamespace = new HashMap<String, Map<String, Object>>();
            this.encodeAsForTagNamespaces.put(namespace, encodeAsForTagNamespace);
        }
        Map<String, Object> defaultEncodeAsForTagLib = null;
        if (taglib.getDefaultEncodeAs() != null) {
            defaultEncodeAsForTagLib = Collections.unmodifiableMap(WithCodecHelper.makeSettingsCanonical(taglib.getDefaultEncodeAs()));
        }
        for (String tagName : taglib.getTagNames()) {
            Object codecInfo = taglib.getEncodeAsForTag(tagName);
            Map<String, Object> codecInfoMap = WithCodecHelper.mergeSettingsAndMakeCanonical(codecInfo, defaultEncodeAsForTagLib);
            if (codecInfoMap == null) continue;
            encodeAsForTagNamespace.put(tagName, codecInfoMap);
        }
    }

    protected void putTagLib(Map<String, Object> tags, String name, GrailsTagLibClass taglib) {
        tags.put(name, this.applicationContext.getBean(taglib.getFullName()));
    }

    public GroovyObject lookupTagLibrary(String namespace, String tagName) {
        Map<String, Object> tags = this.tagNamespaces.get(namespace);
        if (tags == null) {
            return null;
        }
        return (GroovyObject)tags.get(tagName);
    }

    public boolean doesTagReturnObject(String namespace, String tagName) {
        Set<String> tagsThatReturnObject = this.tagsThatReturnObjectForNamespace.get(namespace);
        return tagsThatReturnObject != null && tagsThatReturnObject.contains(tagName);
    }

    public Map<String, Object> getEncodeAsForTag(String namespace, String tagName) {
        Map<String, Map<String, Object>> encodeAsForTagNamespace = this.encodeAsForTagNamespaces.get(namespace);
        return encodeAsForTagNamespace != null ? encodeAsForTagNamespace.get(tagName) : null;
    }

    public NamespacedTagDispatcher lookupNamespaceDispatcher(String namespace) {
        return this.namespaceDispatchers.get(namespace);
    }

    public boolean hasNamespace(String namespace) {
        return this.namespaceDispatchers.containsKey(namespace);
    }

    public Set<String> getAvailableNamespaces() {
        return this.namespaceDispatchers.keySet();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }
}

