/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.binding;

import grails.util.Environment;
import grails.validation.ValidationErrors;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.web.binding.GrailsDataBinder;
import org.codehaus.groovy.grails.web.binding.GrailsWebDataBinder;
import org.codehaus.groovy.grails.web.binding.bindingsource.DataBindingSourceRegistry;
import org.codehaus.groovy.grails.web.binding.bindingsource.DefaultDataBindingSourceRegistry;
import org.codehaus.groovy.grails.web.mime.MimeType;
import org.codehaus.groovy.grails.web.mime.MimeTypeResolver;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.databinding.CollectionDataBindingSource;
import org.grails.databinding.DataBinder;
import org.grails.databinding.DataBindingSource;
import org.grails.databinding.bindingsource.InvalidRequestBodyException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.context.request.RequestContextHolder;

public class DataBindingUtils {
    public static final String DATA_BINDER_BEAN_NAME = "grailsWebDataBinder";
    private static final String BLANK = "";
    private static final Map<Class, List> CLASS_TO_BINDING_INCLUDE_LIST = new ConcurrentHashMap<Class, List>();

    public static void assignBidirectionalAssociations(Object object, Map source, GrailsDomainClass domainClass) {
        if (source == null) {
            return;
        }
        for (Object key : source.keySet()) {
            GrailsDomainClassProperty prop;
            String propertyName = key.toString();
            if (propertyName.indexOf(46) > -1) {
                propertyName = propertyName.substring(0, propertyName.indexOf(46));
            }
            if (!domainClass.hasPersistentProperty(propertyName) || (prop = domainClass.getPropertyByName(propertyName)) == null || !prop.isOneToOne() || !prop.isBidirectional()) continue;
            Object val = source.get(key);
            GrailsDomainClassProperty otherSide = prop.getOtherSide();
            if (val == null || otherSide == null) continue;
            MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(val.getClass());
            try {
                mc.setProperty(val, otherSide.getName(), object);
            }
            catch (Exception e) {}
        }
    }

    public static BindingResult bindObjectToInstance(Object object, Object source) {
        return DataBindingUtils.bindObjectToInstance(object, source, DataBindingUtils.getBindingIncludeList(object), Collections.EMPTY_LIST, null);
    }

    private static List getBindingIncludeList(Object object) {
        List includeList = Collections.EMPTY_LIST;
        try {
            Class<?> objectClass = object.getClass();
            if (CLASS_TO_BINDING_INCLUDE_LIST.containsKey(objectClass)) {
                includeList = CLASS_TO_BINDING_INCLUDE_LIST.get(objectClass);
            } else {
                Object whiteListValue;
                Field whiteListField = objectClass.getDeclaredField("$defaultDatabindingWhiteList");
                if (whiteListField != null && (whiteListField.getModifiers() & 8) != 0 && (whiteListValue = whiteListField.get(objectClass)) instanceof List) {
                    includeList = (List)whiteListValue;
                }
                if (!Environment.getCurrent().isReloadEnabled()) {
                    CLASS_TO_BINDING_INCLUDE_LIST.put(objectClass, includeList);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return includeList;
    }

    public static BindingResult bindObjectToDomainInstance(GrailsDomainClass domain, Object object, Object source) {
        return DataBindingUtils.bindObjectToDomainInstance(domain, object, source, DataBindingUtils.getBindingIncludeList(object), Collections.EMPTY_LIST, null);
    }

    public static <T> void bindToCollection(Class<T> targetType, Collection<T> collectionToPopulate, CollectionDataBindingSource collectionBindingSource) throws InstantiationException, IllegalAccessException {
        GrailsApplication application = GrailsWebRequest.lookupApplication();
        GrailsDomainClass domain = null;
        if (application != null) {
            domain = (GrailsDomainClass)application.getArtefact("Domain", targetType.getName());
        }
        List dataBindingSources = collectionBindingSource.getDataBindingSources();
        for (DataBindingSource dataBindingSource : dataBindingSources) {
            T newObject = targetType.newInstance();
            DataBindingUtils.bindObjectToDomainInstance(domain, newObject, dataBindingSource, DataBindingUtils.getBindingIncludeList(newObject), Collections.EMPTY_LIST, null);
            collectionToPopulate.add(newObject);
        }
    }

    public static <T> void bindToCollection(Class<T> targetType, Collection<T> collectionToPopulate, ServletRequest request) throws InstantiationException, IllegalAccessException {
        GrailsApplication grailsApplication = GrailsWebRequest.lookupApplication();
        CollectionDataBindingSource collectionDataBindingSource = DataBindingUtils.createCollectionDataBindingSource(grailsApplication, targetType, request);
        DataBindingUtils.bindToCollection(targetType, collectionToPopulate, collectionDataBindingSource);
    }

    public static BindingResult bindObjectToInstance(Object object, Object source, List include, List exclude, String filter) {
        if (include == null && exclude == null) {
            include = DataBindingUtils.getBindingIncludeList(object);
        }
        GrailsApplication application = GrailsWebRequest.lookupApplication();
        GrailsDomainClass domain = null;
        if (application != null) {
            domain = (GrailsDomainClass)application.getArtefact("Domain", object.getClass().getName());
        }
        return DataBindingUtils.bindObjectToDomainInstance(domain, object, source, include, exclude, filter);
    }

    public static BindingResult bindObjectToDomainInstance(GrailsDomainClass domain, Object object, Object source, List include, List exclude, String filter) {
        MetaClass mc;
        GrailsDataBinder binder;
        BeanPropertyBindingResult bindingResult = null;
        boolean useSpringBinder = false;
        GrailsApplication grailsApplication = null;
        if (domain != null) {
            grailsApplication = domain.getGrailsApplication();
        }
        if (grailsApplication == null) {
            grailsApplication = GrailsWebRequest.lookupApplication();
        }
        if (grailsApplication != null && Boolean.TRUE.equals(grailsApplication.getFlatConfig().get("grails.databinding.useSpringBinder"))) {
            useSpringBinder = true;
        }
        if (!useSpringBinder) {
            try {
                DataBindingSource bindingSource = DataBindingUtils.createDataBindingSource(grailsApplication, object.getClass(), source);
                DataBinder grailsWebDataBinder = DataBindingUtils.getGrailsWebDataBinder(grailsApplication);
                grailsWebDataBinder.bind(object, bindingSource, filter, include, exclude);
            }
            catch (InvalidRequestBodyException e) {
                String messageCode = "invalidRequestBody";
                Class<?> objectType = object.getClass();
                String defaultMessage = "An error occurred parsing the body of the request";
                String[] codes = DataBindingUtils.getMessageCodes(messageCode, objectType);
                bindingResult = new BeanPropertyBindingResult(object, objectType.getName());
                bindingResult.addError(new ObjectError(bindingResult.getObjectName(), codes, null, defaultMessage));
            }
            catch (Exception e) {
                bindingResult = new BeanPropertyBindingResult(object, object.getClass().getName());
                bindingResult.addError(new ObjectError(bindingResult.getObjectName(), e.getMessage()));
            }
        } else if (source instanceof GrailsParameterMap) {
            GrailsParameterMap parameterMap = (GrailsParameterMap)source;
            HttpServletRequest request = parameterMap.getRequest();
            GrailsDataBinder dataBinder = DataBindingUtils.createDataBinder(object, include, exclude, request);
            dataBinder.bind(parameterMap, filter);
            bindingResult = dataBinder.getBindingResult();
        } else if (source instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)source;
            GrailsDataBinder dataBinder = DataBindingUtils.createDataBinder(object, include, exclude, request);
            DataBindingUtils.performBindFromRequest(dataBinder, request, filter);
            bindingResult = dataBinder.getBindingResult();
        } else if (source instanceof Map) {
            Map propertyMap = DataBindingUtils.convertPotentialGStrings((Map)source);
            binder = DataBindingUtils.createDataBinder(object, include, exclude, null);
            DataBindingUtils.performBindFromPropertyValues(binder, new MutablePropertyValues(propertyMap), filter);
            bindingResult = binder.getBindingResult();
        } else {
            GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.getRequestAttributes();
            if (webRequest != null) {
                binder = DataBindingUtils.createDataBinder(object, include, exclude, webRequest.getCurrentRequest());
                HttpServletRequest request = webRequest.getCurrentRequest();
                DataBindingUtils.performBindFromRequest(binder, request, filter);
                bindingResult = binder.getBindingResult();
            }
        }
        if (domain != null && bindingResult != null) {
            ValidationErrors newResult = new ValidationErrors(object);
            for (Object error : bindingResult.getAllErrors()) {
                if (error instanceof FieldError) {
                    FieldError fieldError = (FieldError)error;
                    boolean isBlank = BLANK.equals(fieldError.getRejectedValue());
                    if (!isBlank) {
                        newResult.addError((ObjectError)fieldError);
                        continue;
                    }
                    if (domain.hasPersistentProperty(fieldError.getField())) {
                        boolean isOptional = domain.getPropertyByName(fieldError.getField()).isOptional();
                        if (isOptional) continue;
                        newResult.addError((ObjectError)fieldError);
                        continue;
                    }
                    newResult.addError((ObjectError)fieldError);
                    continue;
                }
                newResult.addError((ObjectError)error);
            }
            bindingResult = newResult;
        }
        if ((mc = GroovySystem.getMetaClassRegistry().getMetaClass(object.getClass())).hasProperty(object, "errors") != null && bindingResult != null) {
            ValidationErrors errors = new ValidationErrors(object);
            errors.addAllErrors((Errors)bindingResult);
            mc.setProperty(object, "errors", (Object)errors);
        }
        return bindingResult;
    }

    protected static String[] getMessageCodes(String messageCode, Class objectType) {
        String[] codes = new String[]{objectType.getName() + "." + messageCode, messageCode};
        return codes;
    }

    public static DataBindingSourceRegistry getDataBindingSourceRegistry(GrailsApplication grailsApplication) {
        ApplicationContext context;
        DataBindingSourceRegistry registry = null;
        if (grailsApplication != null && (context = grailsApplication.getMainContext()) != null && context.containsBean("dataBindingSourceRegistry")) {
            registry = (DataBindingSourceRegistry)context.getBean("dataBindingSourceRegistry", DataBindingSourceRegistry.class);
        }
        if (registry == null) {
            registry = new DefaultDataBindingSourceRegistry();
        }
        return registry;
    }

    public static DataBindingSource createDataBindingSource(GrailsApplication grailsApplication, Class bindingTargetType, Object bindingSource) {
        DataBindingSourceRegistry registry = DataBindingUtils.getDataBindingSourceRegistry(grailsApplication);
        MimeType mimeType = DataBindingUtils.getMimeType(grailsApplication, bindingSource);
        return registry.createDataBindingSource(mimeType, bindingTargetType, bindingSource);
    }

    public static CollectionDataBindingSource createCollectionDataBindingSource(GrailsApplication grailsApplication, Class bindingTargetType, Object bindingSource) {
        DataBindingSourceRegistry registry = DataBindingUtils.getDataBindingSourceRegistry(grailsApplication);
        MimeType mimeType = DataBindingUtils.getMimeType(grailsApplication, bindingSource);
        return registry.createCollectionDataBindingSource(mimeType, bindingTargetType, bindingSource);
    }

    public static MimeType getMimeType(GrailsApplication grailsApplication, Object bindingSource) {
        MimeTypeResolver mimeTypeResolver = DataBindingUtils.getMimeTypeResolver(grailsApplication);
        return DataBindingUtils.resolveMimeType(bindingSource, mimeTypeResolver);
    }

    public static MimeTypeResolver getMimeTypeResolver(GrailsApplication grailsApplication) {
        ApplicationContext context;
        MimeTypeResolver mimeTypeResolver = null;
        if (grailsApplication != null && (context = grailsApplication.getMainContext()) != null && context.containsBean("mimeTypeResolver")) {
            mimeTypeResolver = (MimeTypeResolver)context.getBean("mimeTypeResolver", MimeTypeResolver.class);
        }
        return mimeTypeResolver;
    }

    public static MimeType resolveMimeType(Object bindingSource, MimeTypeResolver mimeTypeResolver) {
        HttpServletRequest req;
        String contentType;
        MimeType resolvedMimeType;
        MimeType mimeType = mimeTypeResolver != null ? ((resolvedMimeType = mimeTypeResolver.resolveRequestMimeType()) != null ? resolvedMimeType : MimeType.ALL) : (bindingSource instanceof HttpServletRequest ? ((contentType = (req = (HttpServletRequest)bindingSource).getContentType()) != null ? new MimeType(contentType) : MimeType.ALL) : MimeType.ALL);
        return mimeType;
    }

    private static DataBinder getGrailsWebDataBinder(GrailsApplication grailsApplication) {
        ApplicationContext mainContext;
        GrailsWebDataBinder dataBinder = null;
        if (grailsApplication != null && (mainContext = grailsApplication.getMainContext()) != null && mainContext.containsBean(DATA_BINDER_BEAN_NAME)) {
            dataBinder = (DataBinder)mainContext.getBean(DATA_BINDER_BEAN_NAME, DataBinder.class);
        }
        if (dataBinder == null) {
            dataBinder = new GrailsWebDataBinder(grailsApplication);
        }
        return dataBinder;
    }

    private static void performBindFromPropertyValues(GrailsDataBinder binder, MutablePropertyValues mutablePropertyValues, String filter) {
        if (filter != null) {
            binder.bind((PropertyValues)mutablePropertyValues, filter);
        } else {
            binder.bind((PropertyValues)mutablePropertyValues);
        }
    }

    private static void performBindFromRequest(GrailsDataBinder binder, HttpServletRequest request, String filter) {
        if (filter != null) {
            binder.bind((ServletRequest)request, filter);
        } else {
            binder.bind((ServletRequest)request);
        }
    }

    private static GrailsDataBinder createDataBinder(Object object, List include, List exclude, HttpServletRequest request) {
        GrailsDataBinder binder = request == null ? GrailsDataBinder.createBinder(object, object.getClass().getName()) : GrailsDataBinder.createBinder(object, object.getClass().getName(), request);
        DataBindingUtils.includeExcludeFields(binder, include, exclude);
        return binder;
    }

    public static Map convertPotentialGStrings(Map<Object, Object> args) {
        HashMap<Object, Object> newArgs = new HashMap<Object, Object>(args.size());
        for (Map.Entry<Object, Object> entry : args.entrySet()) {
            newArgs.put(DataBindingUtils.unwrapGString(entry.getKey()), DataBindingUtils.unwrapGString(entry.getValue()));
        }
        return newArgs;
    }

    private static Object unwrapGString(Object value) {
        if (value instanceof CharSequence) {
            return value.toString();
        }
        return value;
    }

    private static void includeExcludeFields(GrailsDataBinder dataBinder, List allowed, List disallowed) {
        DataBindingUtils.updateAllowed(dataBinder, allowed);
        DataBindingUtils.updateDisallowed(dataBinder, allowed, disallowed);
    }

    private static void updateAllowed(GrailsDataBinder binder, List allowed) {
        if (allowed == null) {
            return;
        }
        String[] currentAllowed = binder.getAllowedFields();
        ArrayList<String> newAllowed = new ArrayList<String>(allowed);
        newAllowed.addAll(Arrays.asList(currentAllowed));
        String[] value = new String[newAllowed.size()];
        newAllowed.toArray(value);
        binder.setAllowedFields(value);
    }

    private static void updateDisallowed(GrailsDataBinder binder, List allowed, List disallowed) {
        if (disallowed == null) {
            return;
        }
        String[] currentDisallowed = binder.getDisallowedFields();
        ArrayList<String> newDisallowed = new ArrayList<String>(disallowed);
        if (allowed == null) {
            newDisallowed.addAll(Arrays.asList(currentDisallowed));
        } else {
            for (String s : currentDisallowed) {
                if (allowed.contains(s)) continue;
                newDisallowed.add(s);
            }
        }
        String[] value = new String[newDisallowed.size()];
        newDisallowed.toArray(value);
        binder.setDisallowedFields(value);
    }
}

