/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.sitemesh;

import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.sitemesh.Content;
import grails.util.Environment;
import groovy.lang.GroovyObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.codehaus.groovy.grails.web.servlet.view.GroovyPageView;
import org.codehaus.groovy.grails.web.sitemesh.GSPSitemeshPage;
import org.codehaus.groovy.grails.web.sitemesh.GrailsLayoutDecoratorMapper;
import org.codehaus.groovy.grails.web.sitemesh.SpringMVCViewDecorator;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class GroovyPageLayoutFinder {
    public static final String LAYOUT_ATTRIBUTE = "org.grails.layout.name";
    public static final String NONE_LAYOUT = "_none_";
    public static final String RENDERING_VIEW_ATTRIBUTE = "org.grails.rendering.view";
    private static final Log LOG = LogFactory.getLog(GrailsLayoutDecoratorMapper.class);
    private static final long LAYOUT_CACHE_EXPIRATION_MILLIS = Long.getLong("grails.gsp.reload.interval", 5000L);
    private static final String LAYOUTS_PATH = "/layouts";
    private Map<String, DecoratorCacheValue> decoratorCache = new ConcurrentHashMap<String, DecoratorCacheValue>();
    private Map<LayoutCacheKey, DecoratorCacheValue> layoutDecoratorCache = new ConcurrentHashMap<LayoutCacheKey, DecoratorCacheValue>();
    private String defaultDecoratorName;
    private boolean gspReloadEnabled;
    private boolean cacheEnabled = Environment.getCurrent() != Environment.DEVELOPMENT;
    private ViewResolver viewResolver;
    private boolean enableNonGspViews = false;

    public void setDefaultDecoratorName(String defaultDecoratorName) {
        this.defaultDecoratorName = defaultDecoratorName;
    }

    public void setEnableNonGspViews(boolean enableNonGspViews) {
        this.enableNonGspViews = enableNonGspViews;
    }

    public void setGspReloadEnabled(boolean gspReloadEnabled) {
        this.gspReloadEnabled = gspReloadEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public void setViewResolver(ViewResolver viewResolver) {
        this.viewResolver = viewResolver;
    }

    public Decorator findLayout(HttpServletRequest request, Content page) {
        return this.findLayout(request, (Page)GSPSitemeshPage.content2htmlPage(page));
    }

    public Decorator findLayout(HttpServletRequest request, Page page) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Evaluating layout for request: " + request.getRequestURI()));
        }
        Object layoutAttribute = request.getAttribute(LAYOUT_ATTRIBUTE);
        if (request.getAttribute(RENDERING_VIEW_ATTRIBUTE) != null || layoutAttribute != null) {
            String layoutName;
            String string = layoutName = layoutAttribute == null ? null : layoutAttribute.toString();
            if (layoutName == null) {
                layoutName = page.getProperty("meta.layout");
            }
            Decorator d = null;
            if (StringUtils.isBlank((String)layoutName)) {
                GroovyObject controller = (GroovyObject)request.getAttribute("org.codehaus.groovy.grails.CONTROLLER");
                if (controller != null) {
                    DecoratorCacheValue cacheValue;
                    String controllerName = (String)controller.getProperty("controllerName");
                    String actionUri = (String)controller.getProperty("actionUri");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Found controller in request, location layout for controller [" + controllerName + "] and action [" + actionUri + "]"));
                    }
                    LayoutCacheKey cacheKey = null;
                    boolean cachedIsNull = false;
                    if (!(!this.cacheEnabled || (cacheValue = this.layoutDecoratorCache.get(cacheKey = new LayoutCacheKey(controllerName, actionUri))) == null || this.gspReloadEnabled && cacheValue.isExpired() || (d = cacheValue.getDecorator()) != null)) {
                        cachedIsNull = true;
                    }
                    if (d == null && !cachedIsNull) {
                        d = this.resolveDecorator(request, controller, controllerName, actionUri);
                        if (this.cacheEnabled) {
                            this.layoutDecoratorCache.put(cacheKey, new DecoratorCacheValue(d));
                        }
                    }
                } else {
                    d = this.getApplicationDefaultDecorator(request);
                }
            } else {
                d = this.getNamedDecorator(request, layoutName);
            }
            if (d != null) {
                return d;
            }
        }
        return null;
    }

    protected Decorator getApplicationDefaultDecorator(HttpServletRequest request) {
        return this.getNamedDecorator(request, this.defaultDecoratorName == null ? "application" : this.defaultDecoratorName, !this.enableNonGspViews || this.defaultDecoratorName == null);
    }

    public Decorator getNamedDecorator(HttpServletRequest request, String name) {
        return this.getNamedDecorator(request, name, !this.enableNonGspViews);
    }

    public Decorator getNamedDecorator(HttpServletRequest request, String name, boolean viewMustExist) {
        View view;
        DecoratorCacheValue cacheValue;
        if (StringUtils.isBlank((String)name) || NONE_LAYOUT.equals(name)) {
            return null;
        }
        if (!(!this.cacheEnabled || (cacheValue = this.decoratorCache.get(name)) == null || this.gspReloadEnabled && cacheValue.isExpired())) {
            return cacheValue.getDecorator();
        }
        try {
            view = this.viewResolver.resolveViewName(GrailsResourceUtils.appendPiecesForUri((String[])new String[]{LAYOUTS_PATH, name}), request.getLocale());
            if (viewMustExist && !(view instanceof GroovyPageView)) {
                view = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to resolve view", e);
        }
        Decorator d = null;
        if (view != null) {
            d = this.createDecorator(name, view);
        }
        if (this.cacheEnabled) {
            this.decoratorCache.put(name, new DecoratorCacheValue(d));
        }
        return d;
    }

    private Decorator resolveDecorator(HttpServletRequest request, GroovyObject controller, String controllerName, String actionUri) {
        Decorator d = null;
        Object layoutProperty = GrailsClassUtils.getStaticPropertyValue(controller.getClass(), (String)"layout");
        if (layoutProperty instanceof CharSequence) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("layout property found in controller, looking for template named " + layoutProperty));
            }
            d = this.getNamedDecorator(request, layoutProperty.toString());
        } else {
            if (d == null && !StringUtils.isBlank((String)actionUri)) {
                d = this.getNamedDecorator(request, actionUri.substring(1), true);
            }
            if (d == null && !StringUtils.isBlank((String)controllerName)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Action layout not found, trying controller");
                }
                d = this.getNamedDecorator(request, controllerName, true);
            }
            if (d == null) {
                d = this.getApplicationDefaultDecorator(request);
            }
        }
        return d;
    }

    private Decorator createDecorator(String decoratorName, View view) {
        return new SpringMVCViewDecorator(decoratorName, view);
    }

    private static class DecoratorCacheValue {
        Decorator decorator;
        long createTimestamp = System.currentTimeMillis();

        public DecoratorCacheValue(Decorator decorator) {
            this.decorator = decorator;
        }

        public Decorator getDecorator() {
            return this.decorator;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.createTimestamp > LAYOUT_CACHE_EXPIRATION_MILLIS;
        }
    }

    private static class LayoutCacheKey {
        private String controllerName;
        private String actionUri;

        public LayoutCacheKey(String controllerName, String actionUri) {
            this.controllerName = controllerName;
            this.actionUri = actionUri;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.actionUri).append((Object)this.controllerName).toHashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LayoutCacheKey other = (LayoutCacheKey)obj;
            return new EqualsBuilder().append((Object)other.actionUri, (Object)this.actionUri).append((Object)other.controllerName, (Object)this.controllerName).isEquals();
        }
    }
}

