/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weigher;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.web.mapping.UrlCreator;

public class UrlCreatorCache {
    private final ConcurrentMap<ReverseMappingKey, CachingUrlCreator> cacheMap;

    public UrlCreatorCache(int maxSize) {
        this.cacheMap = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)maxSize).weigher((Weigher)CachingUrlCreatorWeigher.INSTANCE).build();
    }

    public void clear() {
        this.cacheMap.clear();
    }

    public ReverseMappingKey createKey(String controller, String action, String namespace, String pluginName, String httpMethod, Map params) {
        return new ReverseMappingKey(controller, action, namespace, pluginName, httpMethod, params);
    }

    public UrlCreator lookup(ReverseMappingKey key) {
        return (UrlCreator)this.cacheMap.get(key);
    }

    public UrlCreator putAndDecorate(ReverseMappingKey key, UrlCreator delegate) {
        CachingUrlCreator cachingUrlCreator = new CachingUrlCreator(delegate, key.weight() * 2);
        CachingUrlCreator prevCachingUrlCreator = this.cacheMap.putIfAbsent(key, cachingUrlCreator);
        if (prevCachingUrlCreator != null) {
            return prevCachingUrlCreator;
        }
        return cachingUrlCreator;
    }

    private static class UrlCreatorKey
    extends ReverseMappingKey {
        protected final String encoding;
        protected final String fragment;
        protected final int urlType;

        public UrlCreatorKey(String controller, String action, String namespace, String pluginName, String httpMethod, Map<Object, Object> params, String encoding, String fragment, int urlType) {
            super(controller, action, namespace, pluginName, httpMethod, params);
            this.encoding = encoding != null ? encoding.toLowerCase() : null;
            this.fragment = fragment;
            this.urlType = urlType;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
            result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
            result = 31 * result + this.urlType;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UrlCreatorKey other = (UrlCreatorKey)obj;
            if (this.encoding == null ? other.encoding != null : !this.encoding.equals(other.encoding)) {
                return false;
            }
            if (this.fragment == null ? other.fragment != null : !this.fragment.equals(other.fragment)) {
                return false;
            }
            return this.urlType == other.urlType;
        }

        @Override
        public String toString() {
            return "UrlCreatorCache.UrlCreatorKey [encoding=" + this.encoding + ", fragment=" + this.fragment + ", urlType=" + this.urlType + ", action=" + this.action + ", controller=" + this.controller + ", namespace=" + this.namespace + ", plugin=" + this.pluginName + ", paramKeys=" + Arrays.toString(this.paramKeys) + ", paramValues=" + Arrays.toString(this.paramValues) + "]";
        }
    }

    public static class ReverseMappingKey {
        protected final String controller;
        protected final String action;
        protected final String namespace;
        protected final String pluginName;
        protected final String httpMethod;
        protected final String[] paramKeys;
        protected final String[] paramValues;

        public ReverseMappingKey(String controller, String action, String namespace, String pluginName, String httpMethod, Map<Object, Object> params) {
            this.controller = controller;
            this.action = action;
            this.namespace = namespace;
            this.pluginName = pluginName;
            this.httpMethod = httpMethod != null && !"*".equalsIgnoreCase(httpMethod) ? httpMethod : null;
            if (params != null) {
                this.paramKeys = new String[params.size()];
                this.paramValues = new String[params.size()];
                int i = 0;
                for (Map.Entry<Object, Object> entry : params.entrySet()) {
                    this.paramKeys[i] = String.valueOf(entry.getKey());
                    String value = null;
                    value = entry.getValue() instanceof CharSequence ? String.valueOf(entry.getValue()) : (entry.getValue() instanceof Collection ? StringUtils.join((Collection)((Collection)entry.getValue()), (char)',') : (entry.getValue() instanceof Object[] ? StringUtils.join((Object[])((Object[])entry.getValue()), (char)',') : String.valueOf(entry.getValue())));
                    this.paramValues[i] = value;
                    ++i;
                }
            } else {
                this.paramKeys = new String[0];
                this.paramValues = new String[0];
            }
        }

        public int weight() {
            int i;
            int weight = 0;
            weight += this.controller != null ? this.controller.length() : 0;
            weight += this.action != null ? this.action.length() : 0;
            weight += this.namespace != null ? this.namespace.length() : 0;
            weight += this.pluginName != null ? this.pluginName.length() : 0;
            for (i = 0; i < this.paramKeys.length; ++i) {
                weight += this.paramKeys[i] != null ? this.paramKeys[i].length() : 0;
            }
            for (i = 0; i < this.paramValues.length; ++i) {
                weight += this.paramValues[i] != null ? this.paramValues[i].length() : 0;
            }
            return weight;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
            result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
            result = 31 * result + (this.pluginName == null ? 0 : this.pluginName.hashCode());
            result = 31 * result + (this.controller == null ? 0 : this.controller.hashCode());
            result = 31 * result + Arrays.hashCode(this.paramKeys);
            result = 31 * result + Arrays.hashCode(this.paramValues);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReverseMappingKey other = (ReverseMappingKey)obj;
            if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
                return false;
            }
            if (this.controller == null ? other.controller != null : !this.controller.equals(other.controller)) {
                return false;
            }
            if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
                return false;
            }
            if (this.pluginName == null ? other.pluginName != null : !this.pluginName.equals(other.pluginName)) {
                return false;
            }
            if (this.httpMethod == null ? other.httpMethod != null : !this.httpMethod.equals(other.httpMethod)) {
                return false;
            }
            if (!Arrays.equals(this.paramKeys, other.paramKeys)) {
                return false;
            }
            return Arrays.equals(this.paramValues, other.paramValues);
        }

        public String toString() {
            return "UrlCreatorCache.ReverseMappingKey [action=" + this.action + ", controller=" + this.controller + ", namespace=" + this.namespace + ", plugin=" + this.pluginName + ", paramKeys=" + Arrays.toString(this.paramKeys) + ", paramValues=" + Arrays.toString(this.paramValues) + "]";
        }
    }

    private class CachingUrlCreator
    implements UrlCreator {
        private UrlCreator delegate;
        private ConcurrentHashMap<UrlCreatorKey, String> cache = new ConcurrentHashMap();
        private final int weight;

        public CachingUrlCreator(UrlCreator delegate, int weight) {
            this.delegate = delegate;
            this.weight = weight;
        }

        public int weight() {
            return this.weight;
        }

        @Override
        public String createRelativeURL(String controller, String action, Map parameterValues, String encoding, String fragment) {
            return this.createRelativeURL(controller, action, null, null, parameterValues, encoding, fragment);
        }

        @Override
        public String createRelativeURL(String controller, String action, String pluginName, Map parameterValues, String encoding) {
            return this.createRelativeURL(controller, action, null, pluginName, parameterValues, encoding);
        }

        @Override
        public String createRelativeURL(String controller, String action, String namespace, String pluginName, Map parameterValues, String encoding, String fragment) {
            UrlCreatorKey key = new UrlCreatorKey(controller, action, namespace, pluginName, null, parameterValues, encoding, fragment, 0);
            String url = this.cache.get(key);
            if (url == null) {
                url = this.delegate.createRelativeURL(controller, action, namespace, pluginName, parameterValues, encoding, fragment);
                this.cache.put(key, url);
            }
            return url;
        }

        @Override
        public String createRelativeURL(String controller, String action, Map parameterValues, String encoding) {
            return this.createRelativeURL(controller, action, null, null, parameterValues, encoding);
        }

        @Override
        public String createRelativeURL(String controller, String action, String namespace, String pluginName, Map parameterValues, String encoding) {
            UrlCreatorKey key = new UrlCreatorKey(controller, action, namespace, pluginName, null, parameterValues, encoding, null, 0);
            String url = this.cache.get(key);
            if (url == null) {
                url = this.delegate.createRelativeURL(controller, action, namespace, pluginName, parameterValues, encoding);
                this.cache.put(key, url);
            }
            return url;
        }

        @Override
        public String createURL(String controller, String action, Map parameterValues, String encoding, String fragment) {
            return this.createURL(controller, action, null, null, parameterValues, encoding, fragment);
        }

        @Override
        public String createURL(String controller, String action, String pluginName, Map parameterValues, String encoding) {
            return this.createURL(controller, action, null, pluginName, parameterValues, encoding);
        }

        @Override
        public String createURL(String controller, String action, String namespace, String pluginName, Map parameterValues, String encoding, String fragment) {
            UrlCreatorKey key = new UrlCreatorKey(controller, action, namespace, pluginName, null, parameterValues, encoding, fragment, 1);
            String url = this.cache.get(key);
            if (url == null) {
                url = this.delegate.createURL(controller, action, namespace, pluginName, parameterValues, encoding, fragment);
                this.cache.put(key, url);
            }
            return url;
        }

        @Override
        public String createURL(String controller, String action, Map parameterValues, String encoding) {
            return this.createURL(controller, action, null, null, parameterValues, encoding);
        }

        @Override
        public String createURL(String controller, String action, String namespace, String pluginName, Map parameterValues, String encoding) {
            UrlCreatorKey key = new UrlCreatorKey(controller, action, namespace, pluginName, null, parameterValues, encoding, null, 1);
            String url = this.cache.get(key);
            if (url == null) {
                url = this.delegate.createURL(controller, action, namespace, pluginName, parameterValues, encoding);
                this.cache.put(key, url);
            }
            return url;
        }

        @Override
        public String createURL(Map parameterValues, String encoding, String fragment) {
            return this.delegate.createURL(parameterValues, encoding, fragment);
        }

        @Override
        public String createURL(Map parameterValues, String encoding) {
            return this.delegate.createURL(parameterValues, encoding);
        }
    }

    private static enum CachingUrlCreatorWeigher implements Weigher<CachingUrlCreator>
    {
        INSTANCE;


        public int weightOf(CachingUrlCreator cachingUrlCreator) {
            return cachingUrlCreator.weight() + 1;
        }
    }
}

