/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import java.io.IOException;
import java.io.Writer;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriter;

public class GrailsLazyProxyPrintWriter
extends GrailsPrintWriter {
    private DestinationFactory factory;
    private boolean destinationActivated = false;

    public GrailsLazyProxyPrintWriter(DestinationFactory factory) {
        super(null);
        this.factory = factory;
    }

    public Writer getOut() {
        if (!this.destinationActivated) {
            try {
                super.setOut(this.factory.activateDestination());
            }
            catch (IOException e) {
                this.setError();
            }
            this.destinationActivated = true;
        }
        return super.getOut();
    }

    public boolean isAllowUnwrappingOut() {
        return this.destinationActivated ? super.isAllowUnwrappingOut() : false;
    }

    public Writer unwrap() {
        return this.destinationActivated ? super.unwrap() : this;
    }

    public void updateDestination(DestinationFactory f) {
        this.setDestinationActivated(false);
        this.factory = f;
    }

    public boolean isDestinationActivated() {
        return this.destinationActivated;
    }

    public void setDestinationActivated(boolean destinationActivated) {
        this.destinationActivated = destinationActivated;
        if (!this.destinationActivated) {
            super.setOut(null);
        }
    }

    public static interface DestinationFactory {
        public Writer activateDestination() throws IOException;
    }
}

