/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.CollectionUtils;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.Script;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsCodecClass;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.web.errors.GrailsExceptionResolver;
import org.codehaus.groovy.grails.web.pages.AbstractGroovyPageBinding;
import org.codehaus.groovy.grails.web.pages.GroovyPageMetaInfo;
import org.codehaus.groovy.grails.web.pages.GroovyPageOutputStack;
import org.codehaus.groovy.grails.web.pages.GroovyPageOutputStackAttributes;
import org.codehaus.groovy.grails.web.pages.TagLibraryLookup;
import org.codehaus.groovy.grails.web.pages.exceptions.GroovyPagesException;
import org.codehaus.groovy.grails.web.pages.ext.jsp.JspTag;
import org.codehaus.groovy.grails.web.pages.ext.jsp.JspTagLib;
import org.codehaus.groovy.grails.web.pages.ext.jsp.TagLibraryResolver;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.sitemesh.GSPSitemeshPage;
import org.codehaus.groovy.grails.web.sitemesh.GrailsPageFilter;
import org.codehaus.groovy.grails.web.taglib.GroovyPageAttributes;
import org.codehaus.groovy.grails.web.taglib.GroovyPageTagBody;
import org.codehaus.groovy.grails.web.taglib.GroovyPageTagWriter;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriter;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;
import org.codehaus.groovy.grails.web.util.WithCodecHelper;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroovyPage
extends Script {
    private static final String APPLY_CODEC_TAG_NAME = "applyCodec";
    public static final String ENCODE_AS_ATTRIBUTE_NAME = "encodeAs";
    private static final Log LOG = LogFactory.getLog(GroovyPage.class);
    public static final String REQUEST = "request";
    public static final String SERVLET_CONTEXT = "application";
    public static final String RESPONSE = "response";
    public static final String OUT = "out";
    public static final String EXPRESSION_OUT = "expressionOut";
    public static final String EXPRESSION_OUT_STATEMENT = "expressionOut";
    public static final String OUT_STATEMENT = "out";
    public static final String CODEC_VARNAME = "Codec";
    public static final String ATTRIBUTES = "attributes";
    public static final String APPLICATION_CONTEXT = "applicationContext";
    public static final String SESSION = "session";
    public static final String PARAMS = "params";
    public static final String FLASH = "flash";
    public static final String PLUGIN_CONTEXT_PATH = "pluginContextPath";
    public static final String EXTENSION = ".gsp";
    public static final String WEB_REQUEST = "webRequest";
    public static final String DEFAULT_NAMESPACE = "g";
    public static final String LINK_NAMESPACE = "link";
    public static final String TEMPLATE_NAMESPACE = "tmpl";
    public static final String PAGE_SCOPE = "pageScope";
    public static final String CONTROLLER_NAME = "controllerName";
    public static final String SUFFIX = ".gsp";
    public static final String ACTION_NAME = "actionName";
    public static final Collection<String> RESERVED_NAMES = CollectionUtils.newSet((Object[])new String[]{"request", "application", "response", "out", "expressionOut", "Codec", "attributes", "applicationContext", "session", "params", "flash", "pluginContextPath", "pageScope"});
    private static final String BINDING = "binding";
    private static final String BLANK_STRING = "";
    private Map jspTags = Collections.EMPTY_MAP;
    private TagLibraryResolver jspTagLibraryResolver;
    private TagLibraryLookup gspTagLibraryLookup;
    private String[] htmlParts;
    private Set<Integer> htmlPartsSet;
    private GrailsPrintWriter out;
    private GrailsPrintWriter staticOut;
    private GrailsPrintWriter expressionOut;
    private GroovyPageOutputStack outputStack;
    private GrailsWebRequest webRequest;
    private String pluginContextPath;
    private HttpServletRequest request;
    private Encoder rawEncoder;
    private final List<Closure<?>> bodyClosures = new ArrayList(15);
    protected static final Closure<?> EMPTY_BODY_CLOSURE = new ConstantClosure("");

    public GroovyPage() {
        this.init();
    }

    protected void init() {
    }

    public final Writer getOut() {
        return this.out;
    }

    public final Writer getExpressionOut() {
        return this.expressionOut;
    }

    public void setOut(Writer newWriter) {
        throw new IllegalStateException("Setting out in page isn't allowed.");
    }

    public void initRun(Writer target, GrailsWebRequest grailsWebRequest, GroovyPageMetaInfo metaInfo) {
        GroovyPageOutputStackAttributes.Builder attributesBuilder = new GroovyPageOutputStackAttributes.Builder();
        if (metaInfo != null) {
            this.setJspTags(metaInfo.getJspTags());
            this.setJspTagLibraryResolver(metaInfo.getJspTagLibraryResolver());
            this.setGspTagLibraryLookup(metaInfo.getTagLibraryLookup());
            this.setHtmlParts(metaInfo.getHtmlParts());
            this.setPluginContextPath(metaInfo.getPluginPath());
            attributesBuilder.outEncoder(metaInfo.getOutEncoder());
            attributesBuilder.staticEncoder(metaInfo.getStaticEncoder());
            attributesBuilder.expressionEncoder(metaInfo.getExpressionEncoder());
            attributesBuilder.defaultTaglibEncoder(metaInfo.getTaglibEncoder());
        }
        attributesBuilder.allowCreate(true).topWriter(target).autoSync(false).pushTop(true);
        attributesBuilder.webRequest(grailsWebRequest);
        attributesBuilder.inheritPreviousEncoders(false);
        this.outputStack = GroovyPageOutputStack.currentStack(attributesBuilder.build());
        this.out = this.outputStack.getOutWriter();
        this.staticOut = this.outputStack.getStaticWriter();
        this.expressionOut = this.outputStack.getExpressionWriter();
        this.webRequest = grailsWebRequest;
        if (grailsWebRequest != null) {
            GrailsCodecClass codecClass;
            grailsWebRequest.setOut(this.out);
            this.request = grailsWebRequest.getCurrentRequest();
            GrailsApplication grailsApplication = grailsWebRequest.getAttributes().getGrailsApplication();
            if (grailsApplication != null && (codecClass = (GrailsCodecClass)grailsApplication.getArtefact(CODEC_VARNAME, "org.codehaus.groovy.grails.plugins.codecs.RawCodec")) != null) {
                this.rawEncoder = codecClass.getEncoder();
            }
        }
        this.setVariableDirectly("out", this.out);
        this.setVariableDirectly("expressionOut", this.expressionOut);
    }

    public Object raw(Object value) {
        if (this.rawEncoder != null) {
            return this.rawEncoder.encode(value);
        }
        return InvokerHelper.invokeMethod((Object)value, (String)"encodeAsRaw", null);
    }

    private void setVariableDirectly(String name, Object value) {
        Binding binding = this.getBinding();
        if (binding instanceof AbstractGroovyPageBinding) {
            ((AbstractGroovyPageBinding)binding).setVariableDirectly(name, value);
        } else {
            binding.getVariables().put(name, value);
        }
    }

    public String getPluginContextPath() {
        return this.pluginContextPath != null ? this.pluginContextPath : BLANK_STRING;
    }

    public void setPluginContextPath(String pluginContextPath) {
        this.pluginContextPath = pluginContextPath;
    }

    public void cleanup() {
        this.outputStack.pop(true);
    }

    public final void createClosureForHtmlPart(int partNumber, int bodyClosureIndex) {
        String htmlPart = this.htmlParts[partNumber];
        this.setBodyClosure(bodyClosureIndex, new ConstantClosure(htmlPart));
    }

    public final void setBodyClosure(int index, Closure<?> bodyClosure) {
        while (index >= this.bodyClosures.size()) {
            this.bodyClosures.add(null);
        }
        this.bodyClosures.set(index, bodyClosure);
    }

    public final Closure<?> getBodyClosure(int index) {
        if (index >= 0) {
            return this.bodyClosures.get(index);
        }
        return null;
    }

    public void setJspTagLibraryResolver(TagLibraryResolver jspTagLibraryResolver) {
        this.jspTagLibraryResolver = jspTagLibraryResolver;
    }

    public void setGspTagLibraryLookup(TagLibraryLookup gspTagLibraryLookup) {
        this.gspTagLibraryLookup = gspTagLibraryLookup;
    }

    TagLibraryResolver getTagLibraryResolver() {
        return this.jspTagLibraryResolver;
    }

    public Object evaluate(String exprText, int lineNumber, Object outerIt, Closure<?> evaluator) {
        try {
            return evaluator.call(outerIt);
        }
        catch (Exception e) {
            throw new GroovyPagesException("Error evaluating expression [" + exprText + "] on line [" + lineNumber + "]: " + e.getMessage(), e, lineNumber, this.getGroovyPageFileName());
        }
    }

    public abstract String getGroovyPageFileName();

    public Object getProperty(String property) {
        if ("out".equals(property)) {
            return this.out;
        }
        if ("expressionOut".equals(property)) {
            return this.expressionOut;
        }
        if (BINDING.equals(property)) {
            return this.getBinding();
        }
        Object value = this.getBinding().getVariable(property);
        if (value != null) {
            return value;
        }
        if (value == null) {
            Object object = value = this.gspTagLibraryLookup != null ? this.gspTagLibraryLookup.lookupNamespaceDispatcher(property) : null;
            if (value == null && this.jspTags.containsKey(property)) {
                TagLibraryResolver tagResolver = this.getTagLibraryResolver();
                String uri = (String)this.jspTags.get(property);
                if (uri != null) {
                    value = tagResolver.resolveTagLibrary(uri);
                }
            }
            if (value != null) {
                this.setVariableDirectly(property, value);
            }
        }
        return value;
    }

    public JspTag getJspTag(String uri, String name) {
        if (this.jspTagLibraryResolver == null) {
            return null;
        }
        JspTagLib tagLib = this.jspTagLibraryResolver.resolveTagLibrary(uri);
        return tagLib != null ? tagLib.getTag(name) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void invokeTag(String tagName, String tagNamespace, int lineNumber, Map attrs, int bodyClosureIndex) {
        Closure<?> body = this.getBodyClosure(bodyClosureIndex);
        if (tagNamespace.equals(TEMPLATE_NAMESPACE) || tagNamespace.equals(LINK_NAMESPACE)) {
            String tmpTagName = tagName;
            Map tmpAttrs = attrs;
            Object encodeAs = tmpAttrs.remove(ENCODE_AS_ATTRIBUTE_NAME);
            if (tagNamespace.equals(TEMPLATE_NAMESPACE)) {
                tagName = "render";
                attrs = CollectionUtils.newMap((Object[])new Object[]{"model", tmpAttrs, "template", tmpTagName});
            } else if (tagNamespace.equals(LINK_NAMESPACE)) {
                tagName = LINK_NAMESPACE;
                attrs = CollectionUtils.newMap((Object[])new Object[]{"mapping", tmpTagName});
                if (!tmpAttrs.isEmpty()) {
                    attrs.put(PARAMS, tmpAttrs);
                }
            }
            if (encodeAs != null) {
                attrs.put(ENCODE_AS_ATTRIBUTE_NAME, encodeAs);
            }
            tagNamespace = DEFAULT_NAMESPACE;
        }
        try {
            GroovyObject tagLib = this.getTagLib(tagNamespace, tagName);
            if (tagLib != null || this.gspTagLibraryLookup != null && this.gspTagLibraryLookup.hasNamespace(tagNamespace)) {
                if (tagLib == null) throw new GrailsTagException("Tag [" + tagName + "] does not exist. No tag library found for namespace: " + tagNamespace, this.getGroovyPageFileName(), lineNumber);
                boolean returnsObject = this.gspTagLibraryLookup.doesTagReturnObject(tagNamespace, tagName);
                Object tagLibClosure = tagLib.getProperty(tagName);
                if (!(tagLibClosure instanceof Closure)) throw new GrailsTagException("Tag [" + tagName + "] does not exist in tag library [" + tagLib.getClass().getName() + "]", this.getGroovyPageFileName(), lineNumber);
                Map<String, Object> encodeAsForTag = this.gspTagLibraryLookup.getEncodeAsForTag(tagNamespace, tagName);
                this.invokeTagLibClosure(tagName, tagNamespace, (Closure)tagLibClosure, attrs, body, returnsObject, encodeAsForTag);
                return;
            } else {
                Object bodyOutput;
                this.staticOut.append('<').append(tagNamespace).append(':').append(tagName);
                Iterator i$ = attrs.entrySet().iterator();
                while (i$.hasNext()) {
                    boolean containsSingleQuote;
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    this.staticOut.append(' ');
                    this.staticOut.append(entry.getKey()).append('=');
                    String value = String.valueOf(entry.getValue());
                    boolean containsQuotes = value.indexOf(34) > -1;
                    boolean bl = containsSingleQuote = value.indexOf(39) > -1;
                    if (containsQuotes && !containsSingleQuote) {
                        this.staticOut.append('\'').append(value).append('\'');
                        continue;
                    }
                    if (containsQuotes & containsSingleQuote) {
                        this.staticOut.append('\"').append(value.replaceAll("\"", "&quot;")).append('\"');
                        continue;
                    }
                    this.staticOut.append('\"').append(value).append('\"');
                }
                this.staticOut.append('>');
                if (body != null && (bodyOutput = body.call()) != null) {
                    this.staticOut.print(bodyOutput);
                }
                this.staticOut.append("</").append(tagNamespace).append(':').append(tagName).append('>');
            }
            return;
        }
        catch (Throwable e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Full exception for problem at " + this.getGroovyPageFileName() + ":" + lineNumber), e);
            }
            if (tagName.matches("capture(Body|Head|Meta|Title|Component)")) {
                RuntimeException rte = GrailsExceptionResolver.getFirstRuntimeException(e);
                if (rte != null) throw rte;
                this.throwRootCause(tagName, tagNamespace, lineNumber, e);
                return;
            }
            this.throwRootCause(tagName, tagNamespace, lineNumber, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invokeTagLibClosure(String tagName, String tagNamespace, Closure tagLibClosure, Map attrs, Closure body, boolean returnsObject, Map<String, Object> defaultEncodeAs) {
        Closure tag = (Closure)tagLibClosure.clone();
        if (!(attrs instanceof GroovyPageAttributes)) {
            attrs = new GroovyPageAttributes(attrs);
        }
        ((GroovyPageAttributes)attrs).setGspTagSyntaxCall(true);
        boolean encodeAsPushedToStack = false;
        try {
            Map<String, Object> codecSettings = GroovyPage.createCodecSettings(tagNamespace, tagName, attrs, defaultEncodeAs);
            if (codecSettings != null) {
                this.outputStack.push(WithCodecHelper.createOutputStackAttributesBuilder(codecSettings, this.webRequest.getAttributes().getGrailsApplication()).build());
                encodeAsPushedToStack = true;
            }
            Object tagresult = null;
            switch (tag.getParameterTypes().length) {
                case 1: {
                    tagresult = tag.call(new Object[]{attrs});
                    this.outputTagResult(returnsObject, tagresult);
                    if (body == null) return;
                    if (body == EMPTY_BODY_CLOSURE) return;
                    body.call();
                    return;
                }
                case 2: {
                    tagresult = tag.call(new Object[]{attrs, body != null ? body : EMPTY_BODY_CLOSURE});
                    this.outputTagResult(returnsObject, tagresult);
                    return;
                }
            }
            return;
        }
        finally {
            if (encodeAsPushedToStack) {
                this.outputStack.pop();
            }
        }
    }

    private void outputTagResult(boolean returnsObject, Object tagresult) {
        if (returnsObject && tagresult != null && !(tagresult instanceof Writer)) {
            if (tagresult instanceof String && this.isHtmlPart((String)tagresult)) {
                this.staticOut.print(tagresult);
            } else {
                this.outputStack.getTaglibWriter().print(tagresult);
            }
        }
    }

    private void throwRootCause(String tagName, String tagNamespace, int lineNumber, Throwable e) {
        Throwable cause = GrailsExceptionResolver.getRootCause(e);
        if (cause instanceof GrailsTagException) {
            throw new GrailsTagException(cause.getMessage(), this.getGroovyPageFileName(), lineNumber);
        }
        throw new GrailsTagException("Error executing tag <" + tagNamespace + ":" + tagName + ">: " + e.getMessage(), e, this.getGroovyPageFileName(), lineNumber);
    }

    private GroovyObject getTagLib(String namespace, String tagName) {
        return GroovyPage.lookupCachedTagLib(this.gspTagLibraryLookup, namespace, tagName);
    }

    public static final Object captureTagOutput(TagLibraryLookup gspTagLibraryLookup, String namespace, String tagName, Map attrs, Object body, GrailsWebRequest webRequest) {
        GroovyObject tagLib = GroovyPage.lookupCachedTagLib(gspTagLibraryLookup, namespace, tagName);
        if (tagLib == null) {
            throw new GrailsTagException("Tag [" + tagName + "] does not exist. No corresponding tag library found.");
        }
        if (!(attrs instanceof GroovyPageAttributes)) {
            attrs = new GroovyPageAttributes(attrs, false);
        }
        ((GroovyPageAttributes)attrs).setGspTagSyntaxCall(false);
        Closure<?> actualBody = GroovyPage.createOutputCapturingClosure(tagLib, body, webRequest);
        GroovyPageTagWriter tagOutput = new GroovyPageTagWriter();
        GroovyPageOutputStack outputStack = null;
        try {
            outputStack = GroovyPageOutputStack.currentStack(webRequest, false);
            if (outputStack == null) {
                outputStack = GroovyPageOutputStack.currentStack(webRequest, true, tagOutput, true, true);
            }
            Map<String, Object> defaultEncodeAs = gspTagLibraryLookup.getEncodeAsForTag(namespace, tagName);
            Map<String, Object> codecSettings = GroovyPage.createCodecSettings(namespace, tagName, attrs, defaultEncodeAs);
            GroovyPageOutputStackAttributes.Builder builder = WithCodecHelper.createOutputStackAttributesBuilder(codecSettings, webRequest.getAttributes().getGrailsApplication());
            builder.topWriter(tagOutput);
            outputStack.push(builder.build());
            Object tagLibProp = tagLib.getProperty(tagName);
            if (tagLibProp instanceof Closure) {
                Object bodyResult;
                Closure tag = (Closure)((Closure)tagLibProp).clone();
                switch (tag.getParameterTypes().length) {
                    case 1: {
                        Object bodyResult2;
                        bodyResult = tag.call(new Object[]{attrs});
                        if (actualBody == null || actualBody == EMPTY_BODY_CLOSURE || (bodyResult2 = actualBody.call()) == null) break;
                        if (actualBody instanceof ConstantClosure) {
                            outputStack.getStaticWriter().print(bodyResult2);
                            break;
                        }
                        outputStack.getTaglibWriter().print(bodyResult2);
                        break;
                    }
                    case 2: {
                        bodyResult = tag.call(new Object[]{attrs, actualBody});
                        break;
                    }
                    default: {
                        throw new GrailsTagException("Tag [" + tagName + "] does not specify expected number of params in tag library [" + tagLib.getClass().getName() + "]");
                    }
                }
                Encoder taglibEncoder = outputStack.getTaglibEncoder();
                boolean returnsObject = gspTagLibraryLookup.doesTagReturnObject(namespace, tagName);
                if (returnsObject && bodyResult != null && !(bodyResult instanceof Writer)) {
                    if (taglibEncoder != null) {
                        bodyResult = taglibEncoder.encode(bodyResult);
                    }
                    Object object = bodyResult;
                    return object;
                }
                if (taglibEncoder != null) {
                    Object object = taglibEncoder.encode((Object)tagOutput.getBuffer());
                    return object;
                }
                StreamCharBuffer streamCharBuffer = tagOutput.getBuffer();
                return streamCharBuffer;
            }
            throw new GrailsTagException("Tag [" + tagName + "] does not exist in tag library [" + tagLib.getClass().getName() + "]");
        }
        finally {
            if (outputStack != null) {
                outputStack.pop();
            }
        }
    }

    private static Map<String, Object> createCodecSettings(String namespace, String tagName, Map attrs, Map<String, Object> defaultEncodeAs) {
        Map codecInfo = null;
        if (attrs.containsKey(ENCODE_AS_ATTRIBUTE_NAME)) {
            codecInfo = (Map)attrs.get(ENCODE_AS_ATTRIBUTE_NAME);
        } else if (DEFAULT_NAMESPACE.equals(namespace) && APPLY_CODEC_TAG_NAME.equals(tagName)) {
            codecInfo = attrs;
        }
        Map<String, Object> codecSettings = WithCodecHelper.mergeSettingsAndMakeCanonical(codecInfo, defaultEncodeAs);
        return codecSettings;
    }

    private static final GroovyObject lookupCachedTagLib(TagLibraryLookup gspTagLibraryLookup, String namespace, String tagName) {
        return gspTagLibraryLookup != null ? gspTagLibraryLookup.lookupTagLibrary(namespace, tagName) : null;
    }

    public static final Closure<?> createOutputCapturingClosure(Object wrappedInstance, Object body1, GrailsWebRequest webRequest) {
        if (body1 == null) {
            return EMPTY_BODY_CLOSURE;
        }
        if (body1 instanceof ConstantClosure || body1 instanceof GroovyPageTagBody) {
            return (Closure)body1;
        }
        if (body1 instanceof Closure) {
            return new GroovyPageTagBody(wrappedInstance, webRequest, (Closure)body1);
        }
        return new ConstantClosure(body1);
    }

    public static final boolean isReservedName(String name) {
        return RESERVED_NAMES.contains(name);
    }

    public final void printHtmlPart(int partNumber) {
        this.staticOut.write(this.htmlParts[partNumber]);
    }

    public void setJspTags(Map jspTags) {
        this.jspTags = jspTags;
    }

    public String[] getHtmlParts() {
        return this.htmlParts;
    }

    protected boolean isHtmlPart(String htmlPart) {
        return this.htmlPartsSet != null && htmlPart != null && this.htmlPartsSet.contains(System.identityHashCode(htmlPart));
    }

    public void setHtmlParts(String[] htmlParts) {
        this.htmlParts = htmlParts;
        this.htmlPartsSet = new HashSet<Integer>();
        if (htmlParts != null) {
            for (String htmlPart : htmlParts) {
                if (htmlPart == null) continue;
                this.htmlPartsSet.add(System.identityHashCode(htmlPart));
            }
        }
    }

    public final GroovyPageOutputStack getOutputStack() {
        return this.outputStack;
    }

    public final HttpServletRequest getRequest() {
        return this.request;
    }

    public final void registerSitemeshPreprocessMode() {
        if (this.request == null) {
            return;
        }
        GSPSitemeshPage page = (GSPSitemeshPage)((Object)this.request.getAttribute(GrailsPageFilter.GSP_SITEMESH_PAGE));
        if (page != null) {
            page.setUsed(true);
        }
    }

    public final void createTagBody(int bodyClosureIndex, Closure<?> bodyClosure) {
        GroovyPageTagBody tagBody = new GroovyPageTagBody((Object)this, this.webRequest, bodyClosure, true);
        this.setBodyClosure(bodyClosureIndex, tagBody);
    }

    public void changeItVariable(Object value) {
        this.setVariableDirectly("it", value);
    }

    public static final class ConstantClosure
    extends Closure {
        private static final long serialVersionUID = 1L;
        private static final Class[] EMPTY_CLASS_ARR = new Class[0];
        final Object retval;

        public ConstantClosure(Object retval) {
            super(null);
            this.retval = retval;
        }

        public int getMaximumNumberOfParameters() {
            return 0;
        }

        public Class[] getParameterTypes() {
            return EMPTY_CLASS_ARR;
        }

        public Object doCall(Object obj) {
            return this.retval;
        }

        public Object doCall() {
            return this.retval;
        }

        public Object doCall(Object[] args) {
            return this.retval;
        }

        public Object call(Object ... args) {
            return this.retval;
        }

        public boolean asBoolean() {
            return DefaultTypeTransformation.castToBoolean((Object)this.retval);
        }
    }
}

