/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import grails.util.GrailsWebUtil;
import grails.web.UrlConverter;
import groovy.lang.Binding;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.codehaus.groovy.grails.web.mime.MimeType;
import org.codehaus.groovy.grails.web.servlet.WrappedResponseHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.codehaus.groovy.grails.web.util.IncludeResponseWrapper;
import org.codehaus.groovy.grails.web.util.IncludedContent;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;
import org.springframework.web.util.UrlPathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebUtils
extends org.springframework.web.util.WebUtils {
    public static final char SLASH = '/';
    public static final String ENABLE_FILE_EXTENSIONS = "grails.mime.file.extensions";
    public static final String DISPATCH_ACTION_PARAMETER = "_action_";
    private static final String DISPATCH_URI_SUFFIX = ".dispatch";
    private static final String GRAILS_DISPATCH_SERVLET_NAME = "/grails";

    public static ViewResolver lookupViewResolver(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return WebUtils.lookupViewResolver((ApplicationContext)wac);
    }

    public static ViewResolver lookupViewResolver(ApplicationContext wac) {
        if (wac.containsBean("jspViewResolver")) {
            return (ViewResolver)wac.getBean("jspViewResolver", ViewResolver.class);
        }
        String[] beanNames = wac.getBeanNamesForType(ViewResolver.class);
        if (beanNames.length > 0) {
            String beanName = beanNames[0];
            return (ViewResolver)wac.getBean(beanName, ViewResolver.class);
        }
        return null;
    }

    public static HandlerInterceptor[] lookupHandlerInterceptors(ServletContext servletContext) {
        WebRequestInterceptor[] webRequestInterceptors;
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        ArrayList<Object> allHandlerInterceptors = new ArrayList<Object>();
        for (WebRequestInterceptor webRequestInterceptor : webRequestInterceptors = WebUtils.lookupWebRequestInterceptors(servletContext)) {
            allHandlerInterceptors.add(new WebRequestHandlerInterceptorAdapter(webRequestInterceptor));
        }
        Collection handlerInterceptors = wac.getBeansOfType(HandlerInterceptor.class).values();
        allHandlerInterceptors.addAll(handlerInterceptors);
        return allHandlerInterceptors.toArray(new HandlerInterceptor[allHandlerInterceptors.size()]);
    }

    public static WebRequestInterceptor[] lookupWebRequestInterceptors(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        Collection webRequestInterceptors = wac.getBeansOfType(WebRequestInterceptor.class).values();
        return webRequestInterceptors.toArray(new WebRequestInterceptor[webRequestInterceptors.size()]);
    }

    public static UrlMappingsHolder lookupUrlMappings(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return (UrlMappingsHolder)wac.getBean("grailsUrlMappingsHolder");
    }

    public static String getRequestURIForGrailsDispatchURI(HttpServletRequest request) {
        UrlPathHelper pathHelper = new UrlPathHelper();
        if (request.getRequestURI().endsWith(DISPATCH_URI_SUFFIX)) {
            String path = pathHelper.getPathWithinApplication(request);
            if (path.startsWith(GRAILS_DISPATCH_SERVLET_NAME)) {
                path = path.substring(GRAILS_DISPATCH_SERVLET_NAME.length(), path.length());
            }
            return path.substring(0, path.length() - DISPATCH_URI_SUFFIX.length());
        }
        return pathHelper.getPathWithinApplication(request);
    }

    public static GrailsApplication lookupApplication(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return (GrailsApplication)wac.getBean("grailsApplication");
    }

    public static View resolveView(HttpServletRequest request, UrlMappingInfo info, String viewName, ViewResolver viewResolver) throws Exception {
        String controllerName = info.getControllerName();
        return WebUtils.resolveView(request, viewName, controllerName, viewResolver);
    }

    public static View resolveView(HttpServletRequest request, String viewName, String controllerName, ViewResolver viewResolver) throws Exception {
        View v;
        GrailsWebRequest webRequest = GrailsWebRequest.lookup(request);
        if (viewName.startsWith(String.valueOf('/'))) {
            v = viewResolver.resolveViewName(viewName, webRequest.getLocale());
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append('/');
            if (controllerName != null) {
                buf.append(controllerName).append('/');
            }
            buf.append(viewName);
            v = viewResolver.resolveViewName(buf.toString(), webRequest.getLocale());
        }
        return v;
    }

    public static String buildDispatchUrlForMapping(UrlMappingInfo info) {
        return WebUtils.buildDispatchUrlForMapping(info, false);
    }

    private static String buildDispatchUrlForMapping(UrlMappingInfo info, boolean includeParams) {
        if (info.getURI() != null) {
            return info.getURI();
        }
        StringBuilder forwardUrl = new StringBuilder();
        if (info.getViewName() != null) {
            String viewName = info.getViewName();
            if (viewName.startsWith("/")) {
                forwardUrl.append(viewName);
            } else {
                forwardUrl.append('/').append(viewName);
            }
        } else {
            forwardUrl.append(GRAILS_DISPATCH_SERVLET_NAME);
            forwardUrl.append('/').append(info.getControllerName());
            if (!StringUtils.isBlank((String)info.getActionName())) {
                forwardUrl.append('/').append(info.getActionName());
            }
            forwardUrl.append(DISPATCH_URI_SUFFIX);
        }
        Map parameters = info.getParameters();
        if (parameters != null && !parameters.isEmpty() && includeParams) {
            try {
                forwardUrl.append(WebUtils.toQueryString(parameters));
            }
            catch (UnsupportedEncodingException e) {
                throw new ControllerExecutionException("Unable to include ");
            }
        }
        return forwardUrl.toString();
    }

    public static String forwardRequestForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info) throws ServletException, IOException {
        return WebUtils.forwardRequestForUrlMappingInfo(request, response, info, Collections.EMPTY_MAP);
    }

    public static String forwardRequestForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, Map model) throws ServletException, IOException {
        return WebUtils.forwardRequestForUrlMappingInfo(request, response, info, model, false);
    }

    public static String forwardRequestForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, Map model, boolean includeParams) throws ServletException, IOException {
        WebUtils.exposeForwardRequestAttributes((HttpServletRequest)request);
        WebUtils.exposeRequestAttributes((ServletRequest)request, (Map)model);
        String forwardUrl = WebUtils.buildDispatchUrlForMapping(info, includeParams);
        RequestDispatcher dispatcher = request.getRequestDispatcher(forwardUrl);
        GrailsWebRequest webRequest = GrailsWebRequest.lookup(request);
        webRequest.removeAttribute("org.codehaus.groovy.grails.MODEL_AND_VIEW", 0);
        webRequest.setActionName(info.getActionName());
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        return forwardUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncludedContent includeForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, Map model) {
        IncludedContent includedContent;
        block12: {
            String includeUrl = WebUtils.buildDispatchUrlForMapping(info, true);
            GrailsWebRequest webRequest = GrailsWebRequest.lookup(request);
            String currentController = null;
            String currentAction = null;
            String currentId = null;
            ModelAndView currentMv = null;
            Binding currentPageBinding = null;
            HashMap currentParams = null;
            Object currentLayoutAttribute = null;
            Object currentRenderingView = null;
            if (webRequest != null) {
                currentPageBinding = (Binding)webRequest.getAttribute("org.codehaus.groovy.grails.PAGE_SCOPE", 0);
                webRequest.removeAttribute("org.codehaus.groovy.grails.PAGE_SCOPE", 0);
                currentLayoutAttribute = webRequest.getAttribute("org.grails.layout.name", 0);
                if (currentLayoutAttribute != null) {
                    webRequest.removeAttribute("org.grails.layout.name", 0);
                }
                if ((currentRenderingView = webRequest.getAttribute("org.grails.rendering.view", 0)) != null) {
                    webRequest.removeAttribute("org.grails.rendering.view", 0);
                }
                currentController = webRequest.getControllerName();
                currentAction = webRequest.getActionName();
                currentId = webRequest.getId();
                currentParams = new HashMap();
                currentParams.putAll(webRequest.getParameterMap());
                currentMv = (ModelAndView)webRequest.getAttribute("org.codehaus.groovy.grails.MODEL_AND_VIEW", 0);
            }
            try {
                if (webRequest != null) {
                    webRequest.getParameterMap().clear();
                    info.configure(webRequest);
                    webRequest.getParameterMap().putAll(info.getParameters());
                    webRequest.removeAttribute("org.codehaus.groovy.grails.MODEL_AND_VIEW", 0);
                }
                includedContent = WebUtils.includeForUrl(includeUrl, request, response, model);
                Object var16_15 = null;
                if (webRequest == null) break block12;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var16_16 = null;
                    if (webRequest == null) break block13;
                    webRequest.setAttribute("org.codehaus.groovy.grails.PAGE_SCOPE", currentPageBinding, 0);
                    if (currentLayoutAttribute != null) {
                        webRequest.setAttribute("org.grails.layout.name", currentLayoutAttribute, 0);
                    }
                    if (currentRenderingView != null) {
                        webRequest.setAttribute("org.grails.rendering.view", currentRenderingView, 0);
                    }
                    webRequest.getParameterMap().clear();
                    webRequest.getParameterMap().putAll(currentParams);
                    webRequest.setId(currentId);
                    webRequest.setControllerName(currentController);
                    webRequest.setActionName(currentAction);
                    if (currentMv != null) {
                        webRequest.setAttribute("org.codehaus.groovy.grails.MODEL_AND_VIEW", currentMv, 0);
                    }
                }
                throw throwable;
            }
            webRequest.setAttribute("org.codehaus.groovy.grails.PAGE_SCOPE", currentPageBinding, 0);
            if (currentLayoutAttribute != null) {
                webRequest.setAttribute("org.grails.layout.name", currentLayoutAttribute, 0);
            }
            if (currentRenderingView != null) {
                webRequest.setAttribute("org.grails.rendering.view", currentRenderingView, 0);
            }
            webRequest.getParameterMap().clear();
            webRequest.getParameterMap().putAll(currentParams);
            webRequest.setId(currentId);
            webRequest.setControllerName(currentController);
            webRequest.setActionName(currentAction);
            if (currentMv != null) {
                webRequest.setAttribute("org.codehaus.groovy.grails.MODEL_AND_VIEW", currentMv, 0);
            }
        }
        return includedContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IncludedContent includeForUrl(String includeUrl, HttpServletRequest request, HttpServletResponse response, Map model) {
        RequestDispatcher dispatcher = request.getRequestDispatcher(includeUrl);
        HttpServletResponse wrapped = WrappedResponseHolder.getWrappedResponse();
        response = wrapped != null ? wrapped : response;
        WebUtils.exposeIncludeRequestAttributes(request);
        Map<String, Object> toRestore = WebUtils.exposeRequestAttributesAndReturnOldValues(request, model);
        try {
            try {
                IncludeResponseWrapper responseWrapper;
                block7: {
                    IncludedContent includedContent;
                    responseWrapper = new IncludeResponseWrapper(response);
                    try {
                        WrappedResponseHolder.setWrappedResponse((HttpServletResponse)responseWrapper);
                        dispatcher.include((ServletRequest)request, (ServletResponse)responseWrapper);
                        if (responseWrapper.getRedirectURL() == null) break block7;
                        includedContent = new IncludedContent(responseWrapper.getRedirectURL());
                        Object var10_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        WrappedResponseHolder.setWrappedResponse(wrapped);
                        throw throwable;
                    }
                    WrappedResponseHolder.setWrappedResponse(wrapped);
                    Object var12_14 = null;
                    WebUtils.cleanupIncludeRequestAttributes(request, toRestore);
                    return includedContent;
                }
                IncludedContent includedContent = new IncludedContent(responseWrapper.getContentType(), responseWrapper.getContent());
                Object var10_12 = null;
                WrappedResponseHolder.setWrappedResponse(wrapped);
                Object var12_15 = null;
                WebUtils.cleanupIncludeRequestAttributes(request, toRestore);
                return includedContent;
            }
            catch (Exception e) {
                throw new ControllerExecutionException("Unable to execute include: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            WebUtils.cleanupIncludeRequestAttributes(request, toRestore);
            throw throwable;
        }
    }

    private static Map<String, Object> exposeRequestAttributesAndReturnOldValues(HttpServletRequest request, Map<String, ?> attributes) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Assert.notNull(attributes, (String)"Attributes Map must not be null");
        HashMap<String, Object> originalValues = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : attributes.entrySet()) {
            String name = entry.getKey();
            Object current = request.getAttribute(name);
            request.setAttribute(name, entry.getValue());
            if (current == null) continue;
            originalValues.put(name, current);
        }
        return originalValues;
    }

    private static void cleanupIncludeRequestAttributes(HttpServletRequest request, Map<String, Object> toRestore) {
        request.removeAttribute("javax.servlet.include.request_uri");
        request.removeAttribute("javax.servlet.include.context_path");
        request.removeAttribute("javax.servlet.include.servlet_path");
        request.removeAttribute("javax.servlet.include.path_info");
        request.removeAttribute("javax.servlet.include.query_string");
        for (Map.Entry<String, Object> entry : toRestore.entrySet()) {
            request.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public static void exposeIncludeRequestAttributes(HttpServletRequest request) {
        WebUtils.exposeRequestAttributeIfNotPresent((ServletRequest)request, "javax.servlet.include.request_uri", request.getRequestURI());
        WebUtils.exposeRequestAttributeIfNotPresent((ServletRequest)request, "javax.servlet.include.context_path", request.getContextPath());
        WebUtils.exposeRequestAttributeIfNotPresent((ServletRequest)request, "javax.servlet.include.servlet_path", request.getServletPath());
        WebUtils.exposeRequestAttributeIfNotPresent((ServletRequest)request, "javax.servlet.include.path_info", request.getPathInfo());
        WebUtils.exposeRequestAttributeIfNotPresent((ServletRequest)request, "javax.servlet.include.query_string", request.getQueryString());
    }

    private static void exposeRequestAttributeIfNotPresent(ServletRequest request, String name, Object value) {
        if (request.getAttribute(name) == null) {
            request.setAttribute(name, value);
        }
    }

    public static Map<String, Object> fromQueryString(String queryString) {
        String[] pairs;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (queryString.startsWith("?")) {
            queryString = queryString.substring(1);
        }
        for (String pair : pairs = queryString.split("&")) {
            int i = pair.indexOf(61);
            if (i <= -1) continue;
            try {
                String name = URLDecoder.decode(pair.substring(0, i), "UTF-8");
                String value = URLDecoder.decode(pair.substring(i + 1, pair.length()), "UTF-8");
                Object current = result.get(name);
                if (current instanceof List) {
                    ((List)current).add(value);
                    continue;
                }
                if (current != null) {
                    ArrayList<Object> multi = new ArrayList<Object>();
                    multi.add(current);
                    multi.add(value);
                    result.put(name, multi);
                    continue;
                }
                result.put(name, value);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return result;
    }

    public static String toQueryString(Map params, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        StringBuilder queryString = new StringBuilder("?");
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            boolean hasMore = i.hasNext();
            boolean wasAppended = WebUtils.appendEntry(entry, queryString, encoding, "");
            if (!hasMore || !wasAppended) continue;
            queryString.append('&');
        }
        return queryString.toString();
    }

    public static String toQueryString(Map parameters) throws UnsupportedEncodingException {
        return WebUtils.toQueryString(parameters, "UTF-8");
    }

    private static boolean appendEntry(Map.Entry entry, StringBuilder queryString, String encoding, String path) throws UnsupportedEncodingException {
        String name = entry.getKey().toString();
        if (name.indexOf(".") > -1) {
            return false;
        }
        Object value = entry.getValue();
        if (value == null) {
            value = "";
        } else if (value instanceof GrailsParameterMap) {
            GrailsParameterMap child = (GrailsParameterMap)value;
            Set nestedEntrySet = child.entrySet();
            Iterator i = nestedEntrySet.iterator();
            while (i.hasNext()) {
                Map.Entry childEntry = (Map.Entry)i.next();
                WebUtils.appendEntry(childEntry, queryString, encoding, entry.getKey().toString() + '.');
                boolean hasMore = i.hasNext();
                if (!hasMore) continue;
                queryString.append('&');
            }
        } else {
            queryString.append(URLEncoder.encode(path + name, encoding)).append('=').append(URLEncoder.encode(value.toString(), encoding));
        }
        return true;
    }

    public static String getFormatFromURI(String uri) {
        return WebUtils.getFormatFromURI(uri, MimeType.getConfiguredMimeTypes());
    }

    public static String getFormatFromURI(String uri, MimeType[] mimeTypes) {
        String lastToken;
        if (uri.endsWith("/")) {
            return null;
        }
        int idx = uri.lastIndexOf(47);
        if (idx > -1 && (idx = (lastToken = uri.substring(idx + 1, uri.length())).lastIndexOf(46)) > -1 && idx != lastToken.length() - 1) {
            String extension = lastToken.substring(idx + 1, lastToken.length());
            if (mimeTypes != null) {
                for (MimeType mimeType : mimeTypes) {
                    if (!mimeType.getExtension().equals(extension)) continue;
                    return extension;
                }
            }
        }
        return null;
    }

    public static boolean areFileExtensionsEnabled() {
        Map config = GrailsWebUtil.currentFlatConfiguration();
        Object o = config.get(ENABLE_FILE_EXTENSIONS);
        return o == null || !(o instanceof Boolean) || (Boolean)o != false;
    }

    public static GrailsWebRequest retrieveGrailsWebRequest() {
        return (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
    }

    public static void storeGrailsWebRequest(GrailsWebRequest webRequest) {
        RequestContextHolder.setRequestAttributes((RequestAttributes)webRequest);
        webRequest.getRequest().setAttribute("org.codehaus.groovy.grails.WEB_REQUEST", (Object)webRequest);
    }

    public static void clearGrailsWebRequest() {
        RequestAttributes reqAttrs = RequestContextHolder.getRequestAttributes();
        if (reqAttrs != null) {
            GrailsWebRequest webRequest = (GrailsWebRequest)reqAttrs;
            webRequest.getRequest().removeAttribute("org.codehaus.groovy.grails.WEB_REQUEST");
            RequestContextHolder.resetRequestAttributes();
        }
    }

    public static String getForwardURI(HttpServletRequest request) {
        String result = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (StringUtils.isBlank((String)result)) {
            result = request.getRequestURI();
        }
        return result;
    }

    public static GrailsClass getConfiguredControllerForUrlMappingInfo(GrailsWebRequest webRequest, UrlMappingInfo info, UrlConverter urlConverterToUse, GrailsApplication grailsApplicationToUse) {
        String action = info.getActionName() == null ? "" : info.getActionName();
        String viewName = info.getViewName();
        GrailsClass controller = null;
        if (viewName == null && info.getURI() == null) {
            Object featureId;
            String controllerName = info.getControllerName();
            String pluginName = info.getPluginName();
            String featureUri = '/' + urlConverterToUse.toUrlElement(controllerName) + '/' + urlConverterToUse.toUrlElement(action);
            if (pluginName != null) {
                HashMap<String, String> featureIdMap = new HashMap<String, String>();
                featureIdMap.put("uri", featureUri);
                featureIdMap.put("pluginName", pluginName);
                featureId = featureIdMap;
            } else {
                featureId = featureUri;
            }
            controller = grailsApplicationToUse.getArtefactForFeature("Controller", featureId);
            if (controller != null) {
                webRequest.setAttribute("org.codehaus.groovy.grails.CONTROLLER_NAME_ATTRIBUTE", controller.getLogicalPropertyName(), 0);
                webRequest.setAttribute("org.codehaus.groovy.grails.GRAILS_CONTROLLER_CLASS", controller, 0);
                webRequest.setAttribute("org.codehaus.groovy.grails.GRAILS_CONTROLLER_CLASS_AVAILABLE", Boolean.TRUE, 0);
            }
        }
        return controller;
    }
}

