/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.binding;

import grails.util.GrailsNameUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.AbstractGrailsArtefactTransformer;
import org.codehaus.groovy.grails.compiler.injection.GrailsASTUtils;
import org.codehaus.groovy.grails.web.binding.ASTDatabindingHelper;
import org.codehaus.groovy.grails.web.binding.DatabindingApi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultASTDatabindingHelper
implements ASTDatabindingHelper {
    public static final String CONSTRAINTS_FIELD_NAME = "constraints";
    public static final String JODATIME_PACKAGE = "org.joda.time";
    public static final String BINDABLE_CONSTRAINT_NAME = "bindable";
    public static final String DEFAULT_DATABINDING_WHITELIST = "$defaultDatabindingWhiteList";
    private static Map<ClassNode, Set<String>> CLASS_NAME_TO_WHITE_LIST_PROPERTY_NAMES = new HashMap<ClassNode, Set<String>>();
    private static final List<ClassNode> SIMPLE_TYPES = new ArrayList<ClassNode>(){
        {
            this.add(new ClassNode(Boolean.class));
            this.add(new ClassNode(Boolean.TYPE));
            this.add(new ClassNode(Byte.class));
            this.add(new ClassNode(Byte.TYPE));
            this.add(new ClassNode(Character.class));
            this.add(new ClassNode(Character.TYPE));
            this.add(new ClassNode(Short.class));
            this.add(new ClassNode(Short.TYPE));
            this.add(new ClassNode(Integer.class));
            this.add(new ClassNode(Integer.TYPE));
            this.add(new ClassNode(Long.class));
            this.add(new ClassNode(Long.TYPE));
            this.add(new ClassNode(Float.class));
            this.add(new ClassNode(Float.TYPE));
            this.add(new ClassNode(Double.class));
            this.add(new ClassNode(Double.TYPE));
            this.add(new ClassNode(BigInteger.class));
            this.add(new ClassNode(BigDecimal.class));
            this.add(new ClassNode(String.class));
            this.add(new ClassNode(URL.class));
        }
    };
    private static final List<ClassNode> STRUCTURED_EDITOR_TYPES = new ArrayList<ClassNode>(){
        {
            this.add(new ClassNode(Date.class));
            this.add(new ClassNode(java.util.Date.class));
            this.add(new ClassNode(Calendar.class));
        }
    };

    @Override
    public void injectDatabindingCode(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        this.addDefaultDatabindingWhitelistField(source, classNode);
        this.addDatabindingApi(source, context, classNode);
    }

    private void addDatabindingApi(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        AbstractGrailsArtefactTransformer classInjector = new AbstractGrailsArtefactTransformer(){

            public boolean shouldInject(URL url) {
                return true;
            }

            public Class<?> getInstanceImplementation() {
                return DatabindingApi.class;
            }

            public Class<?> getStaticImplementation() {
                return null;
            }

            protected boolean requiresAutowiring() {
                return false;
            }
        };
        classInjector.performInjection(source, context, classNode);
    }

    private void addDefaultDatabindingWhitelistField(SourceUnit sourceUnit, ClassNode classNode) {
        FieldNode defaultWhitelistField = classNode.getDeclaredField(DEFAULT_DATABINDING_WHITELIST);
        if (defaultWhitelistField == null) {
            Set<String> propertyNamesToIncludeInWhiteList = this.getPropertyNamesToIncludeInWhiteList(sourceUnit, classNode);
            ListExpression listExpression = new ListExpression();
            for (String propertyName : propertyNamesToIncludeInWhiteList) {
                ClassNode type;
                listExpression.addExpression((Expression)new ConstantExpression((Object)propertyName));
                FieldNode declaredField = classNode.getDeclaredField(propertyName);
                if (declaredField == null || (type = declaredField.getType()) == null || SIMPLE_TYPES.contains(type)) continue;
                if (STRUCTURED_EDITOR_TYPES.contains(type)) {
                    listExpression.addExpression((Expression)new ConstantExpression((Object)(propertyName + "_*")));
                    continue;
                }
                String packageName = type.getPackageName();
                if (packageName != null && packageName.startsWith(JODATIME_PACKAGE)) {
                    listExpression.addExpression((Expression)new ConstantExpression((Object)(propertyName + "_*")));
                    continue;
                }
                listExpression.addExpression((Expression)new ConstantExpression((Object)(propertyName + ".*")));
            }
            classNode.addField(DEFAULT_DATABINDING_WHITELIST, 25, new ClassNode(List.class), (Expression)listExpression);
        }
    }

    private Set<String> getPropertyNamesToIncludeInWhiteList(SourceUnit sourceUnit, ClassNode classNode) {
        Expression constraintsInitialExpression;
        FieldNode constraintsFieldNode;
        if (CLASS_NAME_TO_WHITE_LIST_PROPERTY_NAMES.containsKey(classNode)) {
            return CLASS_NAME_TO_WHITE_LIST_PROPERTY_NAMES.get(classNode);
        }
        HashSet<String> propertyNamesToIncludeInWhiteList = new HashSet<String>();
        HashSet<String> unbindablePropertyNames = new HashSet<String>();
        HashSet<String> bindablePropertyNames = new HashSet<String>();
        if (!classNode.getSuperClass().equals((Object)new ClassNode(Object.class))) {
            Set<String> parentClassPropertyNames = this.getPropertyNamesToIncludeInWhiteList(sourceUnit, classNode.getSuperClass());
            bindablePropertyNames.addAll(parentClassPropertyNames);
        }
        if ((constraintsFieldNode = classNode.getDeclaredField(CONSTRAINTS_FIELD_NAME)) != null && constraintsFieldNode.hasInitialExpression() && (constraintsInitialExpression = constraintsFieldNode.getInitialExpression()) instanceof ClosureExpression) {
            Map constraintsInfo = GrailsASTUtils.getConstraintMetadata((ClosureExpression)((ClosureExpression)constraintsInitialExpression));
            for (Map.Entry entry : constraintsInfo.entrySet()) {
                String propertyName = (String)entry.getKey();
                Map mapEntryExpressions = (Map)entry.getValue();
                for (Map.Entry entry2 : mapEntryExpressions.entrySet()) {
                    Object constantValue;
                    String constraintName = (String)entry2.getKey();
                    if (!BINDABLE_CONSTRAINT_NAME.equals(constraintName)) continue;
                    Expression valueExpression = (Expression)entry2.getValue();
                    Boolean bindableValue = null;
                    if (valueExpression instanceof ConstantExpression && (constantValue = ((ConstantExpression)valueExpression).getValue()) instanceof Boolean) {
                        bindableValue = (Boolean)constantValue;
                    }
                    if (bindableValue != null) {
                        if (Boolean.TRUE.equals(bindableValue)) {
                            unbindablePropertyNames.remove(propertyName);
                            bindablePropertyNames.add(propertyName);
                            continue;
                        }
                        bindablePropertyNames.remove(propertyName);
                        unbindablePropertyNames.add(propertyName);
                        continue;
                    }
                    String message = "The bindable constraint for property [" + propertyName + "] in class [" + classNode.getName() + "] has a value which is not a boolean literal and will be ignored.";
                    GrailsASTUtils.warning((SourceUnit)sourceUnit, (ASTNode)valueExpression, (String)message);
                }
            }
        }
        Set<String> fieldsInTransientsList = this.getPropertyNamesExpressedInTransientsList(classNode);
        propertyNamesToIncludeInWhiteList.addAll(bindablePropertyNames);
        List fields = classNode.getFields();
        for (FieldNode fieldNode : fields) {
            String fieldName = fieldNode.getName();
            if (unbindablePropertyNames.contains(fieldName) || !bindablePropertyNames.contains(fieldName) && !this.shouldFieldBeInWhiteList(fieldNode, fieldsInTransientsList)) continue;
            propertyNamesToIncludeInWhiteList.add(fieldName);
        }
        Map declaredMethodsMap = classNode.getDeclaredMethodsMap();
        for (Map.Entry methodEntry : declaredMethodsMap.entrySet()) {
            String restOfMethodName;
            String propertyName;
            Parameter parameter;
            ClassNode paramType;
            String methodName;
            Parameter[] parameters;
            MethodNode value = (MethodNode)methodEntry.getValue();
            if (value.getDeclaringClass() != classNode || (parameters = value.getParameters()) == null || parameters.length != 1 || !(methodName = value.getName()).startsWith("set") || (paramType = (parameter = parameters[0]).getType()).equals((Object)new ClassNode(Object.class)) || unbindablePropertyNames.contains(propertyName = GrailsNameUtils.getPropertyName((String)(restOfMethodName = methodName.substring(3))))) continue;
            propertyNamesToIncludeInWhiteList.add(propertyName);
        }
        CLASS_NAME_TO_WHITE_LIST_PROPERTY_NAMES.put(classNode, propertyNamesToIncludeInWhiteList);
        Map map = GrailsASTUtils.getAllAssociationMap((ClassNode)classNode);
        for (String associationName : map.keySet()) {
            if (propertyNamesToIncludeInWhiteList.contains(associationName)) continue;
            propertyNamesToIncludeInWhiteList.add(associationName);
        }
        return propertyNamesToIncludeInWhiteList;
    }

    private boolean shouldFieldBeInWhiteList(FieldNode fieldNode, Set<String> fieldsInTransientsList) {
        boolean shouldInclude = true;
        int modifiers = fieldNode.getModifiers();
        if ((modifiers & 8) != 0 || (modifiers & 0x80) != 0 || fieldsInTransientsList.contains(fieldNode.getName()) || fieldNode.getType().equals((Object)new ClassNode(Object.class))) {
            shouldInclude = false;
        }
        return shouldInclude;
    }

    private Set<String> getPropertyNamesExpressedInTransientsList(ClassNode classNode) {
        Expression initialValueExpression;
        HashSet<String> transientFields = new HashSet<String>();
        FieldNode transientsField = classNode.getField("transients");
        if (transientsField != null && transientsField.isStatic() && (initialValueExpression = transientsField.getInitialValueExpression()) instanceof ListExpression) {
            ListExpression le = (ListExpression)initialValueExpression;
            List expressions = le.getExpressions();
            for (Expression expr : expressions) {
                ConstantExpression ce;
                Object contantValue;
                if (!(expr instanceof ConstantExpression) || !((contantValue = (ce = (ConstantExpression)expr).getValue()) instanceof String)) continue;
                transientFields.add((String)contantValue);
            }
        }
        return transientFields;
    }
}

