/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.taglib;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.grails.web.taglib.GrailsTag;
import org.codehaus.groovy.grails.web.taglib.GroovyCollectTag;
import org.codehaus.groovy.grails.web.taglib.GroovyDefTag;
import org.codehaus.groovy.grails.web.taglib.GroovyEachTag;
import org.codehaus.groovy.grails.web.taglib.GroovyElseIfTag;
import org.codehaus.groovy.grails.web.taglib.GroovyElseTag;
import org.codehaus.groovy.grails.web.taglib.GroovyFindAllTag;
import org.codehaus.groovy.grails.web.taglib.GroovyGrepTag;
import org.codehaus.groovy.grails.web.taglib.GroovyIfTag;
import org.codehaus.groovy.grails.web.taglib.GroovySyntaxTag;
import org.codehaus.groovy.grails.web.taglib.GroovyUnlessTag;
import org.codehaus.groovy.grails.web.taglib.GroovyWhileTag;
import org.codehaus.groovy.grails.web.taglib.RenderInputTag;
import org.codehaus.groovy.grails.web.taglib.RequestContextTag;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;

public class GrailsTagRegistry {
    private static GrailsTagRegistry instance;
    private static Map tagRegistry;

    private GrailsTagRegistry() {
    }

    public static GrailsTagRegistry getInstance() {
        if (instance == null) {
            instance = new GrailsTagRegistry();
        }
        return instance;
    }

    public void registerTag(String tagName, Class tag) {
        tagRegistry.put(tagName, tag);
    }

    public boolean tagSupported(String tagName) {
        return tagRegistry.containsKey(tagName);
    }

    public boolean isSyntaxTag(String tagName) {
        if (tagRegistry.containsKey(tagName)) {
            Class tagClass = (Class)tagRegistry.get(tagName);
            return GroovySyntaxTag.class.isAssignableFrom(tagClass);
        }
        return false;
    }

    public GrailsTag newTag(String tagName) {
        if (tagRegistry.containsKey(tagName)) {
            GrailsTag tag;
            Class tagClass = (Class)tagRegistry.get(tagName);
            try {
                tag = (GrailsTag)tagClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new GrailsTagException("Instantiation error loading tag [" + tagName + "]: " + e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new GrailsTagException("Illegal access error loading tag [" + tagName + "]: " + e.getMessage(), e);
            }
            return tag;
        }
        throw new GrailsTagException("Tag [" + tagName + "] is not a a valid grails tag");
    }

    public boolean isRequestContextTag(String tagName) {
        if (tagRegistry.containsKey(tagName)) {
            Class tagClass = (Class)tagRegistry.get(tagName);
            return RequestContextTag.class.isAssignableFrom(tagClass);
        }
        return false;
    }

    static {
        tagRegistry = new ConcurrentHashMap();
        GrailsTagRegistry tagRegistry = GrailsTagRegistry.getInstance();
        tagRegistry.registerTag("renderInput", RenderInputTag.class);
        tagRegistry.registerTag("each", GroovyEachTag.class);
        tagRegistry.registerTag("if", GroovyIfTag.class);
        tagRegistry.registerTag("unless", GroovyUnlessTag.class);
        tagRegistry.registerTag("else", GroovyElseTag.class);
        tagRegistry.registerTag("elseif", GroovyElseIfTag.class);
        tagRegistry.registerTag("findAll", GroovyFindAllTag.class);
        tagRegistry.registerTag("collect", GroovyCollectTag.class);
        tagRegistry.registerTag("grep", GroovyGrepTag.class);
        tagRegistry.registerTag("while", GroovyWhileTag.class);
        tagRegistry.registerTag("def", GroovyDefTag.class);
    }
}

