/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.mvc;

import groovy.lang.GString;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.grails.web.binding.StructuredDateEditor;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class GrailsParameterMap
implements Map {
    private Map parameterMap;
    private HttpServletRequest request;

    public GrailsParameterMap(HttpServletRequest request) {
        this.request = request;
        this.parameterMap = new HashMap();
        LinkedHashMap requestMap = new LinkedHashMap(request.getParameterMap());
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multipartRequest.getFileMap();
            for (Object fileName : fileMap.keySet()) {
                requestMap.put(fileName, multipartRequest.getFile((String)fileName));
            }
        }
        for (Object o : requestMap.keySet()) {
            String key = (String)o;
            Object paramValue = this.getParameterValue(requestMap, key);
            this.parameterMap.put(key, paramValue);
            this.processNestedKeys(request, requestMap, key, key, this.parameterMap);
        }
    }

    private Object getParameterValue(Map requestMap, String key) {
        String[] multiParams;
        Object paramValue = requestMap.get(key);
        if (paramValue instanceof String[] && (multiParams = (String[])paramValue).length == 1) {
            paramValue = multiParams[0];
        }
        return paramValue;
    }

    private void processNestedKeys(HttpServletRequest request, Map requestMap, String key, String nestedKey, Map nestedLevel) {
        int nestedIndex = nestedKey.indexOf(46);
        if (nestedIndex > -1) {
            String nestedPrefix = nestedKey.substring(0, nestedIndex);
            Object prefixValue = nestedLevel.get(nestedPrefix);
            if (prefixValue == null) {
                prefixValue = new GrailsParameterMap(new HashMap(), request);
                nestedLevel.put(nestedPrefix, prefixValue);
            }
            if (prefixValue instanceof Map) {
                Map nestedMap = (Map)prefixValue;
                if (nestedIndex < nestedKey.length() - 1) {
                    String remainderOfKey = nestedKey.substring(nestedIndex + 1, nestedKey.length());
                    nestedMap.put(remainderOfKey, this.getParameterValue(requestMap, key));
                    if (remainderOfKey.indexOf(46) > -1) {
                        this.processNestedKeys(request, requestMap, key, remainderOfKey, nestedMap);
                    }
                }
            }
        }
    }

    public GrailsParameterMap(Map values, HttpServletRequest request) {
        this.request = request;
        this.parameterMap = values;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public int size() {
        return this.parameterMap.size();
    }

    public boolean isEmpty() {
        return this.parameterMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.parameterMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.parameterMap.containsValue(value);
    }

    public Object get(Object key) {
        Object returnValue = null;
        if (this.parameterMap.get(key) instanceof String[]) {
            String[] valueArray = (String[])this.parameterMap.get(key);
            if (valueArray == null) {
                return null;
            }
            returnValue = valueArray.length == 1 ? valueArray[0] : valueArray;
        } else {
            returnValue = this.parameterMap.get(key);
        }
        if ("date.struct".equals(returnValue)) {
            return this.lazyEvaluateDateParam(key);
        }
        return returnValue;
    }

    private Date lazyEvaluateDateParam(Object key) {
        HashMap dateParams = new HashMap();
        for (Object o : this.entrySet()) {
            String prefix;
            String paramName;
            Map.Entry entry = (Map.Entry)o;
            Object entryKey = entry.getKey();
            if (!(entryKey instanceof String) || !(paramName = (String)entryKey).startsWith(prefix = key + "_")) continue;
            dateParams.put(paramName.substring(prefix.length(), paramName.length()), entry.getValue());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S", LocaleContextHolder.getLocale());
        StructuredDateEditor editor = new StructuredDateEditor(dateFormat, true);
        Date d = (Date)editor.assemble(Date.class, dateParams);
        this.put(key, d);
        return d;
    }

    public Object put(Object key, Object value) {
        if (value instanceof GString) {
            value = value.toString();
        }
        return this.parameterMap.put(key, value);
    }

    public Object remove(Object key) {
        return this.parameterMap.remove(key);
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.parameterMap.clear();
    }

    public Set keySet() {
        return this.parameterMap.keySet();
    }

    public Collection values() {
        return this.parameterMap.values();
    }

    public Set entrySet() {
        return this.parameterMap.entrySet();
    }

    public String toQueryString() {
        String encoding = this.request.getCharacterEncoding();
        try {
            return WebUtils.toQueryString(this, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ControllerExecutionException("Unable to convert parameter map [" + this + "] to a query string: " + e.getMessage(), e);
        }
    }

    public String toString() {
        return DefaultGroovyMethods.inspect((Object)this.parameterMap);
    }
}

