/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet;

import groovy.lang.GroovyObject;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsTagLibClass;
import org.codehaus.groovy.grails.plugins.PluginMetaManager;
import org.codehaus.groovy.grails.web.pages.DefaultGroovyPagesUriService;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.pages.GroovyPagesUriService;
import org.codehaus.groovy.grails.web.pages.exceptions.GroovyPagesException;
import org.codehaus.groovy.grails.web.servlet.FlashScope;
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.GrailsFlashScope;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;
import org.springframework.web.util.UrlPathHelper;

public class DefaultGrailsApplicationAttributes
implements GrailsApplicationAttributes {
    private static Log LOG = LogFactory.getLog(DefaultGrailsApplicationAttributes.class);
    private UrlPathHelper urlHelper = new UrlPathHelper();
    private ServletContext context;
    private ApplicationContext appContext;
    private GroovyPagesTemplateEngine pagesTemplateEngine;
    private GrailsApplication grailsApplication;
    private PluginMetaManager metaManager;
    private GroovyPagesUriService groovyPagesUriService;
    private MessageSource messageSource;

    public DefaultGrailsApplicationAttributes(ServletContext context) {
        this.context = context;
        if (context != null) {
            this.appContext = (ApplicationContext)context.getAttribute("org.codehaus.groovy.grails.APPLICATION_CONTEXT");
        }
        this.initBeans();
    }

    public ApplicationContext getApplicationContext() {
        return this.appContext;
    }

    private void initBeans() {
        if (this.appContext != null) {
            this.pagesTemplateEngine = (GroovyPagesTemplateEngine)((Object)this.fetchBeanFromAppCtx("groovyPagesTemplateEngine"));
            this.grailsApplication = (GrailsApplication)this.fetchBeanFromAppCtx("grailsApplication");
            this.metaManager = (PluginMetaManager)this.fetchBeanFromAppCtx("pluginMetaManager");
            this.groovyPagesUriService = (GroovyPagesUriService)this.fetchBeanFromAppCtx("groovyPagesUriService");
            this.messageSource = (MessageSource)this.fetchBeanFromAppCtx("messageSource");
        } else {
            LOG.warn((Object)"ApplicationContext not found in org.codehaus.groovy.grails.APPLICATION_CONTEXT attribute of servlet context.");
        }
        if (this.groovyPagesUriService == null) {
            this.groovyPagesUriService = new DefaultGroovyPagesUriService();
        }
    }

    private Object fetchBeanFromAppCtx(String name) {
        try {
            return this.appContext.getBean(name);
        }
        catch (BeansException e) {
            LOG.warn((Object)("Bean named '" + name + "' is missing."));
            return null;
        }
    }

    public String getPluginContextPath(HttpServletRequest request) {
        GroovyObject controller = this.getController((ServletRequest)request);
        if (controller != null) {
            Class<?> controllerClass = controller.getClass();
            String path = this.metaManager.getPluginPathForResource(controllerClass.getName());
            return path == null ? "" : path;
        }
        return "";
    }

    public GroovyObject getController(ServletRequest request) {
        return (GroovyObject)request.getAttribute("org.codehaus.groovy.grails.CONTROLLER");
    }

    public String getControllerUri(ServletRequest request) {
        return "/" + this.getControllerName(request);
    }

    private String getControllerName(ServletRequest request) {
        GroovyObject controller;
        String controllerName = (String)request.getAttribute("org.codehaus.groovy.grails.CONTROLLER_NAME_ATTRIBUTE");
        if ((controllerName == null || controllerName.length() == 0) && (controller = this.getController(request)) != null) {
            controllerName = (String)controller.getProperty("controllerName");
            request.setAttribute("org.codehaus.groovy.grails.CONTROLLER_NAME_ATTRIBUTE", (Object)controllerName);
        }
        return controllerName != null ? controllerName : "";
    }

    @Deprecated
    public String getApplicationUri(ServletRequest request) {
        String appUri = (String)request.getAttribute("org.codehaus.groovy.grails.APP_URI_ATTRIBUTE");
        if (appUri == null) {
            appUri = this.urlHelper.getContextPath((HttpServletRequest)request);
        }
        return appUri;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public FlashScope getFlashScope(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest servletRequest = (HttpServletRequest)request;
            HttpSession session = servletRequest.getSession(false);
            FlashScope fs = session != null ? (FlashScope)session.getAttribute("org.codehaus.groovy.grails.FLASH_SCOPE") : (FlashScope)request.getAttribute("org.codehaus.groovy.grails.FLASH_SCOPE");
            if (fs == null) {
                fs = new GrailsFlashScope();
                if (session != null) {
                    session.setAttribute("org.codehaus.groovy.grails.FLASH_SCOPE", (Object)fs);
                } else {
                    request.setAttribute("org.codehaus.groovy.grails.FLASH_SCOPE", (Object)fs);
                }
            }
            return fs;
        }
        return null;
    }

    public String getTemplateUri(String templateName, ServletRequest request) {
        return this.groovyPagesUriService.getTemplateURI(this.getControllerName(request), templateName);
    }

    public String getViewUri(String viewName, HttpServletRequest request) {
        return this.groovyPagesUriService.getDeployedViewURI(this.getControllerName((ServletRequest)request), viewName);
    }

    public String getControllerActionUri(ServletRequest request) {
        GroovyObject controller = this.getController(request);
        return (String)controller.getProperty("actionUri");
    }

    public Errors getErrors(ServletRequest request) {
        return (Errors)request.getAttribute("org.codehaus.groovy.grails.ERRORS");
    }

    public GroovyPagesTemplateEngine getPagesTemplateEngine() {
        if (this.pagesTemplateEngine != null) {
            return this.pagesTemplateEngine;
        }
        throw new GroovyPagesException("No bean named [groovyPagesTemplateEngine] defined in Spring application context!");
    }

    public GrailsApplication getGrailsApplication() {
        return this.grailsApplication;
    }

    public GroovyObject getTagLibraryForTag(HttpServletRequest request, HttpServletResponse response, String tagName) {
        return this.getTagLibraryForTag(request, response, tagName, "g");
    }

    public GroovyObject getTagLibraryForTag(HttpServletRequest request, HttpServletResponse response, String tagName, String namespace) {
        String nonNullNamesapce = namespace == null ? "g" : namespace;
        String fullTagName = nonNullNamesapce + ":" + tagName;
        GrailsTagLibClass tagLibClass = (GrailsTagLibClass)this.getGrailsApplication().getArtefactForFeature("TagLib", (Object)fullTagName);
        if (tagLibClass == null) {
            return null;
        }
        return (GroovyObject)this.getApplicationContext().getBean(tagLibClass.getFullName());
    }

    public Writer getOut(HttpServletRequest request) {
        return (Writer)request.getAttribute("org.codehaus.groovy.grails.RESPONSE_OUT");
    }

    public void setOut(HttpServletRequest request, Writer out2) {
        request.setAttribute("org.codehaus.groovy.grails.RESPONSE_OUT", (Object)out2);
    }

    public String getNoSuffixViewURI(GroovyObject controller, String viewName) {
        return this.groovyPagesUriService.getNoSuffixViewURI(controller, viewName);
    }

    public String getTemplateURI(GroovyObject controller, String templateName) {
        return this.groovyPagesUriService.getTemplateURI(controller, templateName);
    }

    public GroovyPagesUriService getGroovyPagesUriService() {
        return this.groovyPagesUriService;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }
}

