/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.Environment;
import grails.util.GrailsUtil;
import grails.util.Metadata;
import groovy.lang.GroovyClassLoader;
import groovy.text.Template;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.grails.support.ResourceAwareTemplateEngine;
import org.codehaus.groovy.grails.web.errors.GrailsExceptionResolver;
import org.codehaus.groovy.grails.web.pages.GroovyPageMetaInfo;
import org.codehaus.groovy.grails.web.pages.GroovyPageParser;
import org.codehaus.groovy.grails.web.pages.GroovyPageTemplate;
import org.codehaus.groovy.grails.web.pages.TagLibraryLookup;
import org.codehaus.groovy.grails.web.pages.exceptions.GroovyPagesException;
import org.codehaus.groovy.grails.web.pages.ext.jsp.TagLibraryResolver;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.ServletContextResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyPagesTemplateEngine
extends ResourceAwareTemplateEngine
implements ApplicationContextAware,
ServletContextAware,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(GroovyPagesTemplateEngine.class);
    private Map<String, GroovyPageMetaInfo> pageCache = new ConcurrentHashMap<String, GroovyPageMetaInfo>();
    private ClassLoader classLoader;
    private int scriptNameCount;
    private ResourceLoader resourceLoader;
    public static final String BEAN_ID = "groovyPagesTemplateEngine";
    public static final String RESOURCE_LOADER_BEAN_ID = "groovyPagesResourceLoader";
    private boolean reloadEnabled;
    private ServletContextResourceLoader servletContextLoader;
    private TagLibraryLookup tagLibraryLookup;
    private TagLibraryResolver jspTagLibraryResolver;
    private Map<String, String> precompiledGspMap;
    private Map<String, GroovyPageMetaInfo> precompiledCache = new ConcurrentHashMap<String, GroovyPageMetaInfo>();

    public GroovyPagesTemplateEngine() {
    }

    public GroovyPagesTemplateEngine(ServletContext servletContext) {
        if (servletContext == null) {
            throw new IllegalArgumentException("Argument [servletContext] cannot be null");
        }
        this.resourceLoader = new ServletContextResourceLoader(servletContext);
        this.servletContextLoader = new ServletContextResourceLoader(servletContext);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.classLoader == null) {
            this.classLoader = new GroovyClassLoader();
        }
    }

    public void setTagLibraryLookup(TagLibraryLookup tagLibraryLookup) {
        this.tagLibraryLookup = tagLibraryLookup;
    }

    public void setJspTagLibraryResolver(TagLibraryResolver jspTagLibraryResolver) {
        this.jspTagLibraryResolver = jspTagLibraryResolver;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public int[] calculateLineNumbersForPage(ServletContext context, String url) {
        try {
            Template t = this.createTemplate(url);
            if (t != null && t instanceof GroovyPageTemplate) {
                return ((GroovyPageTemplate)t).getMetaInfo().getLineNumbers();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception retrieving line numbers from GSP: " + url + ", message: " + e.getMessage()));
            LOG.debug((Object)"Full stack trace of error", (Throwable)e);
        }
        return new int[0];
    }

    public Template createTemplate(Resource resource) {
        if (resource == null) {
            GrailsWebRequest webRequest = this.getWebRequest();
            throw new GroovyPagesException("No Groovy page found for URI: " + this.getCurrentRequestUri(webRequest.getCurrentRequest()));
        }
        String name = this.establishPageName(resource, null);
        if (!this.isReloadEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating template using resource " + resource), (Throwable)new Exception("Creating template using resource " + resource));
            } else if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Creating template using resource " + resource));
            }
        }
        if (this.pageCache.containsKey(name)) {
            GroovyPageMetaInfo meta = this.pageCache.get(name);
            if (this.isGroovyPageReloadable(resource, meta)) {
                try {
                    return this.createTemplateWithResource(resource);
                }
                catch (IOException e) {
                    throw new GroovyPagesException("I/O error reading stream for resource [" + resource + "]: " + e.getMessage(), e);
                }
            }
            return new GroovyPageTemplate(meta);
        }
        try {
            return this.createTemplateWithResource(resource);
        }
        catch (IOException e) {
            throw new GroovyPagesException("I/O error reading stream for resource [" + resource + "]: " + e.getMessage(), e);
        }
    }

    public Template createTemplate(String uri) {
        GroovyPageTemplate t = this.createTemplateFromPrecompiled(uri);
        if (t == null) {
            t = this.createTemplate(this.getResourceForUri(uri));
        }
        return t;
    }

    private GroovyPageTemplate createTemplateFromPrecompiled(String uri) {
        if (this.isReloadEnabled()) {
            return null;
        }
        GroovyPageTemplate t = this.createTemplateFromPrecompiled(uri, uri);
        if (t == null) {
            t = this.createTemplateFromPrecompiled(uri, "/WEB-INF" + uri);
        }
        if (t == null) {
            t = this.createTemplateFromPrecompiled(uri, this.getUriWithinGrailsViews(uri));
        }
        return t;
    }

    private GroovyPageTemplate createTemplateFromPrecompiled(String originalUri, String uri) {
        if (this.precompiledGspMap != null) {
            GroovyPageMetaInfo meta = this.precompiledCache.get(uri);
            if (meta != null) {
                return new GroovyPageTemplate(meta);
            }
            String gspClassName = this.precompiledGspMap.get(uri);
            if (gspClassName != null) {
                Class<?> gspClass = null;
                try {
                    gspClass = Class.forName(gspClassName, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    LOG.warn((Object)("Cannot load class " + gspClassName + ". Resuming on non-precompiled implementation."), (Throwable)e);
                }
                if (gspClass != null) {
                    meta = new GroovyPageMetaInfo(gspClass);
                    meta.setJspTagLibraryResolver(this.jspTagLibraryResolver);
                    meta.setTagLibraryLookup(this.tagLibraryLookup);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Adding GSP class GroovyPageMetaInfo in cache for uri " + uri + " classname is " + gspClassName));
                    }
                    this.precompiledCache.put(uri, meta);
                    this.precompiledCache.put(originalUri, meta);
                    return new GroovyPageTemplate(meta);
                }
            }
            if (this.precompiledGspMap.size() > 0) {
                // empty if block
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No precompiled template found for uri '" + uri + "'"));
            }
        }
        return null;
    }

    public Template createTemplateForUri(String uri) {
        return this.createTemplateForUri(new String[]{uri});
    }

    public Template createTemplateForUri(String[] uri) {
        GroovyPageTemplate t = null;
        if (!this.isReloadEnabled()) {
            for (int i = 0; i < uri.length; ++i) {
                t = this.createTemplateFromPrecompiled(uri[i]);
                if (t == null) continue;
                return t;
            }
        }
        Resource resource = null;
        for (int i = 0; i < uri.length; ++i) {
            Resource r = this.getResourceForUri(uri[i]);
            if (!r.exists()) continue;
            resource = r;
            break;
        }
        if (resource != null) {
            if (this.precompiledGspMap != null && this.precompiledGspMap.size() > 0 && LOG.isWarnEnabled()) {
                LOG.warn((Object)("Precompiled GSP not found for uri: " + Arrays.asList(uri) + ". Using resource " + resource));
            }
            return this.createTemplate(resource);
        }
        return null;
    }

    public Template createTemplate(String txt, String pageName) throws IOException {
        if (StringUtils.isBlank((String)txt)) {
            throw new IllegalArgumentException("Argument [txt] cannot be null or blank");
        }
        if (StringUtils.isBlank((String)pageName)) {
            throw new IllegalArgumentException("Argument [pageName] cannot be null or blank");
        }
        return this.createTemplate((Resource)new ByteArrayResource(txt.getBytes("UTF-8"), pageName), pageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template createTemplate(Resource resource, String pageName) throws IOException {
        InputStream in = resource.getInputStream();
        try {
            Template template = this.createTemplate(in, resource, pageName);
            return template;
        }
        finally {
            in.close();
        }
    }

    public Template createTemplate() throws IOException, ClassNotFoundException {
        GrailsWebRequest webRequest = this.getWebRequest();
        String uri = this.getCurrentRequestUri(webRequest.getCurrentRequest());
        return this.createTemplate(uri);
    }

    public Template createTemplate(File file) throws CompilationFailedException, ClassNotFoundException, IOException {
        return this.createTemplate((Resource)new FileSystemResource(file));
    }

    public Template createTemplate(URL url) throws CompilationFailedException, ClassNotFoundException, IOException {
        return this.createTemplate((Resource)new UrlResource(url));
    }

    public Template createTemplate(InputStream inputStream) {
        GroovyPageMetaInfo metaInfo = this.buildPageMetaInfo(inputStream, null, null);
        return new GroovyPageTemplate(metaInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template createTemplateWithResource(Resource resource) throws IOException {
        InputStream in = resource.getInputStream();
        try {
            Template template = this.createTemplate(in, resource, null);
            return template;
        }
        finally {
            in.close();
        }
    }

    protected Template createTemplate(InputStream inputStream, Resource resource, String pageName) {
        GroovyPageMetaInfo metaInfo = this.buildPageMetaInfo(inputStream, resource, pageName);
        return new GroovyPageTemplate(metaInfo);
    }

    private boolean isGroovyPageReloadable(Resource resource, GroovyPageMetaInfo meta) {
        return this.isReloadEnabled() && this.establishLastModified(resource) > meta.getLastModified();
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    public void setReloadEnabled(boolean b) {
        this.reloadEnabled = b;
    }

    private Resource getResourceForUri(String uri) {
        String pluginUri;
        Resource r = this.getResourceWithinContext(uri);
        if (!(r != null && r.exists() || (r = this.getResourceWithinContext(pluginUri = "/WEB-INF" + uri)) != null && r.exists())) {
            uri = this.getUriWithinGrailsViews(uri);
            return this.getResourceWithinContext(uri);
        }
        return r;
    }

    private Resource getResourceWithinContext(String uri) {
        if (this.resourceLoader == null) {
            throw new IllegalStateException("TemplateEngine not initialised correctly, no [resourceLoader] specified!");
        }
        if (Environment.getCurrent().isReloadEnabled() && Metadata.getCurrent().isWarDeployed()) {
            return this.resourceLoader.getResource(uri);
        }
        Resource r = this.servletContextLoader.getResource(uri);
        if (r.exists()) {
            return r;
        }
        return this.resourceLoader.getResource(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long establishLastModified(Resource resource) {
        long lastModified;
        if (resource == null) {
            return -1L;
        }
        URLConnection urlc = null;
        try {
            urlc = resource.getURL().openConnection();
            urlc.setDoInput(false);
            urlc.setDoOutput(false);
            lastModified = urlc.getLastModified();
        }
        catch (FileNotFoundException fnfe) {
            lastModified = -1L;
        }
        catch (IOException e) {
            lastModified = -1L;
        }
        finally {
            if (urlc != null) {
                try {
                    InputStream is = urlc.getInputStream();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return lastModified;
    }

    protected GroovyPageMetaInfo buildPageMetaInfo(InputStream inputStream, Resource res, String pageName) {
        GroovyPageParser parser;
        String name = this.establishPageName(res, pageName);
        long lastModified = this.establishLastModified(res);
        String path = this.getPathForResource(res);
        try {
            parser = new GroovyPageParser(name, path, inputStream);
        }
        catch (IOException e) {
            throw new GroovyPagesException("I/O parsing Groovy page [" + (res != null ? res.getDescription() : name) + "]: " + e.getMessage(), e);
        }
        InputStream in = parser.parse();
        GroovyPageMetaInfo metaInfo = this.createPageMetaInfo(parser, lastModified, in);
        try {
            metaInfo.setPageClass(this.compileGroovyPage(in, name, path, metaInfo));
            metaInfo.setHtmlParts(parser.getHtmlPartsArray());
        }
        catch (GroovyPagesException e) {
            metaInfo.setCompilationException(e);
        }
        this.pageCache.put(name, metaInfo);
        return metaInfo;
    }

    private String getPathForResource(Resource res) {
        if (res == null) {
            return "";
        }
        String path = null;
        try {
            File file = res.getFile();
            if (file != null) {
                path = file.getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (path != null) {
            return path;
        }
        if (res.getDescription() != null) {
            return res.getDescription();
        }
        return "";
    }

    private Class compileGroovyPage(InputStream in, String name, String pageName, GroovyPageMetaInfo metaInfo) {
        Class scriptClass;
        if (!(this.classLoader instanceof GroovyClassLoader)) {
            throw new GroovyPagesException("Application default classloader is not GroovyClassLoader. Enable reloading in application settings.");
        }
        try {
            scriptClass = ((GroovyClassLoader)this.classLoader).parseClass(in, name);
        }
        catch (CompilationFailedException e) {
            LOG.error((Object)("Compilation error compiling GSP [" + name + "]:" + e.getMessage()), (Throwable)e);
            int lineNumber = GrailsExceptionResolver.extractLineNumber(e);
            int[] lineMappings = metaInfo.getLineNumbers();
            if (lineNumber > 0 && lineNumber < lineMappings.length) {
                lineNumber = lineMappings[lineNumber - 1];
            }
            throw new GroovyPagesException("Could not parse script [" + name + "]: " + e.getMessage(), e, lineNumber, pageName);
        }
        return scriptClass;
    }

    private GroovyPageMetaInfo createPageMetaInfo(GroovyPageParser parse, long lastModified, InputStream in) {
        GroovyPageMetaInfo pageMeta = new GroovyPageMetaInfo();
        pageMeta.setJspTagLibraryResolver(this.jspTagLibraryResolver);
        pageMeta.setTagLibraryLookup(this.tagLibraryLookup);
        pageMeta.setContentType(parse.getContentType());
        pageMeta.setLineNumbers(parse.getLineNumberMatrix());
        pageMeta.setLastModified(lastModified);
        pageMeta.setJspTags(parse.getJspTags());
        if (this.isReloadEnabled() || GrailsUtil.isDevelopmentEnv()) {
            pageMeta.setGroovySource(in);
        }
        return pageMeta;
    }

    private GrailsWebRequest getWebRequest() {
        return (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
    }

    protected String establishPageName(Resource res, String pageName) {
        String name;
        if (res == null) {
            return this.generateTemplateName();
        }
        try {
            String string = name = pageName != null ? pageName : res.getURL().getPath();
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            name = name.replaceAll("[^\\w\\d]", "_");
        }
        catch (IllegalStateException e) {
            name = this.generateTemplateName();
        }
        catch (IOException ioex) {
            name = this.generateTemplateName();
        }
        return name;
    }

    private String generateTemplateName() {
        return "gsp_script_" + ++this.scriptNameCount;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.resourceLoader == null) {
            this.resourceLoader = applicationContext;
        }
    }

    protected String getCurrentRequestUri(HttpServletRequest request) {
        Object includePath = request.getAttribute("javax.servlet.include.servlet_path");
        if (includePath != null) {
            return ((String)includePath).intern();
        }
        return request.getServletPath().intern();
    }

    protected String getUriWithinGrailsViews(String relativeUri) {
        StringBuilder buf = new StringBuilder();
        if (relativeUri.startsWith("/")) {
            relativeUri = relativeUri.substring(1);
        }
        String[] tokens = relativeUri.indexOf(47) > -1 ? relativeUri.split("/") : new String[]{relativeUri};
        buf.append("/WEB-INF/grails-app/views");
        for (String token : tokens) {
            buf.append('/').append(token);
        }
        if (!relativeUri.endsWith(".gsp")) {
            buf.append(".gsp");
        }
        return buf.toString();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContextLoader = new ServletContextResourceLoader(servletContext);
        if (this.resourceLoader == null) {
            this.resourceLoader = new ServletContextResourceLoader(servletContext);
        }
    }

    public void clearPageCache() {
        this.pageCache.clear();
        this.precompiledCache.clear();
    }

    public Map<String, String> getPrecompiledGspMap() {
        return this.precompiledGspMap;
    }

    public void setPrecompiledGspMap(Map<String, String> precompiledGspMap) {
        this.precompiledGspMap = precompiledGspMap;
    }
}

