/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GrailsPrintWriter
extends PrintWriter {
    private static final Log LOG = LogFactory.getLog(GrailsPrintWriter.class);
    private static final char[] CRLF = new char[]{'\r', '\n'};
    protected boolean trouble = false;
    protected Writer out;
    private boolean finalTargetHere = false;

    public GrailsPrintWriter(Writer out) {
        super(out);
        this.out = out;
    }

    public Writer getOut() {
        return this.out;
    }

    public boolean isFinalTargetHere() {
        return this.finalTargetHere;
    }

    public void setFinalTargetHere(boolean finalTargetHere) {
        this.finalTargetHere = finalTargetHere;
    }

    public Writer getFinalTarget() {
        Writer wrapped = this.getOut();
        if (!this.isFinalTargetHere()) {
            while (wrapped instanceof GrailsPrintWriter) {
                wrapped = ((GrailsPrintWriter)wrapped).getFinalTarget();
            }
        }
        return wrapped;
    }

    public GrailsPrintWriter leftShift(Object value) throws IOException {
        if (value != null) {
            InvokerHelper.write((Writer)this, (Object)value);
        }
        return this;
    }

    public boolean checkError() {
        return this.trouble || super.checkError();
    }

    public synchronized void flush() {
        if (this.trouble) {
            return;
        }
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    protected void handleIOException(IOException e) {
        if (!this.trouble) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("I/O exception in GrailsPrintWriter: " + e.getMessage()), (Throwable)e);
            }
            this.trouble = true;
            this.setError();
        }
    }

    public void print(Object obj) {
        if (this.trouble || obj == null) {
            return;
        }
        if (obj instanceof CharSequence) {
            try {
                this.out.append((CharSequence)obj);
            }
            catch (IOException e) {
                this.handleIOException(e);
            }
        } else {
            this.write(String.valueOf(obj));
        }
    }

    public void print(String s) {
        if (s == null) {
            return;
        }
        this.write(s);
    }

    public void write(String s) {
        if (this.trouble || s == null) {
            return;
        }
        try {
            this.out.write(s);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    public void write(int c) {
        if (this.trouble) {
            return;
        }
        try {
            this.out.write(c);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    public void write(char[] buf, int off, int len) {
        if (this.trouble || buf == null || len == 0) {
            return;
        }
        try {
            this.out.write(buf, off, len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    public void write(String s, int off, int len) {
        if (this.trouble || s == null || s.length() == 0) {
            return;
        }
        try {
            this.out.write(s, off, len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    public void print(boolean b) {
        if (b) {
            this.write("true");
        } else {
            this.write("false");
        }
    }

    public void print(char c) {
        this.write(c);
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) {
        this.write(s);
    }

    public void println() {
        this.write(CRLF);
    }

    public void println(boolean b) {
        this.print(b);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(int i) {
        this.print(i);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void println(float f) {
        this.print(f);
        this.println();
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(char[] c) {
        this.print(c);
        this.println();
    }

    public void println(String s) {
        this.print(s);
        this.println();
    }

    public void println(Object o) {
        this.print(o);
        this.println();
    }

    public PrintWriter append(char c) {
        try {
            this.out.append(c);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        return this;
    }

    public PrintWriter append(CharSequence csq, int start, int end) {
        try {
            this.out.append(csq, start, end);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        return this;
    }

    public PrintWriter append(CharSequence csq) {
        try {
            this.out.append(csq);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        return this;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

