/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.view;

import grails.util.GrailsUtil;
import groovy.lang.GroovyObject;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.plugins.PluginMetaManager;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.view.GroovyPageView;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

public class GrailsViewResolver
extends InternalResourceViewResolver
implements ResourceLoaderAware,
ApplicationContextAware {
    private String localPrefix;
    private static final Log LOG = LogFactory.getLog(GrailsViewResolver.class);
    public static final String GSP_SUFFIX = ".gsp";
    public static final String JSP_SUFFIX = ".jsp";
    private ResourceLoader resourceLoader;
    private GroovyPagesTemplateEngine templateEngine;
    private PluginMetaManager pluginMetaManager;
    private static final String GROOVY_PAGE_RESOURCE_LOADER = "groovyPageResourceLoader";
    private static final Map<String, View> VIEW_CACHE = new ConcurrentHashMap<String, View>();
    private static final char DOT = '.';
    private static final char SLASH = '/';

    public GrailsViewResolver() {
        this.setCache(!GrailsUtil.isDevelopmentEnv());
    }

    public void setPrefix(String prefix) {
        super.setPrefix(prefix);
        this.localPrefix = prefix;
    }

    public void setSuffix(String suffix) {
        super.setSuffix(suffix);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setPluginMetaManager(PluginMetaManager pluginMetaManager) {
        this.pluginMetaManager = pluginMetaManager;
    }

    public void setTemplateEngine(GroovyPagesTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    protected View loadView(String viewName, Locale locale) throws Exception {
        if (this.templateEngine == null) {
            throw new IllegalStateException("Property [templateEngine] cannot be null");
        }
        if (this.pluginMetaManager == null) {
            throw new IllegalStateException("Property [pluginMetaManager] cannot be null");
        }
        if (VIEW_CACHE.containsKey(viewName) && !this.templateEngine.isReloadEnabled()) {
            return VIEW_CACHE.get(viewName);
        }
        GrailsWebRequest webRequest = WebUtils.retrieveGrailsWebRequest();
        HttpServletRequest request = webRequest.getCurrentRequest();
        GroovyObject controller = webRequest.getAttributes().getController((ServletRequest)request);
        GrailsApplication application = (GrailsApplication)this.getApplicationContext().getBean("grailsApplication");
        ResourceLoader resourceLoader = this.establishResourceLoader(application);
        String format = request.getAttribute("org.codehaus.groovy.grails.CONTENT_FORMAT") != null ? request.getAttribute("org.codehaus.groovy.grails.CONTENT_FORMAT").toString() : null;
        String gspView = this.localPrefix + viewName + '.' + format + GSP_SUFFIX;
        Resource res = null;
        if (format != null && !(res = resourceLoader.getResource(gspView)).exists()) {
            gspView = this.resolveViewForController(controller, application, viewName, resourceLoader);
            res = resourceLoader.getResource(gspView);
        }
        if (!(res != null && res.exists() || (res = resourceLoader.getResource(gspView = this.localPrefix + viewName + GSP_SUFFIX)).exists())) {
            gspView = this.resolveViewForController(controller, application, viewName, resourceLoader);
            res = resourceLoader.getResource(gspView);
        }
        if (res.exists()) {
            View view = this.createGroovyPageView(webRequest, gspView);
            VIEW_CACHE.put(viewName, view);
            return view;
        }
        AbstractUrlBasedView view = this.buildView(viewName);
        view.setApplicationContext(this.getApplicationContext());
        view.afterPropertiesSet();
        VIEW_CACHE.put(viewName, (View)view);
        return view;
    }

    private View createGroovyPageView(GrailsWebRequest webRequest, String gspView) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resolved GSP view at URI [" + gspView + "]"));
        }
        GroovyPageView gspSpringView = new GroovyPageView();
        gspSpringView.setServletContext(webRequest.getServletContext());
        gspSpringView.setUrl(gspView);
        gspSpringView.setApplicationContext(this.getApplicationContext());
        return gspSpringView;
    }

    protected String resolveViewForController(GroovyObject controller, GrailsApplication application, String viewName, ResourceLoader resourceLoader) {
        String pathToView;
        String gspView = controller != null && application != null ? ((pathToView = this.pluginMetaManager.getPluginViewsPathForResource(controller.getClass().getName())) != null ? "/WEB-INF" + pathToView + viewName + GSP_SUFFIX : this.localPrefix + viewName + GSP_SUFFIX) : this.localPrefix + viewName + GSP_SUFFIX;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Attempting to resolve view for URI [" + gspView + "] using ResourceLoader [" + resourceLoader.getClass() + "]"));
        }
        return gspView;
    }

    private ResourceLoader establishResourceLoader(GrailsApplication application) {
        ApplicationContext ctx = this.getApplicationContext();
        if (ctx.containsBean(GROOVY_PAGE_RESOURCE_LOADER) && application != null && !application.isWarDeployed()) {
            return (ResourceLoader)ctx.getBean(GROOVY_PAGE_RESOURCE_LOADER);
        }
        return this.resourceLoader;
    }
}

