/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.GrailsUtil;
import groovy.lang.Binding;
import groovy.lang.GroovyObject;
import groovy.lang.Writable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.web.pages.GroovyPage;
import org.codehaus.groovy.grails.web.pages.GroovyPageMetaInfo;
import org.codehaus.groovy.grails.web.servlet.WrappedResponseHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroovyPageWritable
implements Writable {
    private static final Log LOG = LogFactory.getLog(GroovyPageWritable.class);
    private HttpServletResponse response;
    private HttpServletRequest request;
    private GroovyPageMetaInfo metaInfo;
    private boolean showSource;
    private ServletContext context;
    private Map additionalBinding = new HashMap();
    private static final String GROOVY_SOURCE_CONTENT_TYPE = "text/plain";
    private static Map<String, Class> domainsWithoutPackage = new HashMap<String, Class>();

    public GroovyPageWritable(GroovyPageMetaInfo metaInfo) {
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        this.request = webRequest.getCurrentRequest();
        HttpServletResponse wrapped = WrappedResponseHolder.getWrappedResponse();
        this.response = wrapped != null ? wrapped : webRequest.getCurrentResponse();
        this.context = webRequest.getServletContext();
        this.showSource = this.request.getParameter("showSource") != null && GrailsUtil.isDevelopmentEnv() && metaInfo.getGroovySource() != null;
        this.metaInfo = metaInfo;
    }

    public void setBinding(Map binding) {
        if (binding != null) {
            this.additionalBinding = binding;
        }
    }

    public void setShowSource(boolean showSource) {
        this.showSource = showSource;
    }

    public Writer writeTo(Writer out) throws IOException {
        if (this.showSource) {
            this.response.setContentType(GROOVY_SOURCE_CONTENT_TYPE);
            this.writeGroovySourceToResponse(this.metaInfo, out);
        } else {
            boolean contentTypeAlreadySet;
            if (this.metaInfo.getCompilationException() != null) {
                throw this.metaInfo.getCompilationException();
            }
            boolean bl = contentTypeAlreadySet = this.response.isCommitted() || this.response.getContentType() != null;
            if (LOG.isDebugEnabled() && !contentTypeAlreadySet) {
                LOG.debug((Object)("Writing response to [" + this.response.getClass() + "] with content type: " + this.metaInfo.getContentType()));
            }
            if (!contentTypeAlreadySet) {
                this.response.setContentType(this.metaInfo.getContentType());
            }
            Binding binding = (Binding)this.request.getAttribute("org.codehaus.groovy.grails.PAGE_SCOPE");
            Binding oldBinding = null;
            if (binding == null) {
                binding = this.createBinding();
                this.formulateBinding(this.request, this.response, binding, out);
            } else {
                oldBinding = binding;
                binding = this.createBinding();
                this.formulateBinding(this.request, this.response, binding, out);
            }
            GroovyPage page = (GroovyPage)InvokerHelper.createScript((Class)this.metaInfo.getPageClass(), (Binding)binding);
            page.setJspTags(this.metaInfo.getJspTags());
            page.setJspTagLibraryResolver(this.metaInfo.getJspTagLibraryResolver());
            page.setGspTagLibraryLookup(this.metaInfo.getTagLibraryLookup());
            page.setHtmlParts(this.metaInfo.getHtmlParts());
            page.run();
            this.request.setAttribute("org.codehaus.groovy.grails.PAGE_SCOPE", (Object)oldBinding);
        }
        return out;
    }

    protected void copyBinding(Binding binding, Binding oldBinding, Writer out) throws IOException {
        this.formulateBindingFromWebRequest(binding, this.request, this.response, out, (GroovyObject)this.request.getAttribute("org.codehaus.groovy.grails.CONTROLLER"));
        binding.getVariables().putAll(oldBinding.getVariables());
        for (Object o : this.additionalBinding.keySet()) {
            String key = (String)o;
            if (!GroovyPage.isReservedName(key)) {
                binding.setVariable(key, this.additionalBinding.get(key));
                continue;
            }
            LOG.debug((Object)("Variable [" + key + "] cannot be placed within the GSP model, the name used is a reserved name."));
        }
    }

    private Binding createBinding() {
        Binding binding = new Binding();
        this.request.setAttribute("org.codehaus.groovy.grails.PAGE_SCOPE", (Object)binding);
        binding.setVariable("pageScope", (Object)binding);
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInputStreamToResponse(InputStream in, Writer out) throws IOException {
        try {
            int read;
            in.reset();
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            char[] buf = new char[8192];
            while ((read = reader.read(buf)) > 0) {
                out.write(buf, 0, read);
            }
        }
        finally {
            out.close();
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeGroovySourceToResponse(GroovyPageMetaInfo info, Writer out) throws IOException {
        InputStream in = info.getGroovySource();
        try {
            try {
                in.reset();
            }
            catch (IOException e) {
                // empty catch block
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            int lineNum = 1;
            int maxPaddingSize = 3;
            StringBuffer paddingBuffer = new StringBuffer(maxPaddingSize);
            for (int i = 0; i < maxPaddingSize; ++i) {
                paddingBuffer.append(' ');
            }
            String padding = paddingBuffer.toString();
            String line = reader.readLine();
            while (line != null) {
                String numberText = String.valueOf(lineNum);
                if (padding.length() + numberText.length() > 4) {
                    paddingBuffer.deleteCharAt(padding.length() - 1);
                    padding = paddingBuffer.toString();
                }
                out.write(padding);
                out.write(numberText);
                out.write(": ");
                out.write(line);
                out.write(10);
                line = reader.readLine();
                ++lineNum;
            }
        }
        finally {
            out.close();
            in.close();
        }
    }

    protected void formulateBinding(HttpServletRequest request, HttpServletResponse response, Binding binding, Writer out) throws IOException {
        this.formulateBindingFromWebRequest(binding, request, response, out, (GroovyObject)request.getAttribute("org.codehaus.groovy.grails.CONTROLLER"));
        this.populateViewModel(request, binding);
    }

    protected void populateViewModel(HttpServletRequest request, Binding binding) {
        Map variables = binding.getVariables();
        Enumeration attributeEnum = request.getAttributeNames();
        while (attributeEnum.hasMoreElements()) {
            String key = (String)attributeEnum.nextElement();
            if (!GroovyPage.isReservedName(key)) {
                if (variables.containsKey(key)) continue;
                binding.setVariable(key, request.getAttribute(key));
                continue;
            }
            LOG.debug((Object)("Variable [" + key + "] cannot be placed within the GSP model, the name used is a reserved name."));
        }
        for (Object o : this.additionalBinding.keySet()) {
            String key = (String)o;
            if (!GroovyPage.isReservedName(key)) {
                binding.setVariable(key, this.additionalBinding.get(key));
                continue;
            }
            LOG.debug((Object)("Variable [" + key + "] cannot be placed within the GSP model, the name used is a reserved name."));
        }
    }

    private void formulateBindingFromWebRequest(Binding binding, HttpServletRequest request, HttpServletResponse response, Writer out, GroovyObject controller) {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup(request);
        binding.setVariable("webRequest", (Object)webRequest);
        binding.setVariable("request", (Object)request);
        binding.setVariable("response", (Object)response);
        binding.setVariable("flash", (Object)webRequest.getFlashScope());
        binding.setVariable("application", (Object)this.context);
        ApplicationContext appCtx = webRequest.getAttributes().getApplicationContext();
        binding.setVariable("applicationContext", (Object)appCtx);
        if (appCtx != null) {
            GrailsApplication app = (GrailsApplication)appCtx.getBean("grailsApplication", GrailsApplication.class);
            binding.setVariable("grailsApplication", (Object)app);
            Map<String, Class> domainClassesWithoutPackage = GroovyPageWritable.getDomainClassMap(app);
            Map variables = binding.getVariables();
            variables.putAll(domainClassesWithoutPackage);
        }
        binding.setVariable("session", (Object)webRequest.getSession());
        binding.setVariable("params", (Object)webRequest.getParams());
        binding.setVariable("actionName", (Object)webRequest.getActionName());
        binding.setVariable("controllerName", (Object)webRequest.getControllerName());
        if (controller != null) {
            binding.setVariable("org.codehaus.groovy.grails.CONTROLLER", (Object)controller);
            binding.setVariable("pluginContextPath", controller.getProperty("pluginContextPath"));
        }
        binding.setVariable("out", (Object)out);
    }

    private static Map<String, Class> getDomainClassMap(GrailsApplication application) {
        GrailsClass[] domainClasses = application.getArtefacts("Domain");
        if (domainClasses.length == domainsWithoutPackage.size()) {
            return domainsWithoutPackage;
        }
        domainsWithoutPackage.clear();
        for (GrailsClass domainClass : domainClasses) {
            Class theClass = domainClass.getClazz();
            domainsWithoutPackage.put(theClass.getName(), theClass);
        }
        return domainsWithoutPackage;
    }
}

