/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.GrailsNameUtils;
import groovy.lang.GroovyObject;
import groovy.lang.MissingPropertyException;
import javax.servlet.ServletRequest;
import org.codehaus.groovy.grails.web.pages.FastStringWriter;

public class GroovyPageUtils {
    public static final String PATH_TO_VIEWS = "/WEB-INF/grails-app/views";
    private static final char SLASH = '/';
    private static final String SLASH_STR = "/";
    private static final String SLASH_UNDR = "/_";
    private static final String BLANK = "";
    private static final String UNDERSCORE = "_";

    public static String getTemplateURI(GroovyObject controller, String templateName) {
        if (controller == null) {
            throw new IllegalArgumentException("Argument [controller] cannot be null");
        }
        return GroovyPageUtils.getTemplateURI(GroovyPageUtils.getLogicalName(controller), templateName);
    }

    public static String getViewURI(GroovyObject controller, String viewName) {
        if (controller == null) {
            throw new IllegalArgumentException("Argument [controller] cannot be null");
        }
        return GroovyPageUtils.getViewURI(GroovyPageUtils.getLogicalName(controller), viewName);
    }

    public static String getNoSuffixViewURI(GroovyObject controller, String viewName) {
        if (controller == null) {
            throw new IllegalArgumentException("Argument [controller] cannot be null");
        }
        return GroovyPageUtils.getNoSuffixViewURI(GroovyPageUtils.getLogicalName(controller), viewName);
    }

    private static String getLogicalName(GroovyObject controller) {
        String logicalName;
        ServletRequest request = null;
        try {
            request = (ServletRequest)controller.getProperty("request");
        }
        catch (MissingPropertyException mpe) {
            // empty catch block
        }
        String string = logicalName = request != null ? (String)request.getAttribute("org.codehaus.groovy.grails.CONTROLLER_NAME_ATTRIBUTE") : null;
        if (logicalName == null) {
            logicalName = GrailsNameUtils.getLogicalPropertyName(controller.getClass().getName(), "Controller");
        }
        return logicalName;
    }

    public static String getTemplateURI(String controllerName, String templateName) {
        FastStringWriter buf = new FastStringWriter();
        if (templateName.startsWith(SLASH_STR)) {
            String tmp = templateName.substring(1, templateName.length());
            if (tmp.indexOf(47) > -1) {
                buf.append('/');
                int i = tmp.lastIndexOf(47);
                buf.append(tmp.substring(0, i));
                buf.append(SLASH_UNDR);
                buf.append(tmp.substring(i + 1, tmp.length()));
            } else {
                buf.append(SLASH_UNDR);
                buf.append(templateName.substring(1, templateName.length()));
            }
        } else {
            String pathToTemplate = BLANK;
            int lastSlash = templateName.lastIndexOf(47);
            if (lastSlash > -1) {
                pathToTemplate = templateName.substring(0, lastSlash + 1);
                templateName = templateName.substring(lastSlash + 1);
            }
            buf.append('/').append(controllerName).append('/').append(pathToTemplate).append(UNDERSCORE).append(templateName);
        }
        return buf.append(".gsp").toString();
    }

    public static String getViewURI(String controllerName, String viewName) {
        FastStringWriter buf = new FastStringWriter();
        return GroovyPageUtils.getViewURIInternal(controllerName, viewName, buf, true);
    }

    public static String getNoSuffixViewURI(String controllerName, String viewName) {
        FastStringWriter buf = new FastStringWriter();
        return GroovyPageUtils.getViewURIInternal(controllerName, viewName, buf, false);
    }

    public static String getDeployedViewURI(String controllerName, String viewName) {
        FastStringWriter buf = new FastStringWriter((Object)PATH_TO_VIEWS);
        return GroovyPageUtils.getViewURIInternal(controllerName, viewName, buf, true);
    }

    private static String getViewURIInternal(String controllerName, String viewName, FastStringWriter buf, boolean includeSuffix) {
        if (viewName.startsWith(SLASH_STR)) {
            String tmp = viewName.substring(1, viewName.length());
            if (tmp.indexOf(47) > -1) {
                buf.append('/');
                buf.append(tmp.substring(0, tmp.lastIndexOf(47)));
                buf.append('/');
                buf.append(tmp.substring(tmp.lastIndexOf(47) + 1, tmp.length()));
            } else {
                buf.append('/');
                buf.append(viewName.substring(1, viewName.length()));
            }
        } else {
            buf.append('/').append(controllerName).append('/').append(viewName);
        }
        if (includeSuffix) {
            return buf.append(".gsp").toString();
        }
        return buf.toString();
    }
}

