/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller.xml;

import grails.converters.XML;
import groovy.lang.GroovyObject;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyBeanMarshaller
implements ObjectMarshaller<XML> {
    @Override
    public boolean supports(Object object) {
        return object instanceof GroovyObject;
    }

    @Override
    public void marshalObject(Object o, XML xml) throws ConverterException {
        try {
            Field[] fields;
            PropertyDescriptor[] properties;
            BeanInfo info = Introspector.getBeanInfo(o.getClass());
            for (PropertyDescriptor property : properties = info.getPropertyDescriptors()) {
                String name = property.getName();
                Method readMethod = property.getReadMethod();
                if (readMethod == null || name.equals("metaClass")) continue;
                Object value = readMethod.invoke(o, (Object[])null);
                xml.startNode(name);
                xml.convertAnother(value);
                xml.end();
            }
            for (Field field : fields = o.getClass().getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                xml.startNode(field.getName());
                xml.convertAnother(field.get(o));
                xml.end();
            }
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConverterException("Error converting Bean with class " + o.getClass().getName(), e);
        }
    }
}

