/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.util.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class Metadata
extends Properties {
    public static final String FILE = "application.properties";
    public static final String APPLICATION_VERSION = "app.version";
    public static final String APPLICATION_NAME = "app.name";
    public static final String APPLICATION_GRAILS_VERSION = "app.grails.version";
    public static final String SERVLET_VERSION = "app.servlet.version";
    public static final String WAR_DEPLOYED = "grails.war.deployed";
    public static final String DEFAULT_SERVLET_VERSION = "2.4";
    private boolean initialized;
    private static Metadata metadata = new Metadata();
    private static File metadataFile;

    private Metadata() {
    }

    public static void reset() {
        metadata.clear();
        Metadata.metadata.initialized = false;
    }

    public static Metadata getCurrent() {
        if (!Metadata.metadata.initialized) {
            try {
                InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(FILE);
                if (input == null) {
                    input = Metadata.class.getClassLoader().getResourceAsStream(FILE);
                }
                if (input != null) {
                    metadata.load(input);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot load application metadata:" + e.getMessage(), e);
            }
            finally {
                Metadata.metadata.initialized = true;
            }
        }
        return metadata;
    }

    public static Metadata getInstance(InputStream inputStream) {
        metadata = new Metadata();
        try {
            metadata.load(inputStream);
            Metadata.metadata.initialized = true;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load application metadata:" + e.getMessage(), e);
        }
        return metadata;
    }

    public static Metadata getInstance(File file) {
        metadata = new Metadata();
        metadataFile = file;
        if (file != null && file.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                metadata.load(input);
                Metadata.metadata.initialized = true;
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot load application metadata:" + e.getMessage(), e);
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return metadata;
    }

    public static Metadata reload() {
        if (metadataFile != null) {
            metadata = Metadata.getInstance(metadataFile);
        }
        return metadata;
    }

    public String getApplicationVersion() {
        return (String)this.get(APPLICATION_VERSION);
    }

    public String getGrailsVersion() {
        return (String)this.get(APPLICATION_GRAILS_VERSION);
    }

    public String getEnvironment() {
        return (String)this.get(Environment.KEY);
    }

    public String getApplicationName() {
        return (String)this.get(APPLICATION_NAME);
    }

    public String getServletVersion() {
        String servletVersion = (String)this.get(SERVLET_VERSION);
        if (servletVersion == null) {
            return DEFAULT_SERVLET_VERSION;
        }
        return servletVersion;
    }

    public void persist() {
        if (this.propertiesHaveNotChanged()) {
            return;
        }
        if (metadataFile != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(metadataFile);
                this.store(out, "utf-8");
            }
            catch (Exception e) {
                throw new RuntimeException("Error persisting metadata to file [" + metadataFile + "]: " + e.getMessage(), e);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean propertiesHaveNotChanged() {
        Metadata transientMetadata = metadata;
        Metadata persistedMetadata = Metadata.reload();
        boolean result = transientMetadata.equals(persistedMetadata);
        metadata = transientMetadata;
        return result;
    }

    public synchronized Enumeration keys() {
        Enumeration<Object> keysEnum = super.keys();
        Vector<Object> keyList = new Vector<Object>();
        while (keysEnum.hasMoreElements()) {
            keyList.add(keysEnum.nextElement());
        }
        Collections.sort(keyList);
        return keyList.elements();
    }

    public boolean isWarDeployed() {
        Object val = this.get(WAR_DEPLOYED);
        return val != null && val.equals("true");
    }
}

