/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.filter;

import grails.util.GrailsUtil;
import groovy.lang.Writable;
import groovy.text.Template;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.spring.GrailsApplicationContext;
import org.codehaus.groovy.grails.commons.spring.GrailsRuntimeConfigurator;
import org.codehaus.groovy.grails.web.errors.GrailsWrappedRuntimeException;
import org.codehaus.groovy.grails.web.pages.GSPResponseWriter;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.servlet.DefaultGrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class GrailsReloadServletFilter
extends OncePerRequestFilter {
    public static final Log LOG = LogFactory.getLog(GrailsReloadServletFilter.class);
    private static final int BUFFER_SIZE = 8024;
    private GrailsApplicationContext context;
    private WebApplicationContext parent;
    private GrailsApplicationAttributes appAttributes;

    protected void initFilterBean() throws ServletException {
        super.initFilterBean();
        this.appAttributes = new DefaultGrailsApplicationAttributes(this.getServletContext());
        this.context = (GrailsApplicationContext)this.appAttributes.getApplicationContext();
        this.parent = (WebApplicationContext)this.getServletContext().getAttribute("org.codehaus.groovy.grails.PARENT_APPLICATION_CONTEXT");
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing Grails reload filter...");
        }
        try {
            GrailsApplication application = (GrailsApplication)this.context.getBean("grailsApplication");
            if (!application.isInitialised()) {
                application.rebuild();
                GrailsRuntimeConfigurator config = new GrailsRuntimeConfigurator(application, (ApplicationContext)this.parent);
                config.reconfigure(this.context, this.getServletContext(), true);
            }
        }
        catch (Exception e) {
            GrailsUtil.deepSanitize(e);
            LOG.error((Object)("Error occured reloading application: " + e.getMessage()), (Throwable)e);
            httpServletResponse.setStatus(500);
            GroovyPagesTemplateEngine engine = this.appAttributes.getPagesTemplateEngine();
            Template t = engine.createTemplate("/WEB-INF/grails-app/views/error.gsp");
            GrailsWrappedRuntimeException wrapped = new GrailsWrappedRuntimeException(this.getServletContext(), e);
            HashMap<String, GrailsWrappedRuntimeException> model = new HashMap<String, GrailsWrappedRuntimeException>();
            model.put("exception", wrapped);
            Writable w = t.make(model);
            Writer out = this.createResponseWriter(httpServletResponse);
            w.writeTo(out);
            return;
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    protected Writer createResponseWriter(HttpServletResponse response) {
        GSPResponseWriter out = GSPResponseWriter.getInstance((ServletResponse)response, 8024);
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        webRequest.setOut(out);
        return out;
    }
}

