/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class GrailsNameUtils {
    public static String getClassName(String logicalName, String trailingName) {
        if (GrailsNameUtils.isBlank(logicalName)) {
            throw new IllegalArgumentException("Argument [logicalName] cannot be null or blank");
        }
        String className = logicalName.substring(0, 1).toUpperCase() + logicalName.substring(1);
        if (trailingName != null) {
            className = className + trailingName;
        }
        return className;
    }

    public static String getClassNameRepresentation(String name) {
        StringBuffer buf = new StringBuffer();
        if (name != null && name.length() > 0) {
            String[] tokens = name.split("[^\\w\\d]");
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i].trim();
                buf.append(token.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(token.substring(1));
            }
        }
        String className = buf.toString();
        return className;
    }

    private static String getClassNameForLowerCaseHyphenSeparatedName(String name) {
        if (name.indexOf(45) > -1) {
            StringBuffer buf = new StringBuffer();
            String[] tokens = name.split("-");
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i];
                if (token == null || token.length() == 0) continue;
                buf.append(token.substring(0, 1).toUpperCase()).append(token.substring(1));
            }
            return buf.toString();
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String getLogicalName(Class clazz, String trailingName) {
        return GrailsNameUtils.getLogicalName(clazz.getName(), trailingName);
    }

    public static String getLogicalName(String name, String trailingName) {
        String shortName;
        if (!GrailsNameUtils.isBlank(trailingName) && (shortName = GrailsNameUtils.getShortName(name)).indexOf(trailingName) > -1) {
            return shortName.substring(0, shortName.length() - trailingName.length());
        }
        return name;
    }

    public static String getLogicalPropertyName(String className, String trailingName) {
        return GrailsNameUtils.getLogicalName(GrailsNameUtils.getPropertyName(className), trailingName);
    }

    public static String getPropertyName(String name) {
        return GrailsNameUtils.getPropertyNameRepresentation(name);
    }

    public static String getPropertyName(Class clazz) {
        return GrailsNameUtils.getPropertyNameRepresentation(clazz);
    }

    public static String getPropertyNameRepresentation(Class targetClass) {
        String shortName = GrailsNameUtils.getShortName(targetClass);
        return GrailsNameUtils.getPropertyNameRepresentation(shortName);
    }

    public static String getPropertyNameRepresentation(String name) {
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(pos + 1);
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        String propertyName = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        if (propertyName.indexOf(32) > -1) {
            propertyName = propertyName.replaceAll("\\s", "");
        }
        return propertyName;
    }

    public static String getPropertyNameForLowerCaseHyphenSeparatedName(String name) {
        return GrailsNameUtils.getPropertyName(GrailsNameUtils.getClassNameForLowerCaseHyphenSeparatedName(name));
    }

    public static String getShortName(Class targetClass) {
        String className = targetClass.getName();
        return GrailsNameUtils.getShortName(className);
    }

    public static String getShortName(String className) {
        int i = className.lastIndexOf(".");
        if (i > -1) {
            className = className.substring(i + 1, className.length());
        }
        return className;
    }

    public static String getScriptName(Class clazz) {
        return GrailsNameUtils.getScriptName(clazz.getName());
    }

    public static String getScriptName(String name) {
        if (name.endsWith(".groovy")) {
            name = name.substring(0, name.length() - 7);
        }
        String naturalName = GrailsNameUtils.getNaturalName(GrailsNameUtils.getShortName(name));
        return naturalName.replaceAll("\\s", "-").toLowerCase();
    }

    public static String getNameFromScript(String scriptName) {
        return GrailsNameUtils.getClassNameForLowerCaseHyphenSeparatedName(scriptName);
    }

    public static String getNaturalName(String name) {
        ArrayList<String> words = new ArrayList<String>();
        int i = 0;
        char[] chars = name.toCharArray();
        for (int j = 0; j < chars.length; ++j) {
            String w;
            char c = chars[j];
            if (i >= words.size()) {
                w = "";
                words.add(i, w);
            } else {
                w = (String)words.get(i);
            }
            if (Character.isLowerCase(c) || Character.isDigit(c)) {
                if (Character.isLowerCase(c) && w.length() == 0) {
                    c = Character.toUpperCase(c);
                } else if (w.length() > 1 && Character.isUpperCase(w.charAt(w.length() - 1))) {
                    w = "";
                    words.add(++i, w);
                }
                words.set(i, w + c);
                continue;
            }
            if (!Character.isUpperCase(c)) continue;
            if (i == 0 && w.length() == 0 || Character.isUpperCase(w.charAt(w.length() - 1))) {
                words.set(i, w + c);
                continue;
            }
            words.add(++i, String.valueOf(c));
        }
        StringBuffer buf = new StringBuffer();
        Iterator j = words.iterator();
        while (j.hasNext()) {
            String word = (String)j.next();
            buf.append(word);
            if (!j.hasNext()) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }
}

