/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.sitemesh;

import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.PageParserSelector;
import com.opensymphony.module.sitemesh.filter.PageFilter;
import com.opensymphony.module.sitemesh.util.Container;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.web.sitemesh.FactoryHolder;
import org.codehaus.groovy.grails.web.sitemesh.GrailsPageResponseWrapper;
import org.springframework.web.util.UrlPathHelper;

public class GrailsPageFilter
extends PageFilter {
    private static final Log LOG = LogFactory.getLog(GrailsPageFilter.class);
    private static final String HTML_EXT = ".html";
    private static final String UTF_8_ENCODING = "UTF-8";
    private static final String CONFIG_OPTION_GSP_ENCODING = "grails.views.gsp.encoding";

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this.filterConfig = filterConfig;
        FactoryHolder.setFactory(this.factory);
    }

    public void destroy() {
        super.destroy();
        FactoryHolder.setFactory(null);
    }

    public void doFilter(ServletRequest rq, ServletResponse rs, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)rq;
        if (rq.getAttribute("__sitemesh__filterapplied") != null || this.factory.isPathExcluded(this.extractRequestPath(request))) {
            chain.doFilter(rq, rs);
        } else {
            request.setAttribute("__sitemesh__filterapplied", (Object)Boolean.TRUE);
            this.factory.refresh();
            DecoratorMapper decoratorMapper = this.factory.getDecoratorMapper();
            HttpServletResponse response = (HttpServletResponse)rs;
            Page page = this.parsePage(request, response, chain);
            if (page != null) {
                page.setRequest(request);
                Decorator decorator = decoratorMapper.getDecorator(request, page);
                if (decorator != null && decorator.getPage() != null) {
                    this.applyDecorator(page, decorator, request, response);
                    return;
                }
                this.writeOriginal(request, response, page);
            }
        }
    }

    protected Page parsePage(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            GrailsPageResponseWrapper pageResponse = new GrailsPageResponseWrapper(response, (PageParserSelector)this.factory);
            UrlPathHelper urlHelper = new UrlPathHelper();
            String requestURI = urlHelper.getOriginatingRequestUri(request);
            if (requestURI.endsWith(HTML_EXT)) {
                String encoding = (String)ConfigurationHolder.getFlatConfig().get(CONFIG_OPTION_GSP_ENCODING);
                if (encoding == null) {
                    encoding = UTF_8_ENCODING;
                }
                pageResponse.setContentType("text/html;charset=" + encoding);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)pageResponse);
            Page result = (Page)request.getAttribute("__sitemesh__page");
            if (result == null) {
                result = pageResponse.getPage();
            }
            request.setAttribute("__sitemesh__using_stream", (Object)(pageResponse.isUsingStream() ? Boolean.TRUE : Boolean.FALSE));
            return result;
        }
        catch (IllegalStateException e) {
            if (Container.get() != 4) {
                throw e;
            }
            return null;
        }
    }

    private String extractRequestPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        String query = request.getQueryString();
        return (servletPath == null ? "" : servletPath) + (pathInfo == null ? "" : pathInfo) + (query == null ? "" : "?" + query);
    }

    private void writeOriginal(HttpServletRequest request, HttpServletResponse response, Page page) throws IOException {
        response.setContentLength(page.getContentLength());
        if (request.getAttribute("__sitemesh__using_stream").equals(Boolean.TRUE)) {
            PrintWriter writer = new PrintWriter((OutputStream)response.getOutputStream());
            page.writePage((Writer)writer);
            writer.flush();
            response.getOutputStream().flush();
        } else {
            page.writePage((Writer)response.getWriter());
            response.getWriter().flush();
        }
    }

    protected void applyDecorator(Page page, Decorator decorator, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uriPath = decorator.getURIPath();
        if (uriPath != null && uriPath.endsWith(".gsp")) {
            request.setAttribute("__sitemesh__page", (Object)page);
            this.detectContentTypeFromPage(page, response);
            RequestDispatcher rd = request.getRequestDispatcher(decorator.getURIPath());
            if (!response.isCommitted()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Rendering layout using forward: " + decorator.getURIPath()));
                }
                rd.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Rendering layout using include: " + decorator.getURIPath()));
                }
                request.setAttribute("org.codehaus.groovy.grails.GSP_TO_RENDER", (Object)decorator.getURIPath());
                rd.include((ServletRequest)request, (ServletResponse)response);
                request.removeAttribute("org.codehaus.groovy.grails.GSP_TO_RENDER");
            }
            while (decorator.getInitParameterNames().hasNext()) {
                String initParam = (String)decorator.getInitParameterNames().next();
                if (!initParam.startsWith("header.")) continue;
                response.setHeader(initParam.substring(initParam.indexOf(46)), decorator.getInitParameter(initParam));
            }
            request.removeAttribute("__sitemesh__page");
        } else {
            super.applyDecorator(page, decorator, request, response);
        }
    }

    private void detectContentTypeFromPage(Page page, HttpServletResponse response) {
        String contentType = page.getProperty("meta.http-equiv.Content-Type");
        if (contentType != null && "text/html".equals(response.getContentType())) {
            response.setContentType(contentType);
        }
    }
}

