/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.mvc;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MissingPropertyException;
import groovy.util.Proxy;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.collections.map.CompositeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;
import org.codehaus.groovy.grails.web.servlet.DefaultGrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.FlashScope;
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsControllerHelper;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.NoViewNameDefinedException;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.UnknownControllerException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.ModelAndView;

public class SimpleGrailsControllerHelper
implements GrailsControllerHelper {
    private GrailsApplication application;
    private ApplicationContext applicationContext;
    private Map chainModel = Collections.EMPTY_MAP;
    private ServletContext servletContext;
    private GrailsApplicationAttributes grailsAttributes;
    private GrailsWebRequest webRequest;
    private static final Log LOG = LogFactory.getLog(SimpleGrailsControllerHelper.class);
    private static final char SLASH = '/';
    private static final String PROPERTY_CHAIN_MODEL = "chainModel";
    private String id;
    private String controllerName;
    private String actionName;
    private String controllerActionURI;

    public SimpleGrailsControllerHelper(GrailsApplication application, ApplicationContext context, ServletContext servletContext) {
        this.application = application;
        this.applicationContext = context;
        this.servletContext = servletContext;
        this.grailsAttributes = new DefaultGrailsApplicationAttributes(this.servletContext);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public GrailsControllerClass getControllerClassByName(String name) {
        return (GrailsControllerClass)this.application.getArtefact("Controller", name);
    }

    public GrailsControllerClass getControllerClassByURI(String uri) {
        return (GrailsControllerClass)this.application.getArtefactForFeature("Controller", (Object)uri);
    }

    public GroovyObject getControllerInstance(GrailsControllerClass controllerClass) {
        return (GroovyObject)this.applicationContext.getBean(controllerClass.getFullName());
    }

    private void removeProxiesFromModelObjects(Map model) {
        for (Object current : model.keySet()) {
            Object modelObject = model.get(current);
            if (!(modelObject instanceof Proxy)) continue;
            model.put(current, ((Proxy)modelObject).getAdaptee());
        }
    }

    public ModelAndView handleURI(String uri, GrailsWebRequest webRequest) {
        return this.handleURI(uri, webRequest, Collections.EMPTY_MAP);
    }

    public ModelAndView handleURI(String uri, GrailsWebRequest webRequest, Map params) {
        GrailsControllerClass controllerClass;
        if (uri == null) {
            throw new IllegalArgumentException("Controller URI [" + uri + "] cannot be null!");
        }
        HttpServletRequest request = webRequest.getCurrentRequest();
        HttpServletResponse response = webRequest.getCurrentResponse();
        this.configureStateForWebRequest(webRequest, request);
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if ((controllerClass = this.getControllerClassByURI(uri)) == null) {
            throw new UnknownControllerException("No controller found for URI [" + uri + "]!");
        }
        this.actionName = controllerClass.getClosurePropertyName(uri);
        webRequest.setActionName(this.actionName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing request for controller [" + this.controllerName + "], action [" + this.actionName + "], and id [" + this.id + "]"));
        }
        this.controllerActionURI = '/' + this.controllerName + '/' + this.actionName + '/';
        GroovyObject controller = this.getControllerInstance(controllerClass);
        if (!controllerClass.isHttpMethodAllowedForAction(controller, request.getMethod(), this.actionName)) {
            try {
                response.sendError(405);
                return null;
            }
            catch (IOException e) {
                throw new ControllerExecutionException("I/O error sending 403 error", e);
            }
        }
        request.setAttribute("org.codehaus.groovy.grails.CONTROLLER", (Object)controller);
        request.setAttribute("org.codehaus.groovy.grails.GRAILS_APPLICATION_ATTRIBUTES", (Object)this.grailsAttributes);
        String viewName = controllerClass.getViewByURI(uri);
        boolean executeAction = this.invokeBeforeInterceptor(controller, controllerClass);
        if (!executeAction) {
            return null;
        }
        ModelAndView mv = this.executeAction(controller, controllerClass, viewName, request, response, params);
        boolean returnModelAndView = this.invokeAfterInterceptor(controllerClass, controller, mv) && !response.isCommitted();
        return returnModelAndView ? mv : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ModelAndView executeAction(GroovyObject controller, GrailsControllerClass controllerClass, String viewName, HttpServletRequest request, HttpServletResponse response, Map params) {
        ModelAndView modelAndView;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Closure action;
            try {
                action = (Closure)controller.getProperty(this.actionName);
            }
            catch (MissingPropertyException mpe) {
                ModelAndView modelAndView2;
                try {
                    response.sendError(404);
                    modelAndView2 = null;
                }
                catch (IOException e) {
                    throw new ControllerExecutionException("I/O error sending 404 error", e);
                }
                Object var13_15 = null;
                Thread.currentThread().setContextClassLoader(cl);
                return modelAndView2;
            }
            Object returnValue = this.handleAction(controller, action, request, response, params);
            this.initChainModel(controller);
            if (response.isCommitted()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Response has been redirected, returning null model and view");
                }
                ModelAndView e = null;
                Object var13_16 = null;
                Thread.currentThread().setContextClassLoader(cl);
                return e;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Action [" + this.actionName + "] executed with result [" + returnValue + "] and view name [" + viewName + "]"));
            }
            ModelAndView mv = this.handleActionResponse(controller, returnValue, this.actionName, viewName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Action [" + this.actionName + "] handled, created Spring model and view [" + mv + "]"));
            }
            modelAndView = mv;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            Thread.currentThread().setContextClassLoader(cl);
            throw throwable;
        }
        Object var13_17 = null;
        Thread.currentThread().setContextClassLoader(cl);
        return modelAndView;
    }

    private boolean invokeBeforeInterceptor(GroovyObject controller, GrailsControllerClass controllerClass) {
        Closure beforeInterceptor;
        boolean executeAction = true;
        if (controllerClass.isInterceptedBefore(controller, this.actionName) && (beforeInterceptor = controllerClass.getBeforeInterceptor(controller)) != null) {
            Object interceptorResult;
            if (beforeInterceptor.getDelegate() != controller) {
                beforeInterceptor.setDelegate((Object)controller);
                beforeInterceptor.setResolveStrategy(1);
            }
            if ((interceptorResult = beforeInterceptor.call()) instanceof Boolean) {
                executeAction = (Boolean)interceptorResult;
            }
        }
        return executeAction;
    }

    private void configureStateForWebRequest(GrailsWebRequest webRequest, HttpServletRequest request) {
        this.webRequest = webRequest;
        this.actionName = webRequest.getActionName();
        this.controllerName = webRequest.getControllerName();
        this.id = webRequest.getId();
        if (StringUtils.isBlank((String)this.id) && request.getParameter("id") != null) {
            this.id = request.getParameter("id");
        }
    }

    private boolean invokeAfterInterceptor(GrailsControllerClass controllerClass, GroovyObject controller, ModelAndView mv) {
        Object interceptorResult = null;
        if (controllerClass.isInterceptedAfter(controller, this.actionName)) {
            Closure afterInterceptor = controllerClass.getAfterInterceptor(controller);
            if (afterInterceptor.getDelegate() != controller) {
                afterInterceptor.setDelegate((Object)controller);
                afterInterceptor.setResolveStrategy(1);
            }
            Map model = new HashMap();
            if (mv != null) {
                model = mv.getModel() != null ? mv.getModel() : new HashMap();
            }
            switch (afterInterceptor.getMaximumNumberOfParameters()) {
                case 1: {
                    interceptorResult = afterInterceptor.call(new Object[]{model});
                    break;
                }
                case 2: {
                    interceptorResult = afterInterceptor.call(new Object[]{model, mv});
                    break;
                }
                default: {
                    throw new ControllerExecutionException("AfterInterceptor closure must accept one or two parameters");
                }
            }
        }
        return interceptorResult == null || !(interceptorResult instanceof Boolean) || (Boolean)interceptorResult != false;
    }

    public GrailsApplicationAttributes getGrailsAttributes() {
        return this.grailsAttributes;
    }

    public Object handleAction(GroovyObject controller, Closure action, HttpServletRequest request, HttpServletResponse response) {
        return this.handleAction(controller, action, request, response, Collections.EMPTY_MAP);
    }

    public Object handleAction(GroovyObject controller, Closure action, HttpServletRequest request, HttpServletResponse response, Map params) {
        GrailsParameterMap paramsMap = (GrailsParameterMap)controller.getProperty("params");
        if (params != null && !params.isEmpty()) {
            paramsMap.putAll(params);
        }
        Object returnValue = action.call();
        request.setAttribute("org.codehaus.groovy.grails.ERRORS", controller.getProperty("errors"));
        return returnValue;
    }

    public ModelAndView handleActionResponse(GroovyObject controller, Object returnValue, String closurePropertyName, String viewName) {
        boolean viewNameBlank = viewName == null || viewName.length() == 0;
        ModelAndView explicityModelAndView = (ModelAndView)controller.getProperty("modelAndView");
        if (!this.webRequest.isRenderView()) {
            return null;
        }
        if (explicityModelAndView != null) {
            return explicityModelAndView;
        }
        if (returnValue == null) {
            if (viewNameBlank) {
                return null;
            }
            Object model = !this.chainModel.isEmpty() ? new CompositeMap(this.chainModel, (Map)new BeanMap((Object)controller)) : new BeanMap((Object)controller);
            return new ModelAndView(viewName, (Map)model);
        }
        if (returnValue instanceof Map) {
            Map returnModel = (Map)returnValue;
            this.removeProxiesFromModelObjects(returnModel);
            if (!this.chainModel.isEmpty()) {
                returnModel.putAll(this.chainModel);
            }
            return new ModelAndView(viewName, returnModel);
        }
        if (returnValue instanceof ModelAndView) {
            ModelAndView modelAndView = (ModelAndView)returnValue;
            Map modelMap = modelAndView.getModel();
            this.removeProxiesFromModelObjects(modelMap);
            if (!this.chainModel.isEmpty()) {
                modelAndView.addAllObjects(this.chainModel);
            }
            if (modelAndView.getView() == null && modelAndView.getViewName() == null) {
                if (viewNameBlank) {
                    throw new NoViewNameDefinedException("ModelAndView instance returned by and no view name defined by nor for closure on property [" + closurePropertyName + "] in controller [" + controller.getClass() + "]!");
                }
                modelAndView.setViewName(viewName);
            }
            return modelAndView;
        }
        Object model = !this.chainModel.isEmpty() ? new CompositeMap(this.chainModel, (Map)new BeanMap((Object)controller)) : new BeanMap((Object)controller);
        return new ModelAndView(viewName, (Map)model);
    }

    private void initChainModel(GroovyObject controller) {
        FlashScope fs = this.grailsAttributes.getFlashScope((ServletRequest)((HttpServletRequest)controller.getProperty("request")));
        if (fs.containsKey(PROPERTY_CHAIN_MODEL)) {
            this.chainModel = (Map)fs.get(PROPERTY_CHAIN_MODEL);
            if (this.chainModel == null) {
                this.chainModel = Collections.EMPTY_MAP;
            }
        }
    }
}

