/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.view;

import grails.util.GrailsUtil;
import groovy.lang.Writable;
import groovy.text.Template;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.errors.GrailsWrappedRuntimeException;
import org.codehaus.groovy.grails.web.pages.GSPResponseWriter;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class GroovyPageView
extends AbstractUrlBasedView {
    private static final Log LOG = LogFactory.getLog(GroovyPageView.class);
    private static final int BUFFER_SIZE = 8024;
    private static final String ERRORS_VIEW = "/WEB-INF/grails-app/views/error.gsp";
    public static final String EXCEPTION_MODEL_KEY = "exception";

    protected final void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.exposeModelAsRequestAttributes(model, request);
        GroovyPagesTemplateEngine templateEngine = (GroovyPagesTemplateEngine)((Object)this.getApplicationContext().getBean("groovyPagesTemplateEngine"));
        if (templateEngine == null) {
            throw new IllegalStateException("No GroovyPagesTemplateEngine found in ApplicationContext!");
        }
        this.renderWithTemplateEngine(templateEngine, model, response, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderWithTemplateEngine(GroovyPagesTemplateEngine templateEngine, Map model, HttpServletResponse response, HttpServletRequest request) throws IOException {
        Template t = templateEngine.createTemplate(this.getUrl());
        Writable w = t.make(model);
        Writer out = null;
        try {
            out = this.createResponseWriter(response);
            w.writeTo(out);
        }
        catch (Exception e) {
            out = this.createResponseWriter(response);
            this.handleException(e, out, templateEngine, request);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected void handleException(Exception exception, Writer out, GroovyPagesTemplateEngine engine, HttpServletRequest request) {
        GrailsUtil.deepSanitize(exception);
        LOG.error((Object)("Error processing GroovyPageView: " + exception.getMessage()), (Throwable)exception);
        try {
            request.setAttribute("org.codehaus.groovy.grails.CONTROLLER", null);
            Template t = engine.createTemplate(ERRORS_VIEW);
            HashMap<String, GrailsWrappedRuntimeException> model = new HashMap<String, GrailsWrappedRuntimeException>();
            model.put(EXCEPTION_MODEL_KEY, new GrailsWrappedRuntimeException(this.getServletContext(), exception));
            Writable w = t.make(model);
            w.writeTo(out);
        }
        catch (Throwable t) {
            LOG.error((Object)("Error attempting to render errors view : " + t.getMessage()), t);
            LOG.error((Object)("Original exception : " + exception.getMessage()), (Throwable)exception);
        }
    }

    protected Writer createResponseWriter(HttpServletResponse response) {
        GSPResponseWriter out = GSPResponseWriter.getInstance((ServletResponse)response, 8024);
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        webRequest.setOut(out);
        return out;
    }
}

