/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.web.errors.GrailsWrappedRuntimeException;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.codehaus.groovy.grails.web.mapping.exceptions.UrlMappingException;
import org.codehaus.groovy.grails.web.servlet.GrailsDispatcherServlet;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequestFilter;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class ErrorHandlingServlet
extends GrailsDispatcherServlet {
    private static final String TEXT_HTML = "text/html";
    private static final String GSP_SUFFIX = ".gsp";
    private static final String JSP_SUFFIX = ".jsp";

    protected HttpServletRequest checkMultipart(HttpServletRequest request) throws MultipartException {
        return request;
    }

    protected void doDispatch(final HttpServletRequest request, final HttpServletResponse response) throws Exception {
        UrlMappingsHolder urlMappingsHolder;
        UrlMappingInfo urlMappingInfo;
        Throwable t;
        int statusCode = request.getAttribute("javax.servlet.error.status_code") != null ? Integer.parseInt(request.getAttribute("javax.servlet.error.status_code").toString()) : 500;
        if (request.getAttribute("javax.servlet.error.exception") != null && !((t = (Throwable)request.getAttribute("javax.servlet.error.exception")) instanceof GrailsWrappedRuntimeException) && request.getAttribute("exception") == null) {
            request.setAttribute("exception", (Object)new GrailsWrappedRuntimeException(this.getServletContext(), t));
        }
        if ((urlMappingInfo = (urlMappingsHolder = this.lookupUrlMappings()).matchStatusCode(statusCode)) != null) {
            GrailsWebRequestFilter grailsWebRequestFilter = new GrailsWebRequestFilter();
            grailsWebRequestFilter.setServletContext(this.getServletContext());
            grailsWebRequestFilter.doFilter((ServletRequest)request, (ServletResponse)response, new FilterChain(){

                public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                    GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.getRequestAttributes();
                    urlMappingInfo.configure(webRequest);
                    String viewName = urlMappingInfo.getViewName();
                    if (viewName == null || viewName.endsWith(ErrorHandlingServlet.GSP_SUFFIX) || viewName.endsWith(ErrorHandlingServlet.JSP_SUFFIX)) {
                        WebUtils.forwardRequestForUrlMappingInfo(request, response, urlMappingInfo);
                    } else {
                        ViewResolver viewResolver = WebUtils.lookupViewResolver(ErrorHandlingServlet.this.getServletContext());
                        if (viewResolver != null) {
                            try {
                                View v = WebUtils.resolveView(request, urlMappingInfo, viewName, viewResolver);
                                v.render(Collections.EMPTY_MAP, request, response);
                            }
                            catch (Exception e) {
                                throw new UrlMappingException("Error mapping onto view [" + viewName + "]: " + e.getMessage(), e);
                            }
                        }
                    }
                }
            });
        } else {
            this.renderDefaultResponse(response, statusCode);
        }
    }

    private void renderDefaultResponse(HttpServletResponse response, int statusCode) throws IOException {
        if (statusCode == 404) {
            this.renderDefaultResponse(response, statusCode, "Not Found", "Page not found.");
        } else {
            this.renderDefaultResponse(response, statusCode, "Internal Error", "Internal server error.");
        }
    }

    private void renderDefaultResponse(HttpServletResponse response, int statusCode, String title, String text) throws IOException {
        response.setStatus(404);
        response.setContentType(TEXT_HTML);
        PrintWriter writer = response.getWriter();
        ((Writer)writer).write("<HTML>\n<HEAD>\n<TITLE>Error " + statusCode + " - " + title);
        ((Writer)writer).write("</TITLE>\n<BODY>\n<H2>Error " + statusCode + " - " + title + ".</H2>\n");
        ((Writer)writer).write(text + "<BR/>");
        for (int i = 0; i < 20; ++i) {
            ((Writer)writer).write("\n<!-- Padding for IE                  -->");
        }
        ((Writer)writer).write("\n</BODY>\n</HTML>\n");
        ((Writer)writer).flush();
    }

    private UrlMappingsHolder lookupUrlMappings() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (UrlMappingsHolder)wac.getBean("grailsUrlMappingsHolder");
    }
}

