/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.support.StaticResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class GroovyPageResourceLoader
extends StaticResourceLoader {
    private static final Log LOG = LogFactory.getLog(GroovyPageResourceLoader.class);
    public static final String BEAN_ID = "groovyPageResourceLoader";
    private Resource localBaseResource;
    private static final String PLUGINS = "/plugins";

    public void setBaseResource(Resource baseResource) {
        this.localBaseResource = baseResource;
        super.setBaseResource(baseResource);
    }

    public Resource getResource(String location) {
        Resource r;
        if (StringUtils.isBlank((String)location)) {
            throw new IllegalArgumentException("Argument [location] cannot be null or blank");
        }
        if (location.startsWith(PLUGINS) && (r = super.getResource(location.substring(1))).exists()) {
            return r;
        }
        Resource resource = super.getResource(location = this.getRealLocationInProject(location));
        if (!resource.exists()) {
            String pluginPath;
            int firstSlash;
            if (location.startsWith("grails-app/views/")) {
                Resource tmp = super.getResource(location.substring("grails-app/views/".length(), location.length()));
                if (tmp.exists()) {
                    resource = tmp;
                }
            } else if (location.startsWith("plugins/") && (firstSlash = (pluginPath = location.substring(8, location.length())).indexOf(47)) > -1) {
                String pluginName = pluginPath.substring(0, firstSlash);
                String viewPath = pluginPath.substring(firstSlash + 1, pluginPath.length());
                Resource pluginBase = GrailsPluginUtils.getPluginDirForName((String)pluginName);
                if (pluginBase != null) {
                    try {
                        FileSystemResource tmp = new FileSystemResource(pluginBase.getFile().getAbsolutePath() + '/' + viewPath);
                        if (tmp.exists()) {
                            resource = tmp;
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resolved GSP location [" + location + "] to resource [" + resource + "] (exists? [" + resource.exists() + "]) using base resource [" + this.localBaseResource + "]"));
        }
        return resource;
    }

    protected String getRealLocationInProject(String location) {
        if (location.startsWith("/WEB-INF")) {
            return location.substring("/WEB-INF".length() + 1);
        }
        return "web-app" + location;
    }
}

