/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping.filter;

import grails.util.GrailsUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.codehaus.groovy.grails.web.mapping.exceptions.UrlMappingException;
import org.codehaus.groovy.grails.web.mime.MimeType;
import org.codehaus.groovy.grails.web.servlet.WrappedResponseHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.util.UrlPathHelper;

public class UrlMappingsFilter
extends OncePerRequestFilter {
    private UrlPathHelper urlHelper = new UrlPathHelper();
    private static final Log LOG = LogFactory.getLog(UrlMappingsFilter.class);
    private static final String GSP_SUFFIX = ".gsp";
    private static final String JSP_SUFFIX = ".jsp";

    protected void initFilterBean() throws ServletException {
        super.initFilterBean();
        this.urlHelper.setUrlDecode(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String format;
        UrlMappingsHolder holder = WebUtils.lookupUrlMappings(this.getServletContext());
        GrailsApplication application = WebUtils.lookupApplication(this.getServletContext());
        GrailsWebRequest webRequest = (GrailsWebRequest)request.getAttribute("org.codehaus.groovy.grails.WEB_REQUEST");
        GrailsClass[] controllers = application.getArtefacts("Controller");
        if (controllers == null || controllers.length == 0 || holder == null) {
            this.processFilterChain(request, response, filterChain);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing URL mapping filter...");
            LOG.debug((Object)holder);
        }
        String uri = this.urlHelper.getPathWithinApplication(request);
        if (WebUtils.areFileExtensionsEnabled() && (format = WebUtils.getFormatFromURI(uri)) != null) {
            MimeType[] configuredMimes = MimeType.getConfiguredMimeTypes();
            for (int i = 0; i < configuredMimes.length; ++i) {
                MimeType configuredMime = configuredMimes[i];
                if (!configuredMime.getExtension().equals(format)) continue;
                request.setAttribute("org.codehaus.groovy.grails.CONTENT_FORMAT", (Object)format);
                uri = uri.substring(0, uri.length() - format.length() - 1);
                break;
            }
        }
        UrlMappingInfo[] urlInfos = holder.matchAll(uri);
        WrappedResponseHolder.setWrappedResponse(response);
        boolean dispatched = false;
        try {
            Map backupParameters;
            try {
                backupParameters = new HashMap(webRequest.getParams());
            }
            catch (Exception e) {
                GrailsUtil.deepSanitize(e);
                LOG.error((Object)("Error creating params object: " + e.getMessage()), (Throwable)e);
                backupParameters = Collections.EMPTY_MAP;
            }
            for (int i = 0; i < urlInfos.length; ++i) {
                String viewName;
                UrlMappingInfo info;
                block19: {
                    info = urlInfos[i];
                    if (info == null) continue;
                    webRequest.getParams().clear();
                    webRequest.getParams().putAll(backupParameters);
                    try {
                        info.configure(webRequest);
                        String action = info.getActionName() == null ? "" : info.getActionName();
                        viewName = info.getViewName();
                        if (viewName != null) break block19;
                        String controllerName = info.getControllerName();
                        GrailsClass controller = application.getArtefactForFeature("Controller", (Object)('/' + controllerName + '/' + action));
                        if (controller == null) {
                        }
                        break block19;
                    }
                    catch (Exception e) {
                        GrailsUtil.deepSanitize(e);
                        LOG.error((Object)("Error when matching URL mapping [" + info + "]:" + e.getMessage()), (Throwable)e);
                    }
                    continue;
                }
                dispatched = true;
                if (viewName == null || viewName.endsWith(GSP_SUFFIX) || viewName.endsWith(JSP_SUFFIX)) {
                    String forwardUrl = WebUtils.forwardRequestForUrlMappingInfo(request, response, info);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Matched URI [" + uri + "] to URL mapping [" + info + "], forwarding to [" + forwardUrl + "] with response [" + response.getClass() + "]"));
                    }
                    break;
                }
                ViewResolver viewResolver = WebUtils.lookupViewResolver(this.getServletContext());
                if (viewResolver == null) break;
                try {
                    View v = WebUtils.resolveView(request, info, viewName, viewResolver);
                    v.render(Collections.EMPTY_MAP, request, response);
                    break;
                }
                catch (Exception e) {
                    GrailsUtil.deepSanitize(e);
                    throw new UrlMappingException("Error mapping onto view [" + viewName + "]: " + e.getMessage(), e);
                }
            }
        }
        finally {
            WrappedResponseHolder.setWrappedResponse(null);
        }
        if (!dispatched) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No match found, processing remaining filter chain.");
            }
            this.processFilterChain(request, response, filterChain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFilterChain(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            WrappedResponseHolder.setWrappedResponse(response);
            if (filterChain != null) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        finally {
            WrappedResponseHolder.setWrappedResponse(null);
        }
    }
}

