/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.util.GrailsWebUtil;
import groovy.util.BuilderSupport;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.web.json.JSONException;
import org.codehaus.groovy.grails.web.json.JSONWriter;

public class JSonBuilder
extends BuilderSupport {
    private static final String ARRAY = "a";
    private static final String JSON_BUILDER = "JSON Builder: ";
    private static final String OBJECT = "o";
    private static final String TEXT_JSON = "application/json";
    private static final String UTF_8 = "UTF-8";
    private Stack stack = new Stack();
    private boolean start = true;
    private JSONWriter writer;

    public JSonBuilder(HttpServletResponse response) throws IOException {
        this(response.getWriter());
        if (response.getContentType() == null) {
            response.setContentType(GrailsWebUtil.getContentType(TEXT_JSON, UTF_8));
        }
    }

    public JSonBuilder(JSONWriter _writer) {
        this.writer = _writer;
    }

    public JSonBuilder(Writer writer) {
        this(new JSONWriter(new PrintWriter(writer)));
    }

    protected Object createNode(Object name) {
        int retVal = 1;
        try {
            if (this.start) {
                this.start = false;
                this.writeObject();
            } else {
                if (this.getCurrent() == null && this.stack.peek().equals(OBJECT)) {
                    throw new IllegalArgumentException("JSON Builder: only call to [element { }] is allowed when creating array");
                }
                if (this.stack.peek().equals(ARRAY)) {
                    this.writeObject();
                    retVal = 2;
                }
                this.writer.key(String.valueOf(name)).array();
                this.stack.push(ARRAY);
            }
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("JSON Builder: invalid element");
        }
        return new Integer(retVal);
    }

    protected Object createNode(Object key, Map valueMap) {
        try {
            if (this.stack.peek().equals(OBJECT)) {
                this.writer.key(String.valueOf(key));
            }
            this.writer.object();
            for (Map.Entry element : valueMap.entrySet()) {
                this.writer.key(String.valueOf(element.getKey())).value(element.getValue());
            }
            this.writer.endObject();
            return null;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("JSON Builder: invalid element");
        }
    }

    protected Object createNode(Object arg0, Map arg1, Object arg2) {
        throw new IllegalArgumentException("JSON Builder: not implemented");
    }

    protected Object createNode(Object key, Object value) {
        if (this.getCurrent() == null && this.stack.peek().equals(OBJECT)) {
            throw new IllegalArgumentException("JSON Builder: only call to [element { }] is allowed when creating array");
        }
        try {
            int retVal = 0;
            if (this.stack.peek().equals(ARRAY)) {
                this.writeObject();
                retVal = 1;
            }
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                this.writer.key(String.valueOf(key));
                this.handleCollectionRecurse(c);
            } else {
                this.writer.key(String.valueOf(key)).value(value);
            }
            return retVal != 0 ? new Integer(retVal) : null;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("JSON Builder: invalid element");
        }
    }

    private void handleCollectionRecurse(Collection c) throws JSONException {
        this.writer.array();
        for (Object element : c) {
            if (element instanceof Collection) {
                this.handleCollectionRecurse((Collection)element);
                continue;
            }
            this.writer.value(element);
        }
        this.writer.endArray();
    }

    protected void nodeCompleted(Object parent, Object node) {
        Object last = null;
        if (node != null) {
            try {
                int i = (Integer)node;
                while (i-- > 0) {
                    last = this.stack.pop();
                    if (ARRAY.equals(last)) {
                        this.writer.endArray();
                    }
                    if (!OBJECT.equals(last)) continue;
                    this.writer.endObject();
                }
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("JSON Builder: invalid element on the stack");
            }
        }
    }

    protected void setParent(Object arg0, Object arg1) {
    }

    private void writeObject() throws JSONException {
        this.writer.object();
        this.stack.push(OBJECT);
    }
}

