/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.support.StaticResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class GroovyPageResourceLoader
extends StaticResourceLoader {
    private static final Log LOG = LogFactory.getLog(GroovyPageResourceLoader.class);
    public static final String BEAN_ID = "groovyPageResourceLoader";
    private Resource localBaseResource;
    private static final String PLUGINS_PATH = "plugins/";

    public void setBaseResource(Resource baseResource) {
        this.localBaseResource = baseResource;
        super.setBaseResource(baseResource);
    }

    public Resource getResource(String location) {
        Resource r;
        if (StringUtils.isBlank((String)location)) {
            throw new IllegalArgumentException("Argument [location] cannot be null or blank");
        }
        if (location.startsWith(PLUGINS_PATH) && (r = super.getResource(location.substring(1))).exists()) {
            return r;
        }
        Resource resource = super.getResource(location = this.getRealLocationInProject(location));
        if (!resource.exists() && location.startsWith(PLUGINS_PATH)) {
            if (location.equals(PLUGINS_PATH)) {
                return new FileSystemResource((String)GrailsPluginUtils.getPluginBaseDirectories().get(0));
            }
            Resource pluginResource = this.lookupResourceForPluginPath(location);
            if (pluginResource != null) {
                resource = pluginResource;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resolved GSP location [" + location + "] to resource [" + resource + "] (exists? [" + resource.exists() + "]) using base resource [" + this.localBaseResource + "]"));
        }
        return resource;
    }

    protected Resource lookupResourceForPluginPath(String location) {
        FileSystemResource resource = null;
        String pluginPath = location.substring(8, location.length());
        int firstSlash = pluginPath.indexOf(47);
        if (firstSlash > -1) {
            String pluginName = pluginPath.substring(0, firstSlash);
            String viewPath = pluginPath.substring(firstSlash + 1, pluginPath.length());
            Resource pluginBase = GrailsPluginUtils.getPluginDirForName((String)pluginName);
            if (pluginBase != null) {
                try {
                    FileSystemResource tmp = new FileSystemResource(pluginBase.getFile().getAbsolutePath() + '/' + viewPath);
                    if (tmp.exists()) {
                        resource = tmp;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return resource;
    }

    protected String getRealLocationInProject(String location) {
        if (location.startsWith("/WEB-INF")) {
            return location.substring("/WEB-INF".length() + 1);
        }
        return "web-app" + location;
    }
}

