/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters;

import groovy.lang.Closure;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.web.converters.AbstractConverter;
import org.codehaus.groovy.grails.web.converters.Converter;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ConverterUtil {
    private static final Log log = LogFactory.getLog(ConverterUtil.class);
    private static ConverterUtil INSTANCE;
    private static final String PERSISTENCE_BEAN_WRAPPER_CLASS = "org.codehaus.groovy.grails.orm.hibernate.support.HibernateBeanWrapper";
    private GrailsApplication grailsApplication;

    public static BeanWrapper createBeanWrapper(Object o) {
        BeanWrapperImpl beanWrapper;
        try {
            Class<?> c = Class.forName(PERSISTENCE_BEAN_WRAPPER_CLASS);
            Constructor<?> init = c.getConstructor(Object.class);
            beanWrapper = (BeanWrapper)init.newInstance(o);
        }
        catch (Exception e) {
            beanWrapper = new BeanWrapperImpl(o);
        }
        return beanWrapper;
    }

    protected Object extractIdValue(Object domainObject, GrailsDomainClassProperty idProperty) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(domainObject);
        return beanWrapper.getPropertyValue(idProperty.getName());
    }

    public static Object createConverter(Class converterClass, Object target) throws ConverterException {
        return ConverterUtil.createConverter(converterClass, target, null);
    }

    public static Object createConverter(Class converterClass, Object target, ApplicationContext applicationContext) throws ConverterException {
        try {
            AbstractConverter converter = (AbstractConverter)converterClass.newInstance();
            if (converter instanceof ApplicationContextAware && applicationContext != null) {
                ((ApplicationContextAware)converter).setApplicationContext(applicationContext);
            }
            converter.setTarget(target);
            return converter;
        }
        catch (Exception e) {
            throw new ConverterException("Initialization of Converter Object " + converterClass.getName() + " failed for target " + target.getClass().getName(), e);
        }
    }

    public static GrailsDomainClass getDomainClass(String name) {
        name = ConverterUtil.trimProxySuffix(name);
        return (GrailsDomainClass)ConverterUtil.getGrailsApplication().getArtefact("Domain", name);
    }

    private static String trimProxySuffix(String name) {
        int i = name.indexOf("$$");
        if (i > -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    private static GrailsApplication getGrailsApplication() {
        return ConverterUtil.getInstance().grailsApplication;
    }

    protected static ConverterUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConverterUtil();
        }
        return INSTANCE;
    }

    public static boolean isConverterClass(Class clazz) {
        return Converter.class.isAssignableFrom(clazz);
    }

    public static boolean isDomainClass(Class clazz) {
        String name = ConverterUtil.trimProxySuffix(clazz.getName());
        return ConverterUtil.getGrailsApplication() != null && ConverterUtil.getGrailsApplication().isArtefactOfType("Domain", name);
    }

    public static Set getDomainClassNames() {
        return ConverterUtil.getGrailsApplication().getArtefactInfo("Domain").getClassesByName().keySet();
    }

    public static void setGrailsApplication(GrailsApplication grailsApp) {
        ConverterUtil.getInstance().grailsApplication = grailsApp;
    }

    protected ConverterUtil() {
    }

    public static Object invokeOriginalAsTypeMethod(Object delegate, Class clazz) {
        if (delegate instanceof Collection) {
            return DefaultGroovyMethods.asType((Collection)((Collection)delegate), (Class)clazz);
        }
        if (delegate instanceof Closure) {
            return DefaultGroovyMethods.asType((Closure)((Closure)delegate), (Class)clazz);
        }
        if (delegate instanceof Map) {
            return DefaultGroovyMethods.asType((Map)((Map)delegate), (Class)clazz);
        }
        if (delegate instanceof Number) {
            return DefaultGroovyMethods.asType((Number)((Number)delegate), (Class)clazz);
        }
        if (delegate instanceof File) {
            return DefaultGroovyMethods.asType((File)((File)delegate), (Class)clazz);
        }
        if (delegate instanceof String) {
            return DefaultGroovyMethods.asType((String)((String)delegate), (Class)clazz);
        }
        return DefaultGroovyMethods.asType((Object)delegate, (Class)clazz);
    }

    public static ConverterException resolveConverterException(Throwable t) {
        return t instanceof ConverterException ? (ConverterException)t : new ConverterException(t);
    }

    public static Converter.CircularReferenceBehaviour resolveCircularReferenceBehaviour(String str) {
        return Converter.CircularReferenceBehaviour.valueOf(str);
    }
}

